/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.datatable;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.datatable.DataTableImplV2;
import org.apache.pinot.common.datatable.DataTableImplV3;
import org.apache.pinot.common.datatable.DataTableImplV4;

public class DataTableFactory {
    public static final int VERSION_2 = 2;
    public static final int VERSION_3 = 3;
    public static final int VERSION_4 = 4;

    private DataTableFactory() {
    }

    public static DataTable getDataTable(ByteBuffer byteBuffer) throws IOException {
        int version = byteBuffer.getInt();
        switch (version) {
            case 2: {
                return new DataTableImplV2(byteBuffer);
            }
            case 3: {
                return new DataTableImplV3(byteBuffer);
            }
            case 4: {
                return new DataTableImplV4(byteBuffer);
            }
        }
        throw new IllegalStateException("Unsupported data table version: " + version);
    }

    public static DataTable getDataTable(byte[] bytes) throws IOException {
        return DataTableFactory.getDataTable(ByteBuffer.wrap(bytes));
    }
}

