/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.datablock;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.pinot.common.datablock.BaseDataBlock;
import org.apache.pinot.common.datablock.DataBlock;
import org.apache.pinot.common.datablock.DataBlockUtils;
import org.apache.pinot.common.utils.DataSchema;

public class RowDataBlock
extends BaseDataBlock {
    private static final int VERSION = 2;
    protected int[] _columnOffsets;
    protected int _rowSizeInBytes;

    public RowDataBlock() {
    }

    public RowDataBlock(int numRows, DataSchema dataSchema, String[] stringDictionary, byte[] fixedSizeDataBytes, byte[] variableSizeDataBytes) {
        super(numRows, dataSchema, stringDictionary, fixedSizeDataBytes, variableSizeDataBytes);
        this.computeBlockObjectConstants();
    }

    public RowDataBlock(ByteBuffer byteBuffer) throws IOException {
        super(byteBuffer);
        this.computeBlockObjectConstants();
    }

    protected void computeBlockObjectConstants() {
        if (this._dataSchema != null) {
            this._columnOffsets = new int[this._numColumns];
            this._rowSizeInBytes = DataBlockUtils.computeColumnOffsets(this._dataSchema, this._columnOffsets);
            this._fixDataSize = this._numRows * this._rowSizeInBytes;
        }
    }

    @Override
    protected int getDataBlockVersionType() {
        return 2 + (DataBlock.Type.ROW.ordinal() << 5);
    }

    @Override
    protected int getOffsetInFixedBuffer(int rowId, int colId) {
        return rowId * this._rowSizeInBytes + this._columnOffsets[colId];
    }

    @Override
    protected int positionOffsetInVariableBufferAndGetLength(int rowId, int colId) {
        int offset = this.getOffsetInFixedBuffer(rowId, colId);
        this._variableSizeData.position(this._fixedSizeData.getInt(offset));
        return this._fixedSizeData.getInt(offset + 4);
    }

    public int getRowSizeInBytes() {
        return this._rowSizeInBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RowDataBlock)) {
            return false;
        }
        RowDataBlock that = (RowDataBlock)o;
        return this._rowSizeInBytes == that._rowSizeInBytes && Objects.deepEquals(this._columnOffsets, that._columnOffsets);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this._columnOffsets), this._rowSizeInBytes);
    }
}

