/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.datablock;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.pinot.common.datablock.BaseDataBlock;
import org.apache.pinot.common.datablock.DataBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataBlock
extends BaseDataBlock {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataBlock.class);
    @VisibleForTesting
    static final int VERSION = 2;
    @Nullable
    private List<ByteBuffer> _statsByStage;

    private MetadataBlock() {
        this(Collections.emptyList());
    }

    public static MetadataBlock newEos() {
        return new MetadataBlock();
    }

    public static MetadataBlock newError(Map<Integer, String> exceptions) {
        MetadataBlock errorBlock = new MetadataBlock();
        for (Map.Entry<Integer, String> exception : exceptions.entrySet()) {
            errorBlock.addException(exception.getKey(), exception.getValue());
        }
        return errorBlock;
    }

    public MetadataBlock(List<ByteBuffer> statsByStage) {
        super(0, null, new String[0], new byte[0], new byte[0]);
        this._statsByStage = statsByStage;
    }

    MetadataBlock(ByteBuffer byteBuffer) throws IOException {
        super(byteBuffer);
    }

    @Override
    protected void serializeMetadata(DataOutputStream output) throws IOException {
        if (this._statsByStage == null) {
            output.writeInt(0);
            return;
        }
        int size = this._statsByStage.size();
        output.writeInt(size);
        if (size > 0) {
            byte[] bytes = new byte[4096];
            for (ByteBuffer stat : this._statsByStage) {
                if (stat == null) {
                    output.writeBoolean(false);
                    continue;
                }
                output.writeBoolean(true);
                output.writeInt(stat.remaining());
                ByteBuffer duplicate = stat.duplicate();
                while (duplicate.hasRemaining()) {
                    int length = Math.min(duplicate.remaining(), bytes.length);
                    duplicate.get(bytes, 0, length);
                    output.write(bytes, 0, length);
                }
            }
        }
    }

    public static MetadataBlock deserialize(ByteBuffer byteBuffer, int version) throws IOException {
        switch (version) {
            case 1: 
            case 2: {
                return new MetadataBlock(byteBuffer);
            }
        }
        throw new IOException("Unsupported metadata block version: " + version);
    }

    @Override
    protected void deserializeMetadata(ByteBuffer buffer) throws IOException {
        try {
            int statsSize = buffer.getInt();
            ArrayList<ByteBuffer> stats = new ArrayList<ByteBuffer>(statsSize);
            for (int i = 0; i < statsSize; ++i) {
                if (buffer.get() != 0) {
                    int length = buffer.getInt();
                    buffer.limit(buffer.position() + length);
                    stats.add(buffer.slice());
                    buffer.position(buffer.limit());
                    buffer.limit(buffer.capacity());
                    continue;
                }
                stats.add(null);
            }
            this._statsByStage = stats;
        }
        catch (BufferUnderflowException e) {
            LOGGER.info("Failed to read stats from metadata block. Considering it empty", (Throwable)e);
        }
        catch (RuntimeException e) {
            LOGGER.warn("Failed to read stats from metadata block. Considering it empty", (Throwable)e);
        }
    }

    public MetadataBlockType getType() {
        return this._errCodeToExceptionMap.isEmpty() ? MetadataBlockType.EOS : MetadataBlockType.ERROR;
    }

    @Nullable
    public List<ByteBuffer> getStatsByStage() {
        return this._statsByStage;
    }

    @Override
    public int getDataBlockVersionType() {
        return 2 + (DataBlock.Type.METADATA.ordinal() << 5);
    }

    @Override
    protected int getOffsetInFixedBuffer(int rowId, int colId) {
        throw new UnsupportedOperationException("Metadata block uses JSON encoding for field access");
    }

    @Override
    protected int positionOffsetInVariableBufferAndGetLength(int rowId, int colId) {
        throw new UnsupportedOperationException("Metadata block uses JSON encoding for field access");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetadataBlock)) {
            return false;
        }
        MetadataBlock that = (MetadataBlock)o;
        return Objects.equals(this._statsByStage, that._statsByStage) && this._errCodeToExceptionMap.equals(that._errCodeToExceptionMap);
    }

    public int hashCode() {
        return Objects.hash(this._statsByStage, this._errCodeToExceptionMap);
    }

    public static enum MetadataBlockType {
        EOS,
        ERROR;

    }
}

