/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.datablock;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.CustomObject;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.spi.utils.ByteArray;
import org.roaringbitmap.RoaringBitmap;

public interface DataBlock {
    public Map<String, String> getMetadata();

    public DataSchema getDataSchema();

    public int getNumberOfRows();

    public void addException(ProcessingException var1);

    public void addException(int var1, String var2);

    public Map<Integer, String> getExceptions();

    public byte[] toBytes() throws IOException;

    public int getVersion();

    public int getInt(int var1, int var2);

    public long getLong(int var1, int var2);

    public float getFloat(int var1, int var2);

    public double getDouble(int var1, int var2);

    public BigDecimal getBigDecimal(int var1, int var2);

    public String getString(int var1, int var2);

    public ByteArray getBytes(int var1, int var2);

    public int[] getIntArray(int var1, int var2);

    public long[] getLongArray(int var1, int var2);

    public float[] getFloatArray(int var1, int var2);

    public double[] getDoubleArray(int var1, int var2);

    public String[] getStringArray(int var1, int var2);

    public CustomObject getCustomObject(int var1, int var2);

    @Nullable
    public RoaringBitmap getNullRowIds(int var1);

    public static enum Type {
        ROW(0),
        COLUMNAR(1),
        METADATA(2);

        private final int _ordinal;

        private Type(int ordinal) {
            this._ordinal = ordinal;
        }

        public static Type fromOrdinal(int ordinal) {
            switch (ordinal) {
                case 0: {
                    return ROW;
                }
                case 1: {
                    return COLUMNAR;
                }
                case 2: {
                    return METADATA;
                }
            }
            throw new IllegalArgumentException("Invalid ordinal: " + ordinal);
        }
    }
}

