/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.datablock;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.pinot.common.CustomObject;
import org.apache.pinot.common.datablock.DataBlock;
import org.apache.pinot.common.datatable.DataTableUtils;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.HashUtil;
import org.apache.pinot.common.utils.RoaringBitmapUtils;
import org.apache.pinot.spi.accounting.ThreadResourceUsageProvider;
import org.apache.pinot.spi.utils.BigDecimalUtils;
import org.apache.pinot.spi.utils.ByteArray;
import org.roaringbitmap.RoaringBitmap;

public abstract class BaseDataBlock
implements DataBlock {
    protected static final int HEADER_SIZE = 52;
    protected Map<Integer, String> _errCodeToExceptionMap;
    protected int _numRows;
    protected int _numColumns;
    protected int _fixDataSize;
    protected DataSchema _dataSchema;
    protected String[] _stringDictionary;
    protected byte[] _fixedSizeDataBytes;
    protected ByteBuffer _fixedSizeData;
    protected byte[] _variableSizeDataBytes;
    protected ByteBuffer _variableSizeData;

    public BaseDataBlock(int numRows, @Nullable DataSchema dataSchema, String[] stringDictionary, byte[] fixedSizeDataBytes, byte[] variableSizeDataBytes) {
        this._numRows = numRows;
        this._dataSchema = dataSchema;
        this._numColumns = dataSchema == null ? 0 : dataSchema.size();
        this._fixDataSize = 0;
        this._stringDictionary = stringDictionary;
        this._fixedSizeDataBytes = fixedSizeDataBytes;
        this._fixedSizeData = ByteBuffer.wrap(fixedSizeDataBytes);
        this._variableSizeDataBytes = variableSizeDataBytes;
        this._variableSizeData = ByteBuffer.wrap(variableSizeDataBytes);
        this._errCodeToExceptionMap = new HashMap<Integer, String>();
    }

    public BaseDataBlock() {
        this._numRows = 0;
        this._numColumns = 0;
        this._fixDataSize = 0;
        this._dataSchema = null;
        this._stringDictionary = null;
        this._fixedSizeDataBytes = null;
        this._fixedSizeData = null;
        this._variableSizeDataBytes = null;
        this._variableSizeData = null;
        this._errCodeToExceptionMap = new HashMap<Integer, String>();
    }

    public BaseDataBlock(ByteBuffer byteBuffer) throws IOException {
        this._numRows = byteBuffer.getInt();
        this._numColumns = byteBuffer.getInt();
        int exceptionsStart = byteBuffer.getInt();
        int exceptionsLength = byteBuffer.getInt();
        int dictionaryMapStart = byteBuffer.getInt();
        int dictionaryMapLength = byteBuffer.getInt();
        int dataSchemaStart = byteBuffer.getInt();
        int dataSchemaLength = byteBuffer.getInt();
        int fixedSizeDataStart = byteBuffer.getInt();
        int fixedSizeDataLength = byteBuffer.getInt();
        int variableSizeDataStart = byteBuffer.getInt();
        int variableSizeDataLength = byteBuffer.getInt();
        if (exceptionsLength != 0) {
            byteBuffer.position(exceptionsStart);
            this._errCodeToExceptionMap = this.deserializeExceptions(byteBuffer);
        } else {
            this._errCodeToExceptionMap = new HashMap<Integer, String>();
        }
        if (dictionaryMapLength != 0) {
            byteBuffer.position(dictionaryMapStart);
            this._stringDictionary = this.deserializeStringDictionary(byteBuffer);
        } else {
            this._stringDictionary = null;
        }
        if (dataSchemaLength != 0) {
            byteBuffer.position(dataSchemaStart);
            this._dataSchema = DataSchema.fromBytes(byteBuffer);
        } else {
            this._dataSchema = null;
        }
        if (fixedSizeDataLength != 0) {
            this._fixedSizeDataBytes = new byte[fixedSizeDataLength];
            byteBuffer.position(fixedSizeDataStart);
            byteBuffer.get(this._fixedSizeDataBytes);
            this._fixedSizeData = ByteBuffer.wrap(this._fixedSizeDataBytes);
        } else {
            this._fixedSizeDataBytes = null;
            this._fixedSizeData = null;
        }
        this._variableSizeDataBytes = new byte[variableSizeDataLength];
        if (variableSizeDataLength != 0) {
            byteBuffer.position(variableSizeDataStart);
            byteBuffer.get(this._variableSizeDataBytes);
        }
        this._variableSizeData = ByteBuffer.wrap(this._variableSizeDataBytes);
        this.deserializeMetadata(byteBuffer);
    }

    @Override
    public int getVersion() {
        return 0;
    }

    protected abstract int getDataBlockVersionType();

    protected abstract int getOffsetInFixedBuffer(int var1, int var2);

    protected abstract int positionOffsetInVariableBufferAndGetLength(int var1, int var2);

    @Override
    public Map<String, String> getMetadata() {
        return Collections.emptyMap();
    }

    @Override
    public DataSchema getDataSchema() {
        return this._dataSchema;
    }

    @Override
    public int getNumberOfRows() {
        return this._numRows;
    }

    @Override
    public int getInt(int rowId, int colId) {
        return this._fixedSizeData.getInt(this.getOffsetInFixedBuffer(rowId, colId));
    }

    @Override
    public long getLong(int rowId, int colId) {
        return this._fixedSizeData.getLong(this.getOffsetInFixedBuffer(rowId, colId));
    }

    @Override
    public float getFloat(int rowId, int colId) {
        return this._fixedSizeData.getFloat(this.getOffsetInFixedBuffer(rowId, colId));
    }

    @Override
    public double getDouble(int rowId, int colId) {
        return this._fixedSizeData.getDouble(this.getOffsetInFixedBuffer(rowId, colId));
    }

    @Override
    public BigDecimal getBigDecimal(int rowId, int colId) {
        int size = this.positionOffsetInVariableBufferAndGetLength(rowId, colId);
        ByteBuffer byteBuffer = this._variableSizeData.slice();
        byteBuffer.limit(size);
        return BigDecimalUtils.deserialize((ByteBuffer)byteBuffer);
    }

    @Override
    public String getString(int rowId, int colId) {
        return this._stringDictionary[this._fixedSizeData.getInt(this.getOffsetInFixedBuffer(rowId, colId))];
    }

    @Override
    public ByteArray getBytes(int rowId, int colId) {
        int size = this.positionOffsetInVariableBufferAndGetLength(rowId, colId);
        byte[] buffer = new byte[size];
        this._variableSizeData.get(buffer);
        return new ByteArray(buffer);
    }

    @Override
    public int[] getIntArray(int rowId, int colId) {
        int length = this.positionOffsetInVariableBufferAndGetLength(rowId, colId);
        int[] ints = new int[length];
        for (int i = 0; i < length; ++i) {
            ints[i] = this._variableSizeData.getInt();
        }
        return ints;
    }

    @Override
    public long[] getLongArray(int rowId, int colId) {
        int length = this.positionOffsetInVariableBufferAndGetLength(rowId, colId);
        long[] longs = new long[length];
        for (int i = 0; i < length; ++i) {
            longs[i] = this._variableSizeData.getLong();
        }
        return longs;
    }

    @Override
    public float[] getFloatArray(int rowId, int colId) {
        int length = this.positionOffsetInVariableBufferAndGetLength(rowId, colId);
        float[] floats = new float[length];
        for (int i = 0; i < length; ++i) {
            floats[i] = this._variableSizeData.getFloat();
        }
        return floats;
    }

    @Override
    public double[] getDoubleArray(int rowId, int colId) {
        int length = this.positionOffsetInVariableBufferAndGetLength(rowId, colId);
        double[] doubles = new double[length];
        for (int i = 0; i < length; ++i) {
            doubles[i] = this._variableSizeData.getDouble();
        }
        return doubles;
    }

    @Override
    public String[] getStringArray(int rowId, int colId) {
        int length = this.positionOffsetInVariableBufferAndGetLength(rowId, colId);
        String[] strings = new String[length];
        for (int i = 0; i < length; ++i) {
            strings[i] = this._stringDictionary[this._variableSizeData.getInt()];
        }
        return strings;
    }

    @Override
    @Nullable
    public CustomObject getCustomObject(int rowId, int colId) {
        int size = this.positionOffsetInVariableBufferAndGetLength(rowId, colId);
        int type = this._variableSizeData.getInt();
        if (size == 0) {
            assert (type == 100);
            return null;
        }
        ByteBuffer buffer = this._variableSizeData.slice();
        buffer.limit(size);
        return new CustomObject(type, buffer);
    }

    @Override
    @Nullable
    public RoaringBitmap getNullRowIds(int colId) {
        int position = this._fixDataSize + colId * 4 * 2;
        if (this._fixedSizeData == null || position >= this._fixedSizeData.limit()) {
            return null;
        }
        this._fixedSizeData.position(position);
        int offset = this._fixedSizeData.getInt();
        int bytesLength = this._fixedSizeData.getInt();
        if (bytesLength > 0) {
            this._variableSizeData.position(offset);
            byte[] nullBitmapBytes = new byte[bytesLength];
            this._variableSizeData.get(nullBitmapBytes);
            return RoaringBitmapUtils.deserialize(nullBitmapBytes);
        }
        return null;
    }

    protected byte[] serializeStringDictionary() throws IOException {
        if (this._stringDictionary.length == 0) {
            return new byte[4];
        }
        UnsynchronizedByteArrayOutputStream byteArrayOutputStream = new UnsynchronizedByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        dataOutputStream.writeInt(this._stringDictionary.length);
        for (String entry : this._stringDictionary) {
            byte[] valueBytes = entry.getBytes(StandardCharsets.UTF_8);
            dataOutputStream.writeInt(valueBytes.length);
            dataOutputStream.write(valueBytes);
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected String[] deserializeStringDictionary(ByteBuffer buffer) throws IOException {
        int dictionarySize = buffer.getInt();
        String[] stringDictionary = new String[dictionarySize];
        for (int i = 0; i < dictionarySize; ++i) {
            stringDictionary[i] = DataTableUtils.decodeString(buffer);
        }
        return stringDictionary;
    }

    @Override
    public void addException(ProcessingException processingException) {
        this._errCodeToExceptionMap.put(processingException.getErrorCode(), processingException.getMessage());
    }

    @Override
    public void addException(int errCode, String errMsg) {
        this._errCodeToExceptionMap.put(errCode, errMsg);
    }

    @Override
    public Map<Integer, String> getExceptions() {
        return this._errCodeToExceptionMap;
    }

    @Override
    public byte[] toBytes() throws IOException {
        ThreadResourceUsageProvider threadResourceUsageProvider = new ThreadResourceUsageProvider();
        UnsynchronizedByteArrayOutputStream byteArrayOutputStream = new UnsynchronizedByteArrayOutputStream(8192);
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        this.writeLeadingSections(dataOutputStream);
        this.serializeMetadata(dataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private void writeLeadingSections(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.getDataBlockVersionType());
        dataOutputStream.writeInt(this._numRows);
        dataOutputStream.writeInt(this._numColumns);
        int dataOffset = 52;
        dataOutputStream.writeInt(dataOffset);
        byte[] exceptionsBytes = this.serializeExceptions();
        dataOutputStream.writeInt(exceptionsBytes.length);
        dataOutputStream.writeInt(dataOffset += exceptionsBytes.length);
        byte[] dictionaryBytes = null;
        if (this._stringDictionary != null) {
            dictionaryBytes = this.serializeStringDictionary();
            dataOutputStream.writeInt(dictionaryBytes.length);
            dataOffset += dictionaryBytes.length;
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.writeInt(dataOffset);
        byte[] dataSchemaBytes = null;
        if (this._dataSchema != null) {
            dataSchemaBytes = this._dataSchema.toBytes();
            dataOutputStream.writeInt(dataSchemaBytes.length);
            dataOffset += dataSchemaBytes.length;
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.writeInt(dataOffset);
        if (this._fixedSizeDataBytes != null) {
            dataOutputStream.writeInt(this._fixedSizeDataBytes.length);
            dataOffset += this._fixedSizeDataBytes.length;
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.writeInt(dataOffset);
        if (this._variableSizeDataBytes != null) {
            dataOutputStream.writeInt(this._variableSizeDataBytes.length);
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.write(exceptionsBytes);
        if (dictionaryBytes != null) {
            dataOutputStream.write(dictionaryBytes);
        }
        if (dataSchemaBytes != null) {
            dataOutputStream.write(dataSchemaBytes);
        }
        if (this._fixedSizeDataBytes != null) {
            dataOutputStream.write(this._fixedSizeDataBytes);
        }
        if (this._variableSizeDataBytes != null) {
            dataOutputStream.write(this._variableSizeDataBytes);
        }
    }

    protected void serializeMetadata(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(0);
    }

    protected void deserializeMetadata(ByteBuffer buffer) throws IOException {
        buffer.getInt();
    }

    private byte[] serializeExceptions() throws IOException {
        if (this._errCodeToExceptionMap.isEmpty()) {
            return new byte[4];
        }
        UnsynchronizedByteArrayOutputStream byteArrayOutputStream = new UnsynchronizedByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        dataOutputStream.writeInt(this._errCodeToExceptionMap.size());
        for (Map.Entry<Integer, String> entry : this._errCodeToExceptionMap.entrySet()) {
            int key = entry.getKey();
            String value = entry.getValue();
            byte[] valueBytes = value.getBytes(StandardCharsets.UTF_8);
            dataOutputStream.writeInt(key);
            dataOutputStream.writeInt(valueBytes.length);
            dataOutputStream.write(valueBytes);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private Map<Integer, String> deserializeExceptions(ByteBuffer buffer) throws IOException {
        int numExceptions = buffer.getInt();
        HashMap<Integer, String> exceptions = new HashMap<Integer, String>(HashUtil.getHashMapCapacity(numExceptions));
        for (int i = 0; i < numExceptions; ++i) {
            int errCode = buffer.getInt();
            String errMessage = DataTableUtils.decodeString(buffer);
            exceptions.put(errCode, errMessage);
        }
        return exceptions;
    }

    public String toString() {
        if (this._dataSchema == null) {
            return "{}";
        }
        return "resultSchema:\n" + this._dataSchema + "\nnumRows: " + this._numRows + "\n";
    }
}

