/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config.provider;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.helix.AccessOption;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.zkclient.IZkChildListener;
import org.apache.helix.zookeeper.zkclient.IZkDataListener;
import org.apache.pinot.common.utils.config.AccessControlUserConfigUtils;
import org.apache.pinot.spi.config.user.ComponentType;
import org.apache.pinot.spi.config.user.UserConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessControlUserCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessControlUserCache.class);
    private static final String USER_CONFIG_PARENT_PATH = "/CONFIGS/USER";
    private static final String USER_CONFIG_PATH_PREFIX = "/CONFIGS/USER/";
    private static final int USER_PASSWORD_EXPIRE_TIME = 86400;
    private final ZkHelixPropertyStore<ZNRecord> _propertyStore;
    private final UserConfigChangeListener _userConfigChangeListener = new UserConfigChangeListener();
    private final Map<String, UserConfig> _userConfigMap = new ConcurrentHashMap<String, UserConfig>();
    private final Map<String, UserConfig> _userControllerConfigMap = new ConcurrentHashMap<String, UserConfig>();
    private final Map<String, UserConfig> _userBrokerConfigMap = new ConcurrentHashMap<String, UserConfig>();
    private final Map<String, UserConfig> _userServerConfigMap = new ConcurrentHashMap<String, UserConfig>();
    private Cache<String, String> _userPasswordAuthCache = CacheBuilder.newBuilder().expireAfterWrite(86400L, TimeUnit.SECONDS).build();

    public AccessControlUserCache(ZkHelixPropertyStore<ZNRecord> propertyStore) {
        this._propertyStore = propertyStore;
        this._propertyStore.subscribeChildChanges(USER_CONFIG_PARENT_PATH, (IZkChildListener)this._userConfigChangeListener);
        List users = this._propertyStore.getChildNames(USER_CONFIG_PARENT_PATH, AccessOption.PERSISTENT);
        if (CollectionUtils.isNotEmpty((Collection)users)) {
            ArrayList<String> pathsToAdd = new ArrayList<String>(users.size());
            for (String user : users) {
                pathsToAdd.add(USER_CONFIG_PATH_PREFIX + user);
            }
            this.addUserConfigs(pathsToAdd);
        }
    }

    public Cache<String, String> getUserPasswordAuthCache() {
        return this._userPasswordAuthCache;
    }

    @Nullable
    public List<UserConfig> getAllUserConfig() {
        return this._userConfigMap.values().stream().collect(Collectors.toList());
    }

    public List<UserConfig> getAllControllerUserConfig() {
        return this._userControllerConfigMap.values().stream().collect(Collectors.toList());
    }

    public List<UserConfig> getAllBrokerUserConfig() {
        return this._userBrokerConfigMap.values().stream().collect(Collectors.toList());
    }

    public List<UserConfig> getAllServerUserConfig() {
        return this._userServerConfigMap.values().stream().collect(Collectors.toList());
    }

    @Nullable
    public List<String> getAllUserName() {
        return this._userConfigMap.keySet().stream().collect(Collectors.toList());
    }

    private void addUserConfigs(List<String> allUserZKStorePath) {
        for (String userStoreZKPath : allUserZKStorePath) {
            this._propertyStore.subscribeDataChanges(userStoreZKPath, (IZkDataListener)this._userConfigChangeListener);
        }
        List allUserRecords = this._propertyStore.get(allUserZKStorePath, null, AccessOption.PERSISTENT, false);
        for (ZNRecord userRecord : allUserRecords) {
            if (userRecord == null) continue;
            try {
                UserConfig userConfig = AccessControlUserConfigUtils.fromZNRecord(userRecord);
                String username = userConfig.getUsernameWithComponent();
                if (userConfig.getComponentType().equals((Object)ComponentType.CONTROLLER)) {
                    this._userControllerConfigMap.put(username, userConfig);
                    continue;
                }
                if (userConfig.getComponentType().equals((Object)ComponentType.BROKER)) {
                    this._userBrokerConfigMap.put(username, userConfig);
                    continue;
                }
                if (!userConfig.getComponentType().equals((Object)ComponentType.SERVER)) continue;
                this._userServerConfigMap.put(username, userConfig);
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while adding user config for ZNRecord:{}", (Object)userRecord.getId(), (Object)e);
            }
        }
    }

    private void removeUserConfig(String userStoreZKPath) {
        this._propertyStore.unsubscribeDataChanges(userStoreZKPath, (IZkDataListener)this._userConfigChangeListener);
        String usernameWithComponentType = userStoreZKPath.substring(USER_CONFIG_PATH_PREFIX.length());
        if (usernameWithComponentType.endsWith("BROKER")) {
            this._userBrokerConfigMap.remove(usernameWithComponentType);
        } else if (usernameWithComponentType.endsWith("CONTROLLER")) {
            this._userControllerConfigMap.remove(usernameWithComponentType);
        } else if (usernameWithComponentType.endsWith("SERVER")) {
            this._userServerConfigMap.remove(usernameWithComponentType);
        }
    }

    private class UserConfigChangeListener
    implements IZkChildListener,
    IZkDataListener {
        private UserConfigChangeListener() {
        }

        public void handleChildChange(String userStoreZKPath, List<String> allUserList) throws Exception {
            if (CollectionUtils.isEmpty(allUserList)) {
                return;
            }
            ArrayList<String> newUserPathToAdd = new ArrayList<String>();
            for (String user : allUserList) {
                if (AccessControlUserCache.this._userControllerConfigMap.containsKey(user) || AccessControlUserCache.this._userBrokerConfigMap.containsKey(user) || AccessControlUserCache.this._userServerConfigMap.containsKey(user)) continue;
                newUserPathToAdd.add(AccessControlUserCache.USER_CONFIG_PATH_PREFIX + user);
            }
            if (!newUserPathToAdd.isEmpty()) {
                AccessControlUserCache.this.addUserConfigs(newUserPathToAdd);
            }
        }

        public void handleDataChange(String userStoreZKPath, Object changedUserConfig) throws Exception {
            if (changedUserConfig != null) {
                ZNRecord userRecord = (ZNRecord)changedUserConfig;
                try {
                    UserConfig userConfig = AccessControlUserConfigUtils.fromZNRecord(userRecord);
                    String usernameWithComponentType = userConfig.getUsernameWithComponent();
                    if (userConfig.getComponentType().equals((Object)ComponentType.CONTROLLER)) {
                        AccessControlUserCache.this._userControllerConfigMap.put(usernameWithComponentType, userConfig);
                    } else if (userConfig.getComponentType().equals((Object)ComponentType.BROKER)) {
                        AccessControlUserCache.this._userBrokerConfigMap.put(usernameWithComponentType, userConfig);
                    } else if (userConfig.getComponentType().equals((Object)ComponentType.SERVER)) {
                        AccessControlUserCache.this._userServerConfigMap.put(usernameWithComponentType, userConfig);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("caught exception while refreshing table config for ZNRecord: {}", (Object)userRecord.getId(), (Object)e);
                }
            }
        }

        public void handleDataDeleted(String path) throws Exception {
            String username = path.substring(path.lastIndexOf(47) + 1);
            AccessControlUserCache.this.removeUserConfig(AccessControlUserCache.USER_CONFIG_PATH_PREFIX + username);
        }
    }
}

