/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.pinot.common.config.TlsConfig;
import org.apache.pinot.common.utils.tls.TlsUtils;
import org.apache.pinot.spi.env.PinotConfiguration;

public class GrpcConfig {
    public static final String GRPC_TLS_PREFIX = "tls";
    public static final String CONFIG_USE_PLAIN_TEXT = "usePlainText";
    public static final String CONFIG_MAX_INBOUND_MESSAGE_BYTES_SIZE = "maxInboundMessageSizeBytes";
    public static final int DEFAULT_MAX_INBOUND_MESSAGE_BYTES_SIZE = 0x8000000;
    private static final String DEFAULT_IS_USE_PLAIN_TEXT = "true";
    public static final String CONFIG_QUERY_WORKER_THREADS = "queryWorkerThreads";
    private final TlsConfig _tlsConfig;
    private final PinotConfiguration _pinotConfig;

    public static GrpcConfig buildGrpcQueryConfig(PinotConfiguration pinotConfig) {
        return new GrpcConfig(pinotConfig);
    }

    public GrpcConfig(PinotConfiguration pinotConfig) {
        this._pinotConfig = pinotConfig;
        this._tlsConfig = TlsUtils.extractTlsConfig(this._pinotConfig, GRPC_TLS_PREFIX);
    }

    public GrpcConfig(Map<String, Object> configMap) {
        this(new PinotConfiguration(configMap));
    }

    public GrpcConfig(int maxInboundMessageSizeBytes, boolean usePlainText) {
        this((Map<String, Object>)ImmutableMap.of((Object)CONFIG_MAX_INBOUND_MESSAGE_BYTES_SIZE, (Object)maxInboundMessageSizeBytes, (Object)CONFIG_USE_PLAIN_TEXT, (Object)usePlainText));
    }

    public Object get(String key) {
        return this._pinotConfig.getProperty(key);
    }

    public int getMaxInboundMessageSizeBytes() {
        return this._pinotConfig.getProperty(CONFIG_MAX_INBOUND_MESSAGE_BYTES_SIZE, 0x8000000);
    }

    public boolean isUsePlainText() {
        return Boolean.parseBoolean(this._pinotConfig.getProperty(CONFIG_USE_PLAIN_TEXT, DEFAULT_IS_USE_PLAIN_TEXT));
    }

    public TlsConfig getTlsConfig() {
        return this._tlsConfig;
    }

    public PinotConfiguration getPinotConfig() {
        return this._pinotConfig;
    }

    public int getQueryWorkerThreads() {
        return (Integer)this._pinotConfig.getProperty(CONFIG_QUERY_WORKER_THREADS, Integer.class);
    }

    public boolean isQueryWorkerThreadsSet() {
        return this._pinotConfig.containsKey(CONFIG_QUERY_WORKER_THREADS);
    }
}

