/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.sql.parsers.rewriter;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.EnumUtils;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.sql.FilterKind;
import org.apache.pinot.sql.parsers.SqlCompilationException;
import org.apache.pinot.sql.parsers.rewriter.QueryRewriter;

public class PredicateComparisonRewriter
implements QueryRewriter {
    @Override
    public PinotQuery rewrite(PinotQuery pinotQuery) {
        Expression havingExpression;
        Expression filterExpression = pinotQuery.getFilterExpression();
        if (filterExpression != null) {
            pinotQuery.setFilterExpression(PredicateComparisonRewriter.updatePredicate(filterExpression));
        }
        if ((havingExpression = pinotQuery.getHavingExpression()) != null) {
            pinotQuery.setHavingExpression(PredicateComparisonRewriter.updatePredicate(havingExpression));
        }
        return pinotQuery;
    }

    private static Expression updatePredicate(Expression expression) {
        ExpressionType type = expression.getType();
        switch (type) {
            case FUNCTION: {
                return PredicateComparisonRewriter.updateFunctionExpression(expression);
            }
            case IDENTIFIER: {
                return PredicateComparisonRewriter.convertPredicateToEqualsBooleanExpression(expression);
            }
            case LITERAL: {
                return expression;
            }
        }
        throw new IllegalStateException();
    }

    private static Expression updateFunctionExpression(Expression expression) {
        Function function = expression.getFunctionCall();
        String functionOperator = function.getOperator();
        if (!EnumUtils.isValidEnum(FilterKind.class, (String)functionOperator)) {
            expression = PredicateComparisonRewriter.convertPredicateToEqualsBooleanExpression(expression);
            return expression;
        }
        FilterKind filterKind = FilterKind.valueOf(function.getOperator());
        List<Expression> operands = function.getOperands();
        switch (filterKind) {
            case AND: 
            case OR: 
            case NOT: {
                for (int i = 0; i < operands.size(); ++i) {
                    Expression operand = operands.get(i);
                    operands.set(i, PredicateComparisonRewriter.updatePredicate(operand));
                }
                break;
            }
            case EQUALS: 
            case NOT_EQUALS: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                Expression firstOperand = operands.get(0);
                Expression secondOperand = operands.get(1);
                if (firstOperand.isSetLiteral()) {
                    if (secondOperand.isSetLiteral()) break;
                    function.setOperator(PredicateComparisonRewriter.getOppositeOperator(filterKind).name());
                    operands.set(0, secondOperand);
                    operands.set(1, firstOperand);
                    break;
                }
                if (secondOperand.isSetLiteral()) break;
                Expression minusExpression = RequestUtils.getFunctionExpression("minus");
                minusExpression.getFunctionCall().setOperands(Arrays.asList(firstOperand, secondOperand));
                operands.set(0, minusExpression);
                operands.set(1, RequestUtils.getLiteralExpression(0L));
                break;
            }
            case VECTOR_SIMILARITY: {
                Preconditions.checkArgument((operands.size() >= 2 && operands.size() <= 3 ? 1 : 0) != 0, (String)"For %s predicate, the number of operands must be at either 2 or 3, got: %s", (Object)((Object)filterKind), (Object)expression);
                if (operands.get(1).getFunctionCall() != null && !operands.get(1).getFunctionCall().getOperator().equalsIgnoreCase("arrayvalueconstructor") || operands.get(1).getLiteral() != null && !operands.get(1).getLiteral().isSetFloatArrayValue() && !operands.get(1).getLiteral().isSetDoubleArrayValue()) {
                    throw new SqlCompilationException(String.format("For %s predicate, the second operand must be a float/double array literal, got: %s", new Object[]{filterKind, expression}));
                }
                if (operands.size() != 3 || operands.get(2).getLiteral() != null) break;
                throw new SqlCompilationException(String.format("For %s predicate, the third operand must be a literal, got: %s", new Object[]{filterKind, expression}));
            }
            default: {
                int numOperands = operands.size();
                for (int i = 1; i < numOperands; ++i) {
                    if (operands.get(i).isSetLiteral()) continue;
                    throw new SqlCompilationException(String.format("For %s predicate, the operands except for the first one must be literal, got: %s", new Object[]{filterKind, expression}));
                }
            }
        }
        return expression;
    }

    private static Expression convertPredicateToEqualsBooleanExpression(Expression expression) {
        Expression newExpression = RequestUtils.getFunctionExpression(FilterKind.EQUALS.name());
        ArrayList<Expression> operands = new ArrayList<Expression>();
        operands.add(expression);
        operands.add(RequestUtils.getLiteralExpression(true));
        newExpression.getFunctionCall().setOperands(operands);
        return newExpression;
    }

    private static FilterKind getOppositeOperator(FilterKind filterKind) {
        switch (filterKind) {
            case GREATER_THAN: {
                return FilterKind.LESS_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return FilterKind.LESS_THAN_OR_EQUAL;
            }
            case LESS_THAN: {
                return FilterKind.GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return FilterKind.GREATER_THAN_OR_EQUAL;
            }
        }
        return filterKind;
    }
}

