/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.sql.parsers.parser;

import java.util.Arrays;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.pinot.sql.parsers.parser.UnparseUtils;

public class SqlInsertFromFile
extends SqlCall {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("UDF", SqlKind.OTHER_DDL);
    private SqlIdentifier _dbName;
    private SqlIdentifier _tableName;
    private SqlNodeList _fileList;

    public SqlInsertFromFile(SqlParserPos pos, SqlIdentifier dbName, SqlIdentifier tableName, SqlNodeList fileList) {
        super(pos);
        this._dbName = dbName;
        this._tableName = tableName;
        this._fileList = fileList;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        UnparseUtils u = new UnparseUtils(writer, leftPrec, rightPrec);
        u.keyword("INSERT", "INTO");
        if (this._dbName != null) {
            u.node((SqlNode)this._dbName).keyword(".");
        }
        u.node((SqlNode)this._tableName);
        if (this._fileList != null) {
            u.keyword("FROM").nodeList(this._fileList);
        }
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        return Arrays.asList(this._dbName, this._tableName, this._fileList);
    }
}

