/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.helix;

import java.nio.charset.StandardCharsets;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.ResourceConfig;
import org.apache.pinot.common.utils.HashUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeadControllerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeadControllerUtils.class);

    private LeadControllerUtils() {
    }

    public static int getPartitionIdForTable(String rawTableName) {
        return (HashUtil.murmur2(rawTableName.getBytes(StandardCharsets.UTF_8)) & Integer.MAX_VALUE) % 24;
    }

    public static String generateParticipantInstanceId(String controllerHost, int controllerPort) {
        return "Controller_" + controllerHost + "_" + controllerPort;
    }

    public static String generatePartitionName(int partitionId) {
        return "leadControllerResource_" + partitionId;
    }

    public static int extractPartitionId(String partitionName) {
        return Integer.parseInt(partitionName.substring(partitionName.lastIndexOf(95) + 1));
    }

    public static boolean isLeadControllerResourceEnabled(HelixManager helixManager) {
        ConfigAccessor configAccessor = helixManager.getConfigAccessor();
        ResourceConfig resourceConfig = configAccessor.getResourceConfig(helixManager.getClusterName(), "leadControllerResource");
        String resourceEnabled = resourceConfig.getSimpleConfig("RESOURCE_ENABLED");
        return Boolean.parseBoolean(resourceEnabled);
    }

    public static String getHelixClusterLeader(HelixManager helixManager) {
        PropertyKey propertyKey;
        HelixDataAccessor helixDataAccessor = helixManager.getHelixDataAccessor();
        LiveInstance liveInstance = (LiveInstance)helixDataAccessor.getProperty(propertyKey = helixDataAccessor.keyBuilder().controllerLeader());
        if (liveInstance == null) {
            LOGGER.warn("Helix leader ZNode is missing");
            return null;
        }
        String helixLeaderInstanceId = liveInstance.getInstanceName();
        String helixVersion = liveInstance.getHelixVersion();
        long modifiedTime = liveInstance.getModifiedTime();
        LOGGER.info("Getting Helix leader: {}, Helix version: {}, mtime: {}", new Object[]{helixLeaderInstanceId, helixVersion, modifiedTime});
        return helixLeaderInstanceId;
    }
}

