/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.helix;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.helix.AccessOption;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.builder.HelixConfigScopeBuilder;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.datamodel.serializer.ZNRecordSerializer;
import org.apache.helix.zookeeper.zkclient.exception.ZkBadVersionException;
import org.apache.pinot.common.helix.ExtraInstanceConfig;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.utils.config.TagNameUtils;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.utils.InstanceTypeUtils;
import org.apache.pinot.spi.utils.retry.RetryPolicies;
import org.apache.pinot.spi.utils.retry.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelixHelper {
    private static final int NUM_PARTITIONS_THRESHOLD_TO_ENABLE_COMPRESSION = 1000;
    private static final String ENABLE_COMPRESSIONS_KEY = "enableCompression";
    private static final RetryPolicy DEFAULT_RETRY_POLICY = RetryPolicies.exponentialBackoffRetryPolicy((int)5, (long)1000L, (double)2.0);
    private static final RetryPolicy DEFAULT_TABLE_IDEALSTATES_UPDATE_RETRY_POLICY = RetryPolicies.randomDelayRetryPolicy((int)20, (long)100L, (long)200L);
    private static final Logger LOGGER = LoggerFactory.getLogger(HelixHelper.class);
    private static final ZNRecordSerializer ZN_RECORD_SERIALIZER = new ZNRecordSerializer();
    private static final String ONLINE = "ONLINE";
    private static final String OFFLINE = "OFFLINE";
    public static final String BROKER_RESOURCE = "brokerResource";
    private static int _minNumCharsInISToTurnOnCompression = -1;

    private HelixHelper() {
    }

    public static synchronized void setMinNumCharsInISToTurnOnCompression(int minNumChars) {
        _minNumCharsInISToTurnOnCompression = minNumChars;
    }

    public static IdealState cloneIdealState(IdealState idealState) {
        return new IdealState((ZNRecord)ZN_RECORD_SERIALIZER.deserialize(ZN_RECORD_SERIALIZER.serialize((Object)idealState.getRecord())));
    }

    public static IdealState updateIdealState(final HelixManager helixManager, final String resourceName, final Function<IdealState, IdealState> updater, RetryPolicy policy, final boolean noChangeOk) {
        try {
            final IdealStateWrapper idealStateWrapper = new IdealStateWrapper();
            policy.attempt((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    IdealState updatedIdealState;
                    HelixDataAccessor dataAccessor = helixManager.getHelixDataAccessor();
                    PropertyKey idealStateKey = dataAccessor.keyBuilder().idealStates(resourceName);
                    IdealState idealState = (IdealState)dataAccessor.getProperty(idealStateKey);
                    IdealState idealStateCopy = HelixHelper.cloneIdealState(idealState);
                    try {
                        updatedIdealState = (IdealState)updater.apply((Object)idealStateCopy);
                    }
                    catch (PermanentUpdaterException e) {
                        LOGGER.error("Caught permanent exception while updating ideal state for resource: {}", (Object)resourceName, (Object)e);
                        throw e;
                    }
                    catch (Exception e) {
                        LOGGER.error("Caught exception while updating ideal state for resource: {}", (Object)resourceName, (Object)e);
                        return false;
                    }
                    if (updatedIdealState != null && !idealState.equals((Object)updatedIdealState)) {
                        ZNRecord updatedZNRecord = updatedIdealState.getRecord();
                        int numPartitions = updatedZNRecord.getMapFields().size();
                        updatedIdealState.setNumPartitions(numPartitions);
                        boolean enableCompression = this.shouldCompress(updatedIdealState);
                        if (enableCompression) {
                            updatedZNRecord.setBooleanField(HelixHelper.ENABLE_COMPRESSIONS_KEY, true);
                        } else {
                            updatedZNRecord.getSimpleFields().remove(HelixHelper.ENABLE_COMPRESSIONS_KEY);
                        }
                        try {
                            if (dataAccessor.getBaseDataAccessor().set(idealStateKey.getPath(), (Object)updatedZNRecord, idealState.getRecord().getVersion(), AccessOption.PERSISTENT)) {
                                idealStateWrapper._idealState = updatedIdealState;
                                return true;
                            }
                            LOGGER.warn("Failed to update ideal state for resource: {}", (Object)resourceName);
                            return false;
                        }
                        catch (ZkBadVersionException e) {
                            LOGGER.warn("Version changed while updating ideal state for resource: {}", (Object)resourceName);
                            return false;
                        }
                        catch (Exception e) {
                            LOGGER.warn("Caught exception while updating ideal state for resource: {} (compressed={})", new Object[]{resourceName, enableCompression, e});
                            return false;
                        }
                    }
                    if (noChangeOk) {
                        LOGGER.info("Idempotent or null ideal state update for resource {}, skipping update.", (Object)resourceName);
                    } else {
                        LOGGER.warn("Idempotent or null ideal state update for resource {}, skipping update.", (Object)resourceName);
                    }
                    idealStateWrapper._idealState = idealState;
                    return true;
                }

                private boolean shouldCompress(IdealState is) {
                    if (is.getNumPartitions() > 1000) {
                        return true;
                    }
                    Iterator it = is.getPartitionSet().iterator();
                    if (it.hasNext()) {
                        String partitionName = (String)it.next();
                        int numChars = partitionName.length();
                        Map stateMap = is.getInstanceStateMap(partitionName);
                        for (Map.Entry entry : stateMap.entrySet()) {
                            numChars += ((String)entry.getKey()).length();
                            numChars += ((String)entry.getValue()).length();
                        }
                        if (_minNumCharsInISToTurnOnCompression > 0 && (numChars *= is.getNumPartitions()) > _minNumCharsInISToTurnOnCompression) {
                            return true;
                        }
                    }
                    return false;
                }
            });
            return idealStateWrapper._idealState;
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while updating ideal state for resource: " + resourceName, e);
        }
    }

    public static IdealState updateIdealState(HelixManager helixManager, String resourceName, Function<IdealState, IdealState> updater) {
        return HelixHelper.updateIdealState(helixManager, resourceName, updater, DEFAULT_TABLE_IDEALSTATES_UPDATE_RETRY_POLICY, false);
    }

    public static IdealState updateIdealState(HelixManager helixManager, String resourceName, Function<IdealState, IdealState> updater, RetryPolicy policy) {
        return HelixHelper.updateIdealState(helixManager, resourceName, updater, policy, false);
    }

    public static void updateBrokerResource(HelixManager helixManager, String brokerId, List<String> brokerTags, @Nullable List<String> tablesAdded, @Nullable List<String> tablesRemoved) {
        Preconditions.checkArgument((boolean)InstanceTypeUtils.isBroker((String)brokerId), (String)"Invalid broker id: %s", (Object)brokerId);
        for (String brokerTag : brokerTags) {
            Preconditions.checkArgument((boolean)TagNameUtils.isBrokerTag(brokerTag), (String)"Invalid broker tag: %s", (Object)brokerTag);
        }
        int numBrokerTags = brokerTags.size();
        Set<Object> tablesForBrokerTag = numBrokerTags == 0 ? Collections.emptySet() : (numBrokerTags == 1 ? HelixHelper.getTablesForBrokerTag(helixManager, brokerTags.get(0)) : HelixHelper.getTablesForBrokerTags(helixManager, brokerTags));
        HelixHelper.updateIdealState(helixManager, BROKER_RESOURCE, (Function<IdealState, IdealState>)((Function)idealState -> {
            if (tablesAdded != null) {
                tablesAdded.clear();
            }
            if (tablesRemoved != null) {
                tablesRemoved.clear();
            }
            for (Map.Entry entry : idealState.getRecord().getMapFields().entrySet()) {
                String tableNameWithType = (String)entry.getKey();
                Map brokerAssignment = (Map)entry.getValue();
                if (tablesForBrokerTag.contains(tableNameWithType)) {
                    if (brokerAssignment.put(brokerId, ONLINE) != null || tablesAdded == null) continue;
                    tablesAdded.add(tableNameWithType);
                    continue;
                }
                if (brokerAssignment.remove(brokerId) == null || tablesRemoved == null) continue;
                tablesRemoved.add(tableNameWithType);
            }
            return idealState;
        }));
    }

    public static List<String> getAllInstances(HelixAdmin helixAdmin, String clusterName) {
        return helixAdmin.getInstancesInCluster(clusterName);
    }

    public static Set<String> getAllInstancesForResource(IdealState idealState) {
        HashSet<String> instances = new HashSet<String>();
        for (String partition : idealState.getPartitionSet()) {
            for (String instance : idealState.getInstanceSet(partition)) {
                instances.add(instance);
            }
        }
        return instances;
    }

    public static void setInstanceState(String instanceName, String clusterName, HelixAdmin admin, boolean enable) {
        admin.enableInstance(clusterName, instanceName, enable);
    }

    public static void setStateForInstanceList(List<String> instances, String clusterName, HelixAdmin admin, boolean enable) {
        for (String instance : instances) {
            HelixHelper.setInstanceState(instance, clusterName, admin, enable);
        }
    }

    public static void setStateForInstanceSet(Set<String> instances, String clusterName, HelixAdmin admin, boolean enable) {
        for (String instanceName : instances) {
            HelixHelper.setInstanceState(instanceName, clusterName, admin, enable);
        }
    }

    public static Map<String, String> getInstanceConfigsMapFor(String instanceName, String clusterName, HelixAdmin admin) {
        HelixConfigScope scope = HelixHelper.getInstanceScopefor(clusterName, instanceName);
        List keys = admin.getConfigKeys(scope);
        return admin.getConfig(scope, keys);
    }

    public static HelixConfigScope getInstanceScopefor(String clusterName, String instanceName) {
        return new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.PARTICIPANT, new String[]{clusterName}).forParticipant(instanceName).build();
    }

    public static HelixConfigScope getResourceScopeFor(String clusterName, String resourceName) {
        return new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.RESOURCE, new String[]{clusterName}).forResource(resourceName).build();
    }

    public static Map<String, String> getResourceConfigsFor(String clusterName, String resourceName, HelixAdmin admin) {
        HelixConfigScope scope = HelixHelper.getResourceScopeFor(clusterName, resourceName);
        List keys = admin.getConfigKeys(scope);
        return admin.getConfig(scope, keys);
    }

    public static void updateResourceConfigsFor(Map<String, String> newConfigs, String resourceName, String clusterName, HelixAdmin admin) {
        HelixConfigScope scope = HelixHelper.getResourceScopeFor(clusterName, resourceName);
        admin.setConfig(scope, newConfigs);
    }

    public static void deleteResourcePropertyFromHelix(HelixAdmin admin, String clusterName, String resourceName, String configKey) {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(configKey);
        HelixConfigScope scope = HelixHelper.getResourceScopeFor(clusterName, resourceName);
        admin.removeConfig(scope, keys);
    }

    public static IdealState getTableIdealState(HelixManager manager, String resourceName) {
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        PropertyKey.Builder builder = accessor.keyBuilder();
        return (IdealState)accessor.getProperty(builder.idealStates(resourceName));
    }

    public static ExternalView getExternalViewForResource(HelixAdmin admin, String clusterName, String resourceName) {
        return admin.getResourceExternalView(clusterName, resourceName);
    }

    public static Map<String, String> getBrokerResourceConfig(HelixAdmin admin, String clusterName) {
        return HelixHelper.getResourceConfigsFor(clusterName, BROKER_RESOURCE, admin);
    }

    public static void updateBrokerConfig(Map<String, String> brokerResourceConfig, HelixAdmin admin, String clusterName) {
        HelixHelper.updateResourceConfigsFor(brokerResourceConfig, BROKER_RESOURCE, clusterName, admin);
    }

    public static IdealState getBrokerIdealStates(HelixAdmin admin, String clusterName) {
        return admin.getResourceIdealState(clusterName, BROKER_RESOURCE);
    }

    public static void removeResourceFromBrokerIdealState(HelixManager helixManager, final String resourceTag) {
        Function<IdealState, IdealState> updater = new Function<IdealState, IdealState>(){

            public IdealState apply(IdealState idealState) {
                if (idealState.getPartitionSet().contains(resourceTag)) {
                    idealState.getPartitionSet().remove(resourceTag);
                    return idealState;
                }
                return null;
            }
        };
        LOGGER.info("Trying to remove resource {} from idealstate", (Object)resourceTag);
        HelixHelper.updateIdealState(helixManager, BROKER_RESOURCE, updater, DEFAULT_RETRY_POLICY);
    }

    public static Set<String> getOnlineInstanceFromExternalView(ExternalView resourceExternalView) {
        HashSet<String> instanceSet = new HashSet<String>();
        if (resourceExternalView != null) {
            for (String partition : resourceExternalView.getPartitionSet()) {
                Map stateMap = resourceExternalView.getStateMap(partition);
                for (String instance : stateMap.keySet()) {
                    if (!((String)stateMap.get(instance)).equalsIgnoreCase(ONLINE)) continue;
                    instanceSet.add(instance);
                }
            }
        }
        return instanceSet;
    }

    public static Set<String> getOfflineInstanceFromExternalView(ExternalView resourceExternalView) {
        HashSet<String> instanceSet = new HashSet<String>();
        for (String partition : resourceExternalView.getPartitionSet()) {
            Map stateMap = resourceExternalView.getStateMap(partition);
            for (String instance : stateMap.keySet()) {
                if (!((String)stateMap.get(instance)).equalsIgnoreCase(OFFLINE)) continue;
                instanceSet.add(instance);
            }
        }
        return instanceSet;
    }

    public static void removeSegmentFromIdealState(HelixManager helixManager, String tableName, final String segmentName) {
        Function<IdealState, IdealState> updater = new Function<IdealState, IdealState>(){

            public IdealState apply(IdealState idealState) {
                if (idealState == null) {
                    return idealState;
                }
                Set partitionSet = idealState.getPartitionSet();
                if (partitionSet != null) {
                    partitionSet.remove(segmentName);
                }
                return idealState;
            }
        };
        HelixHelper.updateIdealState(helixManager, tableName, updater, DEFAULT_RETRY_POLICY);
    }

    public static void removeSegmentsFromIdealState(HelixManager helixManager, String tableName, final List<String> segments) {
        Function<IdealState, IdealState> updater = new Function<IdealState, IdealState>(){

            @Nullable
            public IdealState apply(@Nullable IdealState idealState) {
                if (idealState == null) {
                    return idealState;
                }
                Set partitionSet = idealState.getPartitionSet();
                if (partitionSet != null) {
                    partitionSet.removeAll(segments);
                }
                return idealState;
            }
        };
        HelixHelper.updateIdealState(helixManager, tableName, updater, DEFAULT_RETRY_POLICY);
    }

    public static List<InstanceConfig> getInstanceConfigs(HelixManager helixManager) {
        HelixDataAccessor helixDataAccessor = helixManager.getHelixDataAccessor();
        return helixDataAccessor.getChildValues(helixDataAccessor.keyBuilder().instanceConfigs(), true);
    }

    public static List<String> getInstancesWithTag(HelixManager helixManager, String tag) {
        return HelixHelper.getInstancesWithTag(HelixHelper.getInstanceConfigs(helixManager), tag);
    }

    public static List<String> getInstancesWithTag(List<InstanceConfig> instanceConfigs, String tag) {
        List<InstanceConfig> instancesWithTag = HelixHelper.getInstancesConfigsWithTag(instanceConfigs, tag);
        return instancesWithTag.stream().map(InstanceConfig::getInstanceName).collect(Collectors.toList());
    }

    public static List<InstanceConfig> getInstancesConfigsWithTag(List<InstanceConfig> instanceConfigs, String tag) {
        ArrayList<InstanceConfig> instancesWithTag = new ArrayList<InstanceConfig>();
        for (InstanceConfig instanceConfig : instanceConfigs) {
            if (!instanceConfig.containsTag(tag)) continue;
            instancesWithTag.add(instanceConfig);
        }
        return instancesWithTag;
    }

    public static List<String> getEnabledInstancesWithTag(HelixManager helixManager, String tag) {
        return HelixHelper.getEnabledInstancesWithTag(HelixHelper.getInstanceConfigs(helixManager), tag);
    }

    public static List<String> getEnabledInstancesWithTag(List<InstanceConfig> instanceConfigs, String tag) {
        ArrayList<String> enabledInstancesWithTag = new ArrayList<String>();
        for (InstanceConfig instanceConfig : instanceConfigs) {
            if (!instanceConfig.getInstanceEnabled() || !instanceConfig.containsTag(tag)) continue;
            enabledInstancesWithTag.add(instanceConfig.getInstanceName());
        }
        return enabledInstancesWithTag;
    }

    public static Set<String> getServerInstancesForTenant(HelixManager helixManager, String tenant) {
        return HelixHelper.getServerInstancesForTenant(HelixHelper.getInstanceConfigs(helixManager), tenant);
    }

    public static Set<String> getServerInstancesForTenant(List<InstanceConfig> instanceConfigs, String tenant) {
        return HelixHelper.getServerInstancesForTenantWithType(instanceConfigs, tenant, null);
    }

    public static Set<String> getServerInstancesForTenantWithType(List<InstanceConfig> instanceConfigs, String tenant, TableType tableType) {
        HashSet<String> serverInstancesWithType = new HashSet<String>();
        if (tableType == null || tableType == TableType.OFFLINE) {
            serverInstancesWithType.addAll(HelixHelper.getInstancesWithTag(instanceConfigs, TagNameUtils.getOfflineTagForTenant(tenant)));
        }
        if (tableType == null || tableType == TableType.REALTIME) {
            serverInstancesWithType.addAll(HelixHelper.getInstancesWithTag(instanceConfigs, TagNameUtils.getRealtimeTagForTenant(tenant)));
        }
        return serverInstancesWithType;
    }

    public static Set<String> getBrokerInstancesForTenant(List<InstanceConfig> instanceConfigs, String tenant) {
        return new HashSet<String>(HelixHelper.getInstancesWithTag(instanceConfigs, TagNameUtils.getBrokerTagForTenant(tenant)));
    }

    public static Set<InstanceConfig> getBrokerInstanceConfigsForTenant(List<InstanceConfig> instanceConfigs, String tenant) {
        return new HashSet<InstanceConfig>(HelixHelper.getInstancesConfigsWithTag(instanceConfigs, TagNameUtils.getBrokerTagForTenant(tenant)));
    }

    public static Set<String> getTablesForBrokerTag(HelixManager helixManager, String brokerTag) {
        HashSet<String> tablesForBrokerTag = new HashSet<String>();
        List<TableConfig> tableConfigs = ZKMetadataProvider.getAllTableConfigs((ZkHelixPropertyStore<ZNRecord>)helixManager.getHelixPropertyStore());
        for (TableConfig tableConfig : tableConfigs) {
            if (!TagNameUtils.getBrokerTagForTenant(tableConfig.getTenantConfig().getBroker()).equals(brokerTag)) continue;
            tablesForBrokerTag.add(tableConfig.getTableName());
        }
        return tablesForBrokerTag;
    }

    public static Set<String> getTablesForBrokerTags(HelixManager helixManager, List<String> brokerTags) {
        HashSet<String> tablesForBrokerTags = new HashSet<String>();
        List<TableConfig> tableConfigs = ZKMetadataProvider.getAllTableConfigs((ZkHelixPropertyStore<ZNRecord>)helixManager.getHelixPropertyStore());
        for (TableConfig tableConfig : tableConfigs) {
            if (!brokerTags.contains(TagNameUtils.getBrokerTagForTenant(tableConfig.getTenantConfig().getBroker()))) continue;
            tablesForBrokerTags.add(tableConfig.getTableName());
        }
        return tablesForBrokerTags;
    }

    public static InstanceConfig getInstanceConfig(HelixManager helixManager, String instanceId) {
        HelixAdmin admin = helixManager.getClusterManagmentTool();
        String clusterName = helixManager.getClusterName();
        return admin.getInstanceConfig(clusterName, instanceId);
    }

    public static void updateInstanceConfig(HelixManager helixManager, InstanceConfig instanceConfig) {
        HelixDataAccessor helixDataAccessor = helixManager.getHelixDataAccessor();
        Preconditions.checkState((boolean)helixDataAccessor.setProperty(helixDataAccessor.keyBuilder().instanceConfig(instanceConfig.getId()), (HelixProperty)instanceConfig), (Object)("Failed to update instance config for instance: " + instanceConfig.getId()));
    }

    public static boolean updateHostnamePort(InstanceConfig instanceConfig, String hostname, int port) {
        String existingPortStr;
        String portStr;
        boolean updated = false;
        String existingHostname = instanceConfig.getHostName();
        if (!hostname.equals(existingHostname)) {
            LOGGER.info("Updating instance: {} with hostname: {}", (Object)instanceConfig.getId(), (Object)hostname);
            instanceConfig.setHostName(hostname);
            updated = true;
        }
        if (!(portStr = Integer.toString(port)).equals(existingPortStr = instanceConfig.getPort())) {
            LOGGER.info("Updating instance: {} with port: {}", (Object)instanceConfig.getId(), (Object)port);
            instanceConfig.setPort(portStr);
            updated = true;
        }
        return updated;
    }

    public static boolean updateTlsPort(InstanceConfig instanceConfig, int tlsPort) {
        ExtraInstanceConfig pinotInstanceConfig = new ExtraInstanceConfig(instanceConfig);
        pinotInstanceConfig.setTlsPort(String.valueOf(tlsPort));
        return true;
    }

    public static boolean addDefaultTags(InstanceConfig instanceConfig, Supplier<List<String>> defaultTagsSupplier) {
        List<String> defaultTags;
        List instanceTags = instanceConfig.getTags();
        if (instanceTags.isEmpty() && !CollectionUtils.isEmpty(defaultTags = defaultTagsSupplier.get())) {
            LOGGER.info("Updating instance: {} with default tags: {}", (Object)instanceConfig.getId(), (Object)instanceTags);
            for (String defaultTag : defaultTags) {
                instanceConfig.addTag(defaultTag);
            }
            return true;
        }
        return false;
    }

    public static boolean removeDisabledPartitions(InstanceConfig instanceConfig) {
        ZNRecord record = instanceConfig.getRecord();
        String disabledPartitionsKey = InstanceConfig.InstanceConfigProperty.HELIX_DISABLED_PARTITION.name();
        boolean listUpdated = record.getListFields().remove(disabledPartitionsKey) != null;
        boolean mapUpdated = record.getMapFields().remove(disabledPartitionsKey) != null;
        return listUpdated | mapUpdated;
    }

    public static class PermanentUpdaterException
    extends RuntimeException {
        public PermanentUpdaterException(String message) {
            super(message);
        }

        public PermanentUpdaterException(Throwable cause) {
            super(cause);
        }
    }

    private static class IdealStateWrapper {
        IdealState _idealState;

        private IdealStateWrapper() {
        }
    }
}

