/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.grpc;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslProvider;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import nl.altindag.ssl.SSLFactory;
import org.apache.pinot.common.config.GrpcConfig;
import org.apache.pinot.common.config.TlsConfig;
import org.apache.pinot.common.proto.PinotQueryServerGrpc;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.common.utils.TlsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcQueryClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrpcQueryClient.class);
    private static final int DEFAULT_CHANNEL_SHUTDOWN_TIMEOUT_SECOND = 10;
    private final ManagedChannel _managedChannel;
    private final PinotQueryServerGrpc.PinotQueryServerBlockingStub _blockingStub;

    public GrpcQueryClient(String host, int port) {
        this(host, port, new GrpcConfig(Collections.emptyMap()));
    }

    public GrpcQueryClient(String host, int port, GrpcConfig config) {
        if (config.isUsePlainText()) {
            this._managedChannel = ManagedChannelBuilder.forAddress((String)host, (int)port).maxInboundMessageSize(config.getMaxInboundMessageSizeBytes()).usePlaintext().build();
        } else {
            try {
                TlsConfig tlsConfig = config.getTlsConfig();
                SSLFactory sslFactory = TlsUtils.createSSLFactory(tlsConfig);
                if (TlsUtils.isKeyOrTrustStorePathNullOrHasFileScheme(tlsConfig.getKeyStorePath()) && TlsUtils.isKeyOrTrustStorePathNullOrHasFileScheme(tlsConfig.getTrustStorePath())) {
                    TlsUtils.enableAutoRenewalFromFileStoreForSSLFactory(sslFactory, tlsConfig);
                }
                SslContextBuilder sslContextBuilder = SslContextBuilder.forClient();
                sslFactory.getKeyManagerFactory().ifPresent(arg_0 -> ((SslContextBuilder)sslContextBuilder).keyManager(arg_0));
                sslFactory.getTrustManagerFactory().ifPresent(arg_0 -> ((SslContextBuilder)sslContextBuilder).trustManager(arg_0));
                sslContextBuilder = tlsConfig.getSslProvider() != null ? GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder, (SslProvider)SslProvider.valueOf((String)tlsConfig.getSslProvider())) : GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder);
                this._managedChannel = NettyChannelBuilder.forAddress((String)host, (int)port).maxInboundMessageSize(config.getMaxInboundMessageSizeBytes()).sslContext(sslContextBuilder.build()).build();
            }
            catch (SSLException e) {
                throw new RuntimeException("Failed to create Netty gRPC channel with SSL Context", e);
            }
        }
        this._blockingStub = PinotQueryServerGrpc.newBlockingStub((Channel)this._managedChannel);
    }

    public Iterator<Server.ServerResponse> submit(Server.ServerRequest request) {
        return this._blockingStub.submit(request);
    }

    public void close() {
        if (!this._managedChannel.isShutdown()) {
            try {
                this._managedChannel.shutdownNow();
                if (!this._managedChannel.awaitTermination(10L, TimeUnit.SECONDS)) {
                    LOGGER.warn("Timed out forcefully shutting down connection: {}. ", (Object)this._managedChannel);
                }
            }
            catch (Exception e) {
                LOGGER.error("Unexpected exception while waiting for channel termination", (Throwable)e);
            }
        }
    }
}

