/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.fetcher;

import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.pinot.common.utils.ClientSSLContextGenerator;
import org.apache.pinot.common.utils.FileUploadDownloadClient;
import org.apache.pinot.common.utils.fetcher.HttpSegmentFetcher;
import org.apache.pinot.common.utils.http.HttpClientConfig;
import org.apache.pinot.spi.env.PinotConfiguration;

public class HttpsSegmentFetcher
extends HttpSegmentFetcher {
    @Override
    protected void doInit(PinotConfiguration config) {
        PinotConfiguration sslConfig = config.subset("ssl");
        this._logger.info("Initializing with the following ssl config:");
        Set<String> protectedConfigKeys = ClientSSLContextGenerator.getProtectedConfigKeys();
        for (String configKey : sslConfig.getKeys()) {
            if (protectedConfigKeys.contains(configKey)) {
                this._logger.info("{}: {}", (Object)configKey, (Object)"********");
                continue;
            }
            this._logger.info("{}: {}", (Object)configKey, (Object)config.getProperty(configKey));
        }
        SSLContext sslContext = new ClientSSLContextGenerator(sslConfig).generate();
        this._httpClient = new FileUploadDownloadClient(HttpClientConfig.newBuilder(config).build(), sslContext);
    }
}

