/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.fetcher;

import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.pinot.common.auth.AuthProviderUtils;
import org.apache.pinot.common.utils.fetcher.SegmentFetcher;
import org.apache.pinot.spi.auth.AuthProvider;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.retry.RetryPolicies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSegmentFetcher
implements SegmentFetcher {
    public static final String RETRY_COUNT_CONFIG_KEY = "retry.count";
    public static final String RETRY_WAIT_MS_CONFIG_KEY = "retry.wait.ms";
    public static final String RETRY_DELAY_SCALE_FACTOR_CONFIG_KEY = "retry.delay.scale.factor";
    public static final int DEFAULT_RETRY_COUNT = 3;
    public static final int DEFAULT_RETRY_WAIT_MS = 100;
    public static final int DEFAULT_RETRY_DELAY_SCALE_FACTOR = 5;
    protected final Logger _logger = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    protected int _retryCount;
    protected int _retryWaitMs;
    protected int _retryDelayScaleFactor;
    protected AuthProvider _authProvider;

    @Override
    public void init(PinotConfiguration config) {
        this._retryCount = config.getProperty(RETRY_COUNT_CONFIG_KEY, 3);
        this._retryWaitMs = config.getProperty(RETRY_WAIT_MS_CONFIG_KEY, 100);
        this._retryDelayScaleFactor = config.getProperty(RETRY_DELAY_SCALE_FACTOR_CONFIG_KEY, 5);
        this._authProvider = AuthProviderUtils.extractAuthProvider(config, "auth");
        this.doInit(config);
        this._logger.info("Initialized with retryCount: {}, retryWaitMs: {}, retryDelayScaleFactor: {}", new Object[]{this._retryCount, this._retryWaitMs, this._retryDelayScaleFactor});
    }

    protected void doInit(PinotConfiguration config) {
    }

    @Override
    public void fetchSegmentToLocal(URI uri, File dest) throws Exception {
        RetryPolicies.exponentialBackoffRetryPolicy((int)this._retryCount, (long)this._retryWaitMs, (double)this._retryDelayScaleFactor).attempt(() -> {
            try {
                this.fetchSegmentToLocalWithoutRetry(uri, dest);
                this._logger.info("Fetched segment from: {} to: {} of size: {}", new Object[]{uri, dest, dest.length()});
                return true;
            }
            catch (Exception e) {
                this._logger.warn("Caught exception while fetching segment from: {} to: {}", new Object[]{uri, dest, e});
                return false;
            }
        });
    }

    @Override
    public void fetchSegmentToLocal(List<URI> uris, File dest) throws Exception {
        if (uris == null || uris.isEmpty()) {
            throw new IllegalArgumentException("The input uri list is null or empty");
        }
        Random r = new Random();
        RetryPolicies.exponentialBackoffRetryPolicy((int)this._retryCount, (long)this._retryWaitMs, (double)this._retryDelayScaleFactor).attempt(() -> {
            URI uri = (URI)uris.get(r.nextInt(uris.size()));
            try {
                this.fetchSegmentToLocalWithoutRetry(uri, dest);
                this._logger.info("Fetched segment from: {} to: {} of size: {}", new Object[]{uri, dest, dest.length()});
                return true;
            }
            catch (Exception e) {
                this._logger.warn("Caught exception while fetching segment from: {} to: {}", new Object[]{uri, dest, e});
                return false;
            }
        });
    }

    @Override
    public File fetchUntarSegmentToLocalStreamed(URI uri, File dest, long rateLimit, AtomicInteger attempts) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fetchSegmentToLocal(String segmentName, Supplier<List<URI>> uriSupplier, File dest) throws Exception {
        try {
            int attempt = RetryPolicies.exponentialBackoffRetryPolicy((int)this._retryCount, (long)this._retryWaitMs, (double)this._retryDelayScaleFactor).attempt(() -> {
                List suppliedURIs = (List)uriSupplier.get();
                for (URI uri : suppliedURIs) {
                    try {
                        this.fetchSegmentToLocalWithoutRetry(uri, dest);
                        return true;
                    }
                    catch (Exception e) {
                        this._logger.warn("Download segment {} from peer {} failed.", new Object[]{segmentName, uri, e});
                    }
                }
                return false;
            });
            this._logger.info("Download segment {} successfully with {} attempts.", (Object)segmentName, (Object)(attempt + 1));
        }
        catch (Exception e) {
            this._logger.error("Failed to download segment {} after retries.", (Object)segmentName, (Object)e);
            throw e;
        }
    }

    protected void fetchSegmentToLocalWithoutRetry(URI uri, File dest) throws Exception {
        throw new UnsupportedOperationException();
    }
}

