/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;

public class ScalingThreadPoolExecutor
extends ThreadPoolExecutor {
    private final AtomicInteger _activeCount = new AtomicInteger();

    public ScalingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    @Override
    public int getActiveCount() {
        return this._activeCount.get();
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        this._activeCount.incrementAndGet();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        this._activeCount.decrementAndGet();
    }

    public static ExecutorService newScalingThreadPool(int min, int max, long keepAliveTime) {
        ScalingQueue<Runnable> queue = new ScalingQueue<Runnable>();
        ScalingThreadPoolExecutor executor = new ScalingThreadPoolExecutor(min, max, keepAliveTime, TimeUnit.MILLISECONDS, queue);
        executor.setRejectedExecutionHandler(new ForceQueuePolicy());
        queue.setThreadPoolExecutor(executor);
        return executor;
    }

    static class ScalingQueue<E>
    extends LinkedBlockingQueue<E> {
        private ThreadPoolExecutor _executor;

        public void setThreadPoolExecutor(ThreadPoolExecutor executor) {
            this._executor = executor;
        }

        @Override
        public boolean offer(@Nonnull E e) {
            int allWorkingThreads = this._executor.getActiveCount() + super.size();
            return allWorkingThreads < this._executor.getPoolSize() && super.offer(e);
        }
    }

    static class ForceQueuePolicy
    implements RejectedExecutionHandler {
        ForceQueuePolicy() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException(e);
            }
        }
    }
}

