/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import com.google.common.base.Preconditions;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ExponentialMovingAverage {
    private final double _alpha;
    private final long _autoDecayWindowMs;
    private final long _warmUpDurationMs;
    private final long _initializationTimeMs;
    private volatile double _average;
    private long _lastUpdatedTimeMs;

    public ExponentialMovingAverage(double alpha, long autoDecayWindowMs, long warmUpDurationMs, double avgInitializationVal, @Nullable ScheduledExecutorService periodicTaskExecutor) {
        Preconditions.checkState((alpha >= 0.0 && alpha <= 1.0 ? 1 : 0) != 0, (Object)"Alpha should be between 0 and 1");
        this._alpha = alpha;
        Preconditions.checkState((warmUpDurationMs >= 0L ? 1 : 0) != 0, (Object)"warmUpDurationMs is negative.");
        this._warmUpDurationMs = warmUpDurationMs;
        Preconditions.checkState((avgInitializationVal >= 0.0 ? 1 : 0) != 0, (Object)"avgInitializationVal is negative.");
        this._average = avgInitializationVal;
        this._initializationTimeMs = System.currentTimeMillis();
        this._lastUpdatedTimeMs = 0L;
        this._autoDecayWindowMs = autoDecayWindowMs;
        if (this._autoDecayWindowMs > 0L) {
            Preconditions.checkState((periodicTaskExecutor != null ? 1 : 0) != 0);
            periodicTaskExecutor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (ExponentialMovingAverage.this._lastUpdatedTimeMs > 0L && System.currentTimeMillis() - ExponentialMovingAverage.this._lastUpdatedTimeMs > ExponentialMovingAverage.this._autoDecayWindowMs) {
                        ExponentialMovingAverage.this.compute(0.0);
                    }
                }
            }, 0L, this._autoDecayWindowMs, TimeUnit.MILLISECONDS);
        }
    }

    public double getAverage() {
        return this._average;
    }

    public synchronized double compute(double value) {
        long currTime;
        this._lastUpdatedTimeMs = currTime = System.currentTimeMillis();
        if (this._initializationTimeMs + this._warmUpDurationMs > currTime) {
            return this._average;
        }
        this._average = value * this._alpha + this._average * (1.0 - this._alpha);
        return this._average;
    }
}

