/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.tier;

import com.google.common.base.Preconditions;
import org.apache.helix.HelixManager;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.tier.TierSegmentSelector;
import org.apache.pinot.spi.utils.TimeUtils;

public class TimeBasedTierSegmentSelector
implements TierSegmentSelector {
    private final long _segmentAgeMillis;
    private final HelixManager _helixManager;

    public TimeBasedTierSegmentSelector(HelixManager helixManager, String segmentAge) {
        this._segmentAgeMillis = TimeUtils.convertPeriodToMillis((String)segmentAge);
        this._helixManager = helixManager;
    }

    @Override
    public String getType() {
        return "time";
    }

    @Override
    public boolean selectSegment(String tableNameWithType, String segmentName) {
        SegmentZKMetadata segmentZKMetadata = ZKMetadataProvider.getSegmentZKMetadata((ZkHelixPropertyStore<ZNRecord>)this._helixManager.getHelixPropertyStore(), tableNameWithType, segmentName);
        Preconditions.checkNotNull((Object)segmentZKMetadata, (String)"Could not find zk metadata for segment: {} of table: {}", (Object)segmentName, (Object)tableNameWithType);
        if (!segmentZKMetadata.getStatus().isCompleted()) {
            return false;
        }
        long endTimeMs = segmentZKMetadata.getEndTimeMs();
        Preconditions.checkState((endTimeMs > 0L ? 1 : 0) != 0, (String)"Invalid endTimeMs: %s for segment: %s of table: %s", (Object)endTimeMs, (Object)segmentName, (Object)tableNameWithType);
        long now = System.currentTimeMillis();
        return now - endTimeMs > this._segmentAgeMillis;
    }

    public long getSegmentAgeMillis() {
        return this._segmentAgeMillis;
    }

    public String toString() {
        return "TimeBasedTierSegmentSelector{_segmentAgeMillis=" + this._segmentAgeMillis + "}";
    }
}

