/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.request.context;

import java.util.Objects;
import java.util.Set;
import org.apache.pinot.common.request.context.ExpressionContext;

public class OrderByExpressionContext {
    private final ExpressionContext _expression;
    private final boolean _isAsc;
    private final Boolean _isNullsLast;

    public OrderByExpressionContext(ExpressionContext expression, boolean isAsc) {
        this._expression = expression;
        this._isAsc = isAsc;
        this._isNullsLast = null;
    }

    public OrderByExpressionContext(ExpressionContext expression, boolean isAsc, boolean isNullsLast) {
        this._expression = expression;
        this._isAsc = isAsc;
        this._isNullsLast = isNullsLast;
    }

    public ExpressionContext getExpression() {
        return this._expression;
    }

    public boolean isAsc() {
        return this._isAsc;
    }

    public boolean isNullsLast() {
        if (this._isNullsLast == null) {
            return this._isAsc;
        }
        return this._isNullsLast;
    }

    public void getColumns(Set<String> columns) {
        this._expression.getColumns(columns);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OrderByExpressionContext)) {
            return false;
        }
        OrderByExpressionContext that = (OrderByExpressionContext)o;
        return Objects.equals(this._expression, that._expression) && this._isAsc == that._isAsc && this._isNullsLast == that._isNullsLast;
    }

    public int hashCode() {
        return Objects.hash(this._expression, this._isAsc, this._isNullsLast);
    }

    public String toString() {
        if (this._isNullsLast != null) {
            return this._expression.toString() + (this._isAsc ? " ASC" : " DESC") + (this._isNullsLast != false ? " NULLS LAST" : " NULLS FIRST");
        }
        return this._expression.toString() + (this._isAsc ? " ASC" : " DESC");
    }
}

