/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.request;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.Identifier;
import org.apache.pinot.common.request.Literal;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class Expression
implements TBase<Expression, _Fields>,
Serializable,
Cloneable,
Comparable<Expression> {
    private static final TStruct STRUCT_DESC = new TStruct("Expression");
    private static final TField TYPE_FIELD_DESC = new TField("type", 8, 1);
    private static final TField FUNCTION_CALL_FIELD_DESC = new TField("functionCall", 12, 2);
    private static final TField LITERAL_FIELD_DESC = new TField("literal", 12, 3);
    private static final TField IDENTIFIER_FIELD_DESC = new TField("identifier", 12, 4);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new ExpressionStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new ExpressionTupleSchemeFactory();
    @Nullable
    private ExpressionType type;
    @Nullable
    private Function functionCall;
    @Nullable
    private Literal literal;
    @Nullable
    private Identifier identifier;
    private static final _Fields[] optionals = new _Fields[]{_Fields.FUNCTION_CALL, _Fields.LITERAL, _Fields.IDENTIFIER};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public Expression() {
    }

    public Expression(ExpressionType type) {
        this();
        this.type = type;
    }

    public Expression(Expression other) {
        if (other.isSetType()) {
            this.type = other.type;
        }
        if (other.isSetFunctionCall()) {
            this.functionCall = new Function(other.functionCall);
        }
        if (other.isSetLiteral()) {
            this.literal = new Literal(other.literal);
        }
        if (other.isSetIdentifier()) {
            this.identifier = new Identifier(other.identifier);
        }
    }

    public Expression deepCopy() {
        return new Expression(this);
    }

    public void clear() {
        this.type = null;
        this.functionCall = null;
        this.literal = null;
        this.identifier = null;
    }

    @Nullable
    public ExpressionType getType() {
        return this.type;
    }

    public void setType(@Nullable ExpressionType type) {
        this.type = type;
    }

    public void unsetType() {
        this.type = null;
    }

    public boolean isSetType() {
        return this.type != null;
    }

    public void setTypeIsSet(boolean value) {
        if (!value) {
            this.type = null;
        }
    }

    @Nullable
    public Function getFunctionCall() {
        return this.functionCall;
    }

    public void setFunctionCall(@Nullable Function functionCall) {
        this.functionCall = functionCall;
    }

    public void unsetFunctionCall() {
        this.functionCall = null;
    }

    public boolean isSetFunctionCall() {
        return this.functionCall != null;
    }

    public void setFunctionCallIsSet(boolean value) {
        if (!value) {
            this.functionCall = null;
        }
    }

    @Nullable
    public Literal getLiteral() {
        return this.literal;
    }

    public void setLiteral(@Nullable Literal literal) {
        this.literal = literal;
    }

    public void unsetLiteral() {
        this.literal = null;
    }

    public boolean isSetLiteral() {
        return this.literal != null;
    }

    public void setLiteralIsSet(boolean value) {
        if (!value) {
            this.literal = null;
        }
    }

    @Nullable
    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(@Nullable Identifier identifier) {
        this.identifier = identifier;
    }

    public void unsetIdentifier() {
        this.identifier = null;
    }

    public boolean isSetIdentifier() {
        return this.identifier != null;
    }

    public void setIdentifierIsSet(boolean value) {
        if (!value) {
            this.identifier = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case TYPE: {
                if (value == null) {
                    this.unsetType();
                    break;
                }
                this.setType((ExpressionType)((Object)value));
                break;
            }
            case FUNCTION_CALL: {
                if (value == null) {
                    this.unsetFunctionCall();
                    break;
                }
                this.setFunctionCall((Function)value);
                break;
            }
            case LITERAL: {
                if (value == null) {
                    this.unsetLiteral();
                    break;
                }
                this.setLiteral((Literal)((Object)value));
                break;
            }
            case IDENTIFIER: {
                if (value == null) {
                    this.unsetIdentifier();
                    break;
                }
                this.setIdentifier((Identifier)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TYPE: {
                return this.getType();
            }
            case FUNCTION_CALL: {
                return this.getFunctionCall();
            }
            case LITERAL: {
                return this.getLiteral();
            }
            case IDENTIFIER: {
                return this.getIdentifier();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TYPE: {
                return this.isSetType();
            }
            case FUNCTION_CALL: {
                return this.isSetFunctionCall();
            }
            case LITERAL: {
                return this.isSetLiteral();
            }
            case IDENTIFIER: {
                return this.isSetIdentifier();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof Expression) {
            return this.equals((Expression)that);
        }
        return false;
    }

    public boolean equals(Expression that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_type = this.isSetType();
        boolean that_present_type = that.isSetType();
        if (this_present_type || that_present_type) {
            if (!this_present_type || !that_present_type) {
                return false;
            }
            if (!this.type.equals((Object)that.type)) {
                return false;
            }
        }
        boolean this_present_functionCall = this.isSetFunctionCall();
        boolean that_present_functionCall = that.isSetFunctionCall();
        if (this_present_functionCall || that_present_functionCall) {
            if (!this_present_functionCall || !that_present_functionCall) {
                return false;
            }
            if (!this.functionCall.equals(that.functionCall)) {
                return false;
            }
        }
        boolean this_present_literal = this.isSetLiteral();
        boolean that_present_literal = that.isSetLiteral();
        if (this_present_literal || that_present_literal) {
            if (!this_present_literal || !that_present_literal) {
                return false;
            }
            if (!this.literal.equals(that.literal)) {
                return false;
            }
        }
        boolean this_present_identifier = this.isSetIdentifier();
        boolean that_present_identifier = that.isSetIdentifier();
        if (this_present_identifier || that_present_identifier) {
            if (!this_present_identifier || !that_present_identifier) {
                return false;
            }
            if (!this.identifier.equals(that.identifier)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetType() ? 131071 : 524287);
        if (this.isSetType()) {
            hashCode = hashCode * 8191 + this.type.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetFunctionCall() ? 131071 : 524287);
        if (this.isSetFunctionCall()) {
            hashCode = hashCode * 8191 + this.functionCall.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetLiteral() ? 131071 : 524287);
        if (this.isSetLiteral()) {
            hashCode = hashCode * 8191 + this.literal.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetIdentifier() ? 131071 : 524287);
        if (this.isSetIdentifier()) {
            hashCode = hashCode * 8191 + this.identifier.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(Expression other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetType(), other.isSetType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.type), (Comparable)((Object)other.type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetFunctionCall(), other.isSetFunctionCall());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFunctionCall() && (lastComparison = TBaseHelper.compareTo((Comparable)this.functionCall, (Comparable)other.functionCall)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetLiteral(), other.isSetLiteral());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLiteral() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.literal), (Comparable)((Object)other.literal))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetIdentifier(), other.isSetIdentifier());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIdentifier() && (lastComparison = TBaseHelper.compareTo((Comparable)this.identifier, (Comparable)other.identifier)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        Expression.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        Expression.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Expression(");
        boolean first = true;
        sb.append("type:");
        if (this.type == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.type);
        }
        first = false;
        if (this.isSetFunctionCall()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("functionCall:");
            if (this.functionCall == null) {
                sb.append("null");
            } else {
                sb.append(this.functionCall);
            }
            first = false;
        }
        if (this.isSetLiteral()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("literal:");
            if (this.literal == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.literal);
            }
            first = false;
        }
        if (this.isSetIdentifier()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("identifier:");
            if (this.identifier == null) {
                sb.append("null");
            } else {
                sb.append(this.identifier);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetType()) {
            throw new TProtocolException("Required field 'type' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TYPE, new FieldMetaData("type", 1, new FieldValueMetaData(16, "ExpressionType")));
        tmpMap.put(_Fields.FUNCTION_CALL, new FieldMetaData("functionCall", 2, new FieldValueMetaData(12, "Function")));
        tmpMap.put(_Fields.LITERAL, new FieldMetaData("literal", 2, new FieldValueMetaData(12, "Literal")));
        tmpMap.put(_Fields.IDENTIFIER, new FieldMetaData("identifier", 2, new FieldValueMetaData(12, "Identifier")));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(Expression.class, metaDataMap);
    }

    private static class ExpressionTupleScheme
    extends TupleScheme<Expression> {
        private ExpressionTupleScheme() {
        }

        public void write(TProtocol prot, Expression struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.type.getValue());
            BitSet optionals = new BitSet();
            if (struct.isSetFunctionCall()) {
                optionals.set(0);
            }
            if (struct.isSetLiteral()) {
                optionals.set(1);
            }
            if (struct.isSetIdentifier()) {
                optionals.set(2);
            }
            oprot.writeBitSet(optionals, 3);
            if (struct.isSetFunctionCall()) {
                struct.functionCall.write((TProtocol)oprot);
            }
            if (struct.isSetLiteral()) {
                struct.literal.write((TProtocol)oprot);
            }
            if (struct.isSetIdentifier()) {
                struct.identifier.write((TProtocol)oprot);
            }
        }

        public void read(TProtocol prot, Expression struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.type = ExpressionType.findByValue(iprot.readI32());
            struct.setTypeIsSet(true);
            BitSet incoming = iprot.readBitSet(3);
            if (incoming.get(0)) {
                struct.functionCall = new Function();
                struct.functionCall.read((TProtocol)iprot);
                struct.setFunctionCallIsSet(true);
            }
            if (incoming.get(1)) {
                struct.literal = new Literal();
                struct.literal.read((TProtocol)iprot);
                struct.setLiteralIsSet(true);
            }
            if (incoming.get(2)) {
                struct.identifier = new Identifier();
                struct.identifier.read((TProtocol)iprot);
                struct.setIdentifierIsSet(true);
            }
        }
    }

    private static class ExpressionTupleSchemeFactory
    implements SchemeFactory {
        private ExpressionTupleSchemeFactory() {
        }

        public ExpressionTupleScheme getScheme() {
            return new ExpressionTupleScheme();
        }
    }

    private static class ExpressionStandardScheme
    extends StandardScheme<Expression> {
        private ExpressionStandardScheme() {
        }

        public void read(TProtocol iprot, Expression struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 8) {
                            struct.type = ExpressionType.findByValue(iprot.readI32());
                            struct.setTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 12) {
                            struct.functionCall = new Function();
                            struct.functionCall.read(iprot);
                            struct.setFunctionCallIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 12) {
                            struct.literal = new Literal();
                            struct.literal.read(iprot);
                            struct.setLiteralIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 12) {
                            struct.identifier = new Identifier();
                            struct.identifier.read(iprot);
                            struct.setIdentifierIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, Expression struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.type != null) {
                oprot.writeFieldBegin(TYPE_FIELD_DESC);
                oprot.writeI32(struct.type.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.functionCall != null && struct.isSetFunctionCall()) {
                oprot.writeFieldBegin(FUNCTION_CALL_FIELD_DESC);
                struct.functionCall.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.literal != null && struct.isSetLiteral()) {
                oprot.writeFieldBegin(LITERAL_FIELD_DESC);
                struct.literal.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.identifier != null && struct.isSetIdentifier()) {
                oprot.writeFieldBegin(IDENTIFIER_FIELD_DESC);
                struct.identifier.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class ExpressionStandardSchemeFactory
    implements SchemeFactory {
        private ExpressionStandardSchemeFactory() {
        }

        public ExpressionStandardScheme getScheme() {
            return new ExpressionStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TYPE(1, "type"),
        FUNCTION_CALL(2, "functionCall"),
        LITERAL(3, "literal"),
        IDENTIFIER(4, "identifier");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TYPE;
                }
                case 2: {
                    return FUNCTION_CALL;
                }
                case 3: {
                    return LITERAL;
                }
                case 4: {
                    return IDENTIFIER;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

