/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metrics;

import org.apache.pinot.common.Utils;
import org.apache.pinot.common.metrics.AbstractMetrics;

public enum ControllerMeter implements AbstractMetrics.Meter
{
    HELIX_ZOOKEEPER_RECONNECTS("reconnects", true),
    HEALTHCHECK_OK_CALLS("healthcheck", true),
    HEALTHCHECK_BAD_CALLS("healthcheck", true),
    CONTROLLER_INSTANCE_POST_ERROR("InstancePostError", true),
    CONTROLLER_INSTANCE_DELETE_ERROR("InstanceDeleteError", true),
    CONTROLLER_SEGMENT_UPLOAD_ERROR("SegmentUploadError", true),
    CONTROLLER_SCHEMA_UPLOAD_ERROR("SchemaUploadError", true),
    CONTROLLER_TABLE_ADD_ERROR("TableAddError", true),
    CONTROLLER_TABLE_UPDATE_ERROR("TableUpdateError", true),
    CONTROLLER_TABLE_SCHEMA_UPDATE_ERROR("TableSchemaUpdateError", true),
    CONTROLLER_TABLE_TENANT_UPDATE_ERROR("TableTenantUpdateError", true),
    CONTROLLER_TABLE_TENANT_CREATE_ERROR("TableTenantCreateError", true),
    CONTROLLER_TABLE_TENANT_DELETE_ERROR("TableTenantDeleteError", true),
    CONTROLLER_REALTIME_TABLE_SEGMENT_ASSIGNMENT_ERROR("errors", true),
    CONTROLLER_REALTIME_TABLE_SEGMENT_ASSIGNMENT_MISMATCH("mismatch", true),
    CONTROLLER_LEADERSHIP_CHANGE_WITHOUT_CALLBACK("leadershipChangeWithoutCallback", true),
    LLC_STATE_MACHINE_ABORTS("aborts", false),
    LLC_ZOOKEEPER_FETCH_FAILURES("failures", false),
    LLC_ZOOKEEPER_UPDATE_FAILURES("failures", false),
    LLC_STREAM_DATA_LOSS("dataLoss", false),
    CONTROLLER_PERIODIC_TASK_RUN("periodicTaskRun", false),
    CONTROLLER_PERIODIC_TASK_ERROR("periodicTaskError", false),
    PERIODIC_TASK_ERROR("periodicTaskError", false),
    NUMBER_TIMES_SCHEDULE_TASKS_CALLED("tasks", true),
    NUMBER_TASKS_SUBMITTED("tasks", false),
    NUMBER_SEGMENT_UPLOAD_TIMEOUT_EXCEEDED("SegmentUploadTimeouts", true),
    NUMBER_START_REPLACE_FAILURE("NumStartReplaceFailure", false),
    NUMBER_END_REPLACE_FAILURE("NumEndReplaceFailure", false),
    NUMBER_REVERT_REPLACE_FAILURE("NumRevertReplaceFailure", false),
    CRON_SCHEDULER_JOB_TRIGGERED("cronSchedulerJobTriggered", false),
    CRON_SCHEDULER_JOB_SKIPPED("cronSchedulerJobSkipped", false),
    LLC_SEGMENTS_DEEP_STORE_UPLOAD_RETRY_SUCCESS("LLCSegmentDeepStoreUploadRetrySuccess", false),
    LLC_SEGMENTS_DEEP_STORE_UPLOAD_RETRY_ERROR("LLCSegmentDeepStoreUploadRetryError", false),
    SEGMENT_MISSING_DEEP_STORE_LINK("RealtimeSegmentMissingDeepStoreLink", false),
    DELETED_TMP_SEGMENT_COUNT("DeletedTmpSegmentCount", false),
    TABLE_REBALANCE_FAILURE_DETECTED("TableRebalanceFailureDetected", false),
    TABLE_REBALANCE_RETRY("TableRebalanceRetry", false),
    TABLE_REBALANCE_RETRY_TOO_MANY_TIMES("TableRebalanceRetryTooManyTimes", false),
    NUMBER_ADHOC_TASKS_SUBMITTED("adhocTasks", false);

    private final String _brokerMeterName;
    private final String _unit;
    private final boolean _global;

    private ControllerMeter(String unit, boolean global) {
        this._unit = unit;
        this._global = global;
        this._brokerMeterName = Utils.toCamelCase(this.name().toLowerCase());
    }

    @Override
    public String getMeterName() {
        return this._brokerMeterName;
    }

    @Override
    public String getUnit() {
        return this._unit;
    }

    @Override
    public boolean isGlobal() {
        return this._global;
    }
}

