/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.pinot.common.http.MultiHttpRequestResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiHttpRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiHttpRequest.class);
    private final Executor _executor;
    private final HttpClientConnectionManager _connectionManager;

    public MultiHttpRequest(Executor executor, HttpClientConnectionManager connectionManager) {
        this._executor = executor;
        this._connectionManager = connectionManager;
    }

    public CompletionService<MultiHttpRequestResponse> executeGet(List<String> urls, @Nullable Map<String, String> requestHeaders, int timeoutMs) {
        ArrayList<Pair<String, String>> urlsAndRequestBodies = new ArrayList<Pair<String, String>>();
        urls.forEach(url -> urlsAndRequestBodies.add(Pair.of((Object)url, (Object)"")));
        return this.execute(urlsAndRequestBodies, requestHeaders, timeoutMs, "GET", HttpGet::new);
    }

    public CompletionService<MultiHttpRequestResponse> executePost(List<Pair<String, String>> urlsAndRequestBodies, @Nullable Map<String, String> requestHeaders, int timeoutMs) {
        return this.execute(urlsAndRequestBodies, requestHeaders, timeoutMs, "POST", HttpPost::new);
    }

    public <T extends HttpRequestBase> CompletionService<MultiHttpRequestResponse> execute(List<Pair<String, String>> urlsAndRequestBodies, @Nullable Map<String, String> requestHeaders, int timeoutMs, String httpMethodName, Function<String, T> httpRequestBaseSupplier) {
        RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectionRequestTimeout(timeoutMs).setSocketTimeout(timeoutMs).build();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager(this._connectionManager).setDefaultRequestConfig(defaultRequestConfig);
        ExecutorCompletionService<MultiHttpRequestResponse> completionService = new ExecutorCompletionService<MultiHttpRequestResponse>(this._executor);
        CloseableHttpClient client = httpClientBuilder.build();
        for (Pair<String, String> pair : urlsAndRequestBodies) {
            completionService.submit(() -> {
                String url = (String)pair.getLeft();
                String body = (String)pair.getRight();
                HttpRequestBase httpMethod = (HttpRequestBase)httpRequestBaseSupplier.apply(url);
                if (httpMethod instanceof HttpPost) {
                    ((HttpPost)httpMethod).setEntity((HttpEntity)new StringEntity(body));
                }
                if (requestHeaders != null) {
                    requestHeaders.forEach((arg_0, arg_1) -> ((HttpRequestBase)httpMethod).setHeader(arg_0, arg_1));
                }
                CloseableHttpResponse response = null;
                try {
                    response = client.execute((HttpUriRequest)httpMethod);
                    return new MultiHttpRequestResponse(httpMethod.getURI(), response);
                }
                catch (IOException ex) {
                    if (response != null) {
                        String error = EntityUtils.toString((HttpEntity)response.getEntity());
                        LOGGER.warn("Caught '{}' while executing: {} on URL: {}", new Object[]{error, httpMethodName, url});
                    } else {
                        LOGGER.warn("Caught '{}' while executing: {} on URL: {}", new Object[]{ex, httpMethodName, url});
                    }
                    throw ex;
                }
            });
        }
        return completionService;
    }
}

