/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar;

import java.sql.Timestamp;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.common.function.DateTimePatternHandler;
import org.apache.pinot.common.function.DateTimeUtils;
import org.apache.pinot.common.function.TimeZoneKey;
import org.apache.pinot.spi.annotations.ScalarFunction;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

public class DateTimeFunctions {
    private DateTimeFunctions() {
    }

    @ScalarFunction(names={"toEpochSeconds", "to_epoch_seconds"})
    public static long toEpochSeconds(long millis) {
        return TimeUnit.MILLISECONDS.toSeconds(millis);
    }

    @ScalarFunction(names={"toEpochSecondsMV", "to_epoch_seconds_mv"})
    public static long[] toEpochSecondsMV(long[] millis) {
        long[] results = new long[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toEpochSeconds(millis[i]);
        }
        return results;
    }

    @ScalarFunction(names={"toEpochMinutes", "to_epoch_minutes"})
    public static long toEpochMinutes(long millis) {
        return TimeUnit.MILLISECONDS.toMinutes(millis);
    }

    @ScalarFunction(names={"toEpochMinutesMV", "to_epoch_minutes_mv"})
    public static long[] toEpochMinutesMV(long[] millis) {
        long[] results = new long[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toEpochMinutes(millis[i]);
        }
        return results;
    }

    @ScalarFunction(names={"toEpochHours", "to_epoch_hours"})
    public static long toEpochHours(long millis) {
        return TimeUnit.MILLISECONDS.toHours(millis);
    }

    @ScalarFunction(names={"toEpochHoursMV", "to_epoch_hours_mv"})
    public static long[] toEpochHoursMV(long[] millis) {
        long[] results = new long[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toEpochHours(millis[i]);
        }
        return results;
    }

    @ScalarFunction(names={"toEpochDays", "to_epoch_days"})
    public static long toEpochDays(long millis) {
        return TimeUnit.MILLISECONDS.toDays(millis);
    }

    @ScalarFunction(names={"toEpochDaysMV", "to_epoch_days_mv"})
    public static long[] toEpochDaysMV(long[] millis) {
        long[] results = new long[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toEpochDays(millis[i]);
        }
        return results;
    }

    @ScalarFunction(names={"toEpochSecondsRounded", "to_epoch_seconds_rounded"})
    public static long toEpochSecondsRounded(long millis, long roundToNearest) {
        return TimeUnit.MILLISECONDS.toSeconds(millis) / roundToNearest * roundToNearest;
    }

    @ScalarFunction(names={"toEpochSecondsRoundedMV", "to_epoch_seconds_rounded_mv"})
    public static long[] toEpochSecondsRoundedMV(long[] millis, long roundToNearest) {
        long[] results = new long[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toEpochSecondsRounded(millis[i], roundToNearest);
        }
        return results;
    }

    @ScalarFunction(names={"toEpochMinutesRounded", "to_epoch_minutes_rounded"})
    public static long toEpochMinutesRounded(long millis, long roundToNearest) {
        return TimeUnit.MILLISECONDS.toMinutes(millis) / roundToNearest * roundToNearest;
    }

    @ScalarFunction(names={"toEpochMinutesRoundedMV", "to_epoch_minutes_rounded_mv"})
    public static long[] toEpochMinutesRoundedMV(long[] millis, long roundToNearest) {
        long[] results = new long[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toEpochMinutesRounded(millis[i], roundToNearest);
        }
        return results;
    }

    @ScalarFunction(names={"toEpochHoursRounded", "to_epoch_hours_rounded"})
    public static long toEpochHoursRounded(long millis, long roundToNearest) {
        return TimeUnit.MILLISECONDS.toHours(millis) / roundToNearest * roundToNearest;
    }

    @ScalarFunction(names={"toEpochHoursRoundedMV", "to_epoch_hours_rounded_mv"})
    public static long[] toEpochHoursRoundedMV(long[] millis, long roundToNearest) {
        long[] results = new long[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toEpochHoursRounded(millis[i], roundToNearest);
        }
        return results;
    }

    @ScalarFunction(names={"toEpochDaysRounded", "to_epoch_days_rounded"})
    public static long toEpochDaysRounded(long millis, long roundToNearest) {
        return TimeUnit.MILLISECONDS.toDays(millis) / roundToNearest * roundToNearest;
    }

    @ScalarFunction(names={"toEpochDaysRoundedMV", "to_epoch_days_rounded_mv"})
    public static long[] toEpochDaysRoundedMV(long[] millis, long roundToNearest) {
        long[] results = new long[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toEpochDaysRounded(millis[i], roundToNearest);
        }
        return results;
    }

    @ScalarFunction(names={"toEpochSecondsBucket", "to_epoch_seconds_bucket"})
    public static long toEpochSecondsBucket(long millis, long bucket) {
        return TimeUnit.MILLISECONDS.toSeconds(millis) / bucket;
    }

    @ScalarFunction(names={"toEpochSecondsBucketMV", "to_epoch_seconds_bucket_mv"})
    public static long[] toEpochSecondsBucketMV(long[] millis, long bucket) {
        long[] results = new long[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toEpochSecondsBucket(millis[i], bucket);
        }
        return results;
    }

    @ScalarFunction(names={"toEpochMinutesBucket", "to_epoch_minutes_bucket"})
    public static long toEpochMinutesBucket(long millis, long bucket) {
        return TimeUnit.MILLISECONDS.toMinutes(millis) / bucket;
    }

    @ScalarFunction(names={"toEpochMinutesBucketMV", "to_epoch_minutes_bucket_mv"})
    public static long[] toEpochMinutesBucketMV(long[] millis, long bucket) {
        long[] results = new long[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toEpochMinutesBucket(millis[i], bucket);
        }
        return results;
    }

    @ScalarFunction(names={"toEpochHoursBucket", "to_epoch_hours_bucket"})
    public static long toEpochHoursBucket(long millis, long bucket) {
        return TimeUnit.MILLISECONDS.toHours(millis) / bucket;
    }

    @ScalarFunction(names={"toEpochHoursBucketMV", "to_epoch_hours_bucket_mv"})
    public static long[] toEpochHoursBucketMV(long[] millis, long bucket) {
        long[] results = new long[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toEpochHoursBucket(millis[i], bucket);
        }
        return results;
    }

    @ScalarFunction(names={"toEpochDaysBucket", "to_epoch_days_bucket"})
    public static long toEpochDaysBucket(long millis, long bucket) {
        return TimeUnit.MILLISECONDS.toDays(millis) / bucket;
    }

    @ScalarFunction(names={"toEpochDaysBucketMV", "to_epoch_days_bucket_mv"})
    public static long[] toEpochDaysBucketMV(long[] millis, long bucket) {
        long[] results = new long[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toEpochDaysBucket(millis[i], bucket);
        }
        return results;
    }

    @ScalarFunction(names={"fromEpochSeconds", "from_epoch_seconds"})
    public static long fromEpochSeconds(long seconds) {
        return TimeUnit.SECONDS.toMillis(seconds);
    }

    @ScalarFunction(names={"fromEpochSecondsMV", "from_epoch_seconds_mv"})
    public static long[] fromEpochSecondsMV(long[] seconds) {
        long[] results = new long[seconds.length];
        for (int i = 0; i < seconds.length; ++i) {
            results[i] = DateTimeFunctions.fromEpochSeconds(seconds[i]);
        }
        return results;
    }

    @ScalarFunction(names={"fromEpochMinutes", "from_epoch_minutes"})
    public static long fromEpochMinutes(long minutes) {
        return TimeUnit.MINUTES.toMillis(minutes);
    }

    @ScalarFunction(names={"fromEpochMinutesMV", "from_epoch_minutes_mv"})
    public static long[] fromEpochMinutesMV(long[] minutes) {
        long[] results = new long[minutes.length];
        for (int i = 0; i < minutes.length; ++i) {
            results[i] = DateTimeFunctions.fromEpochMinutes(minutes[i]);
        }
        return results;
    }

    @ScalarFunction(names={"fromEpochHours", "from_epoch_hours"})
    public static long fromEpochHours(long hours) {
        return TimeUnit.HOURS.toMillis(hours);
    }

    @ScalarFunction(names={"fromEpochHoursMV", "from_epoch_hours_mv"})
    public static long[] fromEpochHoursMV(long[] hours) {
        long[] results = new long[hours.length];
        for (int i = 0; i < hours.length; ++i) {
            results[i] = DateTimeFunctions.fromEpochHours(hours[i]);
        }
        return results;
    }

    @ScalarFunction(names={"fromEpochDays", "from_epoch_days"})
    public static long fromEpochDays(long days) {
        return TimeUnit.DAYS.toMillis(days);
    }

    @ScalarFunction(names={"fromEpochDaysMV", "from_epoch_days_mv"})
    public static long[] fromEpochDaysMV(long[] days) {
        long[] results = new long[days.length];
        for (int i = 0; i < days.length; ++i) {
            results[i] = DateTimeFunctions.fromEpochDays(days[i]);
        }
        return results;
    }

    @ScalarFunction(names={"fromEpochSecondsBucket", "from_epoch_seconds_bucket"})
    public static long fromEpochSecondsBucket(long seconds, long bucket) {
        return TimeUnit.SECONDS.toMillis(seconds * bucket);
    }

    @ScalarFunction(names={"fromEpochSecondsBucketMV", "from_epoch_seconds_bucket_mv"})
    public static long[] fromEpochSecondsBucketMV(long[] seconds, long bucket) {
        long[] results = new long[seconds.length];
        for (int i = 0; i < seconds.length; ++i) {
            results[i] = DateTimeFunctions.fromEpochSecondsBucket(seconds[i], bucket);
        }
        return results;
    }

    @ScalarFunction(names={"fromEpochMinutesBucket", "from_epoch_minutes_bucket"})
    public static long fromEpochMinutesBucket(long minutes, long bucket) {
        return TimeUnit.MINUTES.toMillis(minutes * bucket);
    }

    @ScalarFunction(names={"fromEpochMinutesBucketMV", "from_epoch_minutes_bucket_mv"})
    public static long[] fromEpochMinutesBucketMV(long[] minutes, long bucket) {
        long[] results = new long[minutes.length];
        for (int i = 0; i < minutes.length; ++i) {
            results[i] = DateTimeFunctions.fromEpochMinutesBucket(minutes[i], bucket);
        }
        return results;
    }

    @ScalarFunction(names={"fromEpochHoursBucket", "from_epoch_hours_bucket"})
    public static long fromEpochHoursBucket(long hours, long bucket) {
        return TimeUnit.HOURS.toMillis(hours * bucket);
    }

    @ScalarFunction(names={"fromEpochHoursBucketMV", "from_epoch_hours_bucket_mv"})
    public static long[] fromEpochHoursBucketMV(long[] hours, long bucket) {
        long[] results = new long[hours.length];
        for (int i = 0; i < hours.length; ++i) {
            results[i] = DateTimeFunctions.fromEpochHoursBucket(hours[i], bucket);
        }
        return results;
    }

    @ScalarFunction(names={"fromEpochDaysBucket", "from_epoch_days_bucket"})
    public static long fromEpochDaysBucket(long days, long bucket) {
        return TimeUnit.DAYS.toMillis(days * bucket);
    }

    @ScalarFunction(names={"fromEpochDaysBucketMV", "from_epoch_days_bucket_mv"})
    public static long[] fromEpochDaysBucketMV(long[] days, long bucket) {
        long[] results = new long[days.length];
        for (int i = 0; i < days.length; ++i) {
            results[i] = DateTimeFunctions.fromEpochDaysBucket(days[i], bucket);
        }
        return results;
    }

    @ScalarFunction(names={"toTimestamp", "to_timestamp"})
    public static Timestamp toTimestamp(long millis) {
        return new Timestamp(millis);
    }

    @ScalarFunction(names={"toTimestampMV", "to_timestamp_mv"})
    public static Timestamp[] toTimestampMV(long[] millis) {
        Timestamp[] results = new Timestamp[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toTimestamp(millis[i]);
        }
        return results;
    }

    @ScalarFunction(names={"fromTimestamp", "from_timestamp"})
    public static long fromTimestamp(Timestamp timestamp) {
        return timestamp.getTime();
    }

    @ScalarFunction(names={"fromTimestampMV", "from_timestamp_mv"})
    public static long[] fromTimestampMV(Timestamp[] timestamp) {
        long[] results = new long[timestamp.length];
        for (int i = 0; i < timestamp.length; ++i) {
            results[i] = DateTimeFunctions.fromTimestamp(timestamp[i]);
        }
        return results;
    }

    @ScalarFunction(names={"toDateTime", "to_date_time"})
    public static String toDateTime(long millis, String pattern) {
        return DateTimePatternHandler.parseEpochMillisToDateTimeString(millis, pattern);
    }

    @ScalarFunction(names={"toDateTimeMV", "to_date_time_mv"})
    public static String[] toDateTimeMV(long[] millis, String pattern) {
        String[] results = new String[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toDateTime(millis[i], pattern);
        }
        return results;
    }

    @ScalarFunction(names={"toDateTime", "to_date_time"})
    public static String toDateTime(long millis, String pattern, String timezoneId) {
        return DateTimePatternHandler.parseEpochMillisToDateTimeString(millis, pattern, timezoneId);
    }

    @ScalarFunction(names={"toDateTimeMV", "to_date_time_mv"})
    public static String[] toDateTimeMV(long[] millis, String pattern, String timezoneId) {
        String[] results = new String[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toDateTime(millis[i], pattern, timezoneId);
        }
        return results;
    }

    @ScalarFunction(names={"fromDateTime", "from_date_time"})
    public static long fromDateTime(String dateTimeString, String pattern) {
        return DateTimePatternHandler.parseDateTimeStringToEpochMillis(dateTimeString, pattern);
    }

    @ScalarFunction(names={"fromDateTimeMV", "from_date_time_mv"})
    public static long[] fromDateTimeMV(String[] dateTimeString, String pattern) {
        long[] results = new long[dateTimeString.length];
        for (int i = 0; i < dateTimeString.length; ++i) {
            results[i] = DateTimeFunctions.fromDateTime(dateTimeString[i], pattern);
        }
        return results;
    }

    @ScalarFunction(names={"fromDateTime", "from_date_time"})
    public static long fromDateTime(String dateTimeString, String pattern, String timeZoneId) {
        return DateTimePatternHandler.parseDateTimeStringToEpochMillis(dateTimeString, pattern, timeZoneId);
    }

    @ScalarFunction(names={"fromDateTime", "from_date_time"})
    public static long fromDateTime(String dateTimeString, String pattern, String timeZoneId, long defaultVal) {
        return DateTimePatternHandler.parseDateTimeStringToEpochMillis(dateTimeString, pattern, timeZoneId, defaultVal);
    }

    @ScalarFunction(names={"fromDateTimeMV", "from_date_time_mv"})
    public static long[] fromDateTimeMV(String[] dateTimeString, String pattern, String timeZoneId) {
        long[] results = new long[dateTimeString.length];
        for (int i = 0; i < dateTimeString.length; ++i) {
            results[i] = DateTimeFunctions.fromDateTime(dateTimeString[i], pattern, timeZoneId);
        }
        return results;
    }

    @ScalarFunction
    public static long round(long timeValue, long roundToNearest) {
        return timeValue / roundToNearest * roundToNearest;
    }

    @ScalarFunction(names={"roundMV", "round_mv"})
    public static long[] roundMV(long[] timeValue, long roundToNearest) {
        long[] results = new long[timeValue.length];
        for (int i = 0; i < timeValue.length; ++i) {
            results[i] = DateTimeFunctions.round(timeValue[i], roundToNearest);
        }
        return results;
    }

    @ScalarFunction
    public static long now() {
        return System.currentTimeMillis();
    }

    @ScalarFunction
    public static long ago(String periodString) {
        Duration period = Duration.parse(periodString);
        return System.currentTimeMillis() - period.toMillis();
    }

    @ScalarFunction(names={"agoMV", "ago_mv"})
    public static long[] agoMV(String[] periodString) {
        long[] results = new long[periodString.length];
        for (int i = 0; i < periodString.length; ++i) {
            results[i] = DateTimeFunctions.ago(periodString[i]);
        }
        return results;
    }

    @ScalarFunction(names={"timezoneHour", "timezone_hour"})
    public static int timezoneHour(String timezoneId) {
        return DateTimeFunctions.timezoneHour(timezoneId, 0L);
    }

    @ScalarFunction(names={"timezoneHourMV", "timezone_hour_mv"})
    public static int[] timezoneHourMV(String[] timezoneId) {
        int[] results = new int[timezoneId.length];
        for (int i = 0; i < timezoneId.length; ++i) {
            results[i] = DateTimeFunctions.timezoneHour(timezoneId[i], 0L);
        }
        return results;
    }

    @ScalarFunction(names={"timezoneHour", "timezone_hour"})
    public static int timezoneHour(String timezoneId, long millis) {
        return (int)TimeUnit.MILLISECONDS.toHours(DateTimeZone.forID((String)timezoneId).getOffset(millis));
    }

    @ScalarFunction(names={"timezoneHourMV", "timezone_hour_mv"})
    public static int[] timezoneHourMV(String timezoneId, long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.timezoneHour(timezoneId, millis[i]);
        }
        return results;
    }

    @ScalarFunction(names={"timezoneMinute", "timezone_minute"})
    public static int timezoneMinute(String timezoneId) {
        return DateTimeFunctions.timezoneMinute(timezoneId, 0L);
    }

    @ScalarFunction(names={"timezoneMinuteMV", "timezone_minute_mv"})
    public static int[] timezoneMinuteMV(String[] timezoneId) {
        int[] results = new int[timezoneId.length];
        for (int i = 0; i < timezoneId.length; ++i) {
            results[i] = DateTimeFunctions.timezoneMinute(timezoneId[i], 0L);
        }
        return results;
    }

    @ScalarFunction(names={"timezoneMinute", "timezone_minute"})
    public static int timezoneMinute(String timezoneId, long millis) {
        return (int)TimeUnit.MILLISECONDS.toMinutes(DateTimeZone.forID((String)timezoneId).getOffset(millis)) % 60;
    }

    @ScalarFunction(names={"timezoneMinuteMV", "timezone_minute_mv"})
    public static int[] timezoneMinuteMV(String timezoneId, long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.timezoneMinute(timezoneId, millis[i]);
        }
        return results;
    }

    @ScalarFunction
    public static int year(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getYear();
    }

    @ScalarFunction(names={"yearMV", "year_mv"})
    public static int[] yearMV(long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.year(millis[i]);
        }
        return results;
    }

    @ScalarFunction
    public static int year(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getYear();
    }

    @ScalarFunction(names={"yearMV", "year_mv"})
    public static int[] yearMV(long[] millis, String timezoneId) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.year(millis[i], timezoneId);
        }
        return results;
    }

    @ScalarFunction(names={"yearOfWeek", "year_of_week", "yow"})
    public static int yearOfWeek(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getWeekyear();
    }

    @ScalarFunction(names={"yearOfWeekMV", "year_of_week_mv", "yowmv"})
    public static int[] yearOfWeekMV(long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.yearOfWeek(millis[i]);
        }
        return results;
    }

    @ScalarFunction(names={"yearOfWeek", "year_of_week", "yow"})
    public static int yearOfWeek(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getWeekyear();
    }

    @ScalarFunction(names={"yearOfWeekMV", "year_of_week_mv", "yowmv"})
    public static int[] yearOfWeekMV(long[] millis, String timezoneId) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.yearOfWeek(millis[i], timezoneId);
        }
        return results;
    }

    @ScalarFunction
    public static int quarter(long millis) {
        return (DateTimeFunctions.monthOfYear(millis) - 1) / 3 + 1;
    }

    @ScalarFunction(names={"quarterMV", "quarter_mv"})
    public static int[] quarterMV(long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.quarter(millis[i]);
        }
        return results;
    }

    @ScalarFunction
    public static int quarter(long millis, String timezoneId) {
        return (DateTimeFunctions.monthOfYear(millis, timezoneId) - 1) / 3 + 1;
    }

    @ScalarFunction(names={"quarterMV", "quarter_mv"})
    public static int[] quarterMV(long[] millis, String timezoneId) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.quarter(millis[i], timezoneId);
        }
        return results;
    }

    @ScalarFunction(names={"month", "month_of_year", "monthOfYear"})
    public static int monthOfYear(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getMonthOfYear();
    }

    @ScalarFunction(names={"monthMV", "month_of_year_mv", "monthOfYearMV"})
    public static int[] monthOfYearMV(long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.monthOfYear(millis[i]);
        }
        return results;
    }

    @ScalarFunction(names={"month", "month_of_year", "monthOfYear"})
    public static int monthOfYear(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getMonthOfYear();
    }

    @ScalarFunction(names={"monthMV", "month_of_year_mv", "monthOfYearMV"})
    public static int[] monthOfYearMV(long[] millis, String timezoneId) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.monthOfYear(millis[i], timezoneId);
        }
        return results;
    }

    @ScalarFunction(names={"weekOfYear", "week_of_year", "week"})
    public static int weekOfYear(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getWeekOfWeekyear();
    }

    @ScalarFunction(names={"weekOfYearMV", "week_of_year_mv", "weekMV"})
    public static int[] weekOfYearMV(long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.weekOfYear(millis[i]);
        }
        return results;
    }

    @ScalarFunction(names={"weekOfYear", "week_of_year", "week"})
    public static int weekOfYear(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getWeekOfWeekyear();
    }

    @ScalarFunction(names={"weekOfYearMV", "week_of_year_mv", "weekMV"})
    public static int[] weekOfYearMV(long[] millis, String timezoneId) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.weekOfYear(millis[i], timezoneId);
        }
        return results;
    }

    @ScalarFunction(names={"dayOfYear", "day_of_year", "doy"})
    public static int dayOfYear(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getDayOfYear();
    }

    @ScalarFunction(names={"dayOfYearMV", "day_of_year_mv", "doyMV"})
    public static int[] dayOfYear(long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.dayOfYear(millis[i]);
        }
        return results;
    }

    @ScalarFunction(names={"dayOfYear", "day_of_year", "doy"})
    public static int dayOfYear(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getDayOfYear();
    }

    @ScalarFunction(names={"dayOfYearMV", "day_of_year_mv", "doyMV"})
    public static int[] dayOfYear(long[] millis, String timezoneId) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.dayOfYear(millis[i], timezoneId);
        }
        return results;
    }

    @ScalarFunction(names={"day", "dayOfMonth", "day_of_month"})
    public static int dayOfMonth(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getDayOfMonth();
    }

    @ScalarFunction(names={"dayMV", "dayOfMonthMV", "day_of_month_mv"})
    public static int[] dayOfMonthMV(long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.dayOfMonth(millis[i]);
        }
        return results;
    }

    @ScalarFunction(names={"day", "dayOfMonth", "day_of_month"})
    public static int dayOfMonth(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getDayOfMonth();
    }

    @ScalarFunction(names={"dayMV", "dayOfMonthMV", "day_of_month_mv"})
    public static int[] dayOfMonthMV(long[] millis, String timezoneId) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.dayOfMonth(millis[i], timezoneId);
        }
        return results;
    }

    @ScalarFunction(names={"dayOfWeek", "day_of_week", "dow"})
    public static int dayOfWeek(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getDayOfWeek();
    }

    @ScalarFunction(names={"dayOfWeekMV", "day_of_week_mv", "dowMV"})
    public static int[] dayOfWeekMV(long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.dayOfWeek(millis[i]);
        }
        return results;
    }

    @ScalarFunction(names={"dayOfWeek", "day_of_week", "dow"})
    public static int dayOfWeek(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getDayOfWeek();
    }

    @ScalarFunction(names={"dayOfWeekMV", "day_of_week_mv", "dowMV"})
    public static int[] dayOfWeekMV(long[] millis, String timezoneId) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.dayOfWeek(millis[i], timezoneId);
        }
        return results;
    }

    @ScalarFunction
    public static int hour(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getHourOfDay();
    }

    @ScalarFunction(names={"hourMV", "hour_mv"})
    public static int[] hourMV(long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.hour(millis[i]);
        }
        return results;
    }

    @ScalarFunction
    public static int hour(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getHourOfDay();
    }

    @ScalarFunction(names={"hourMV", "hour_mv"})
    public static int[] hourMV(long[] millis, String timezoneId) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.hour(millis[i], timezoneId);
        }
        return results;
    }

    @ScalarFunction
    public static int minute(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getMinuteOfHour();
    }

    @ScalarFunction(names={"minuteMV", "minute_mv"})
    public static int[] minuteMV(long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.minute(millis[i]);
        }
        return results;
    }

    @ScalarFunction
    public static int minute(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getMinuteOfHour();
    }

    @ScalarFunction(names={"minuteMV", "minute_mv"})
    public static int[] minuteMV(long[] millis, String timezoneId) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.minute(millis[i], timezoneId);
        }
        return results;
    }

    @ScalarFunction
    public static int second(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getSecondOfMinute();
    }

    @ScalarFunction(names={"secondMV", "second_mv"})
    public static int[] secondMV(long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.second(millis[i]);
        }
        return results;
    }

    @ScalarFunction
    public static int second(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getSecondOfMinute();
    }

    @ScalarFunction(names={"secondMV", "second_mv"})
    public static int[] secondMV(long[] millis, String timezoneId) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.second(millis[i], timezoneId);
        }
        return results;
    }

    @ScalarFunction
    public static int millisecond(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getMillisOfSecond();
    }

    @ScalarFunction(names={"millisecondMV", "millisecond_mv"})
    public static int[] millisecondMV(long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.millisecond(millis[i]);
        }
        return results;
    }

    @ScalarFunction
    public static int millisecond(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getMillisOfSecond();
    }

    @ScalarFunction(names={"millisecondMV", "millisecond_mv"})
    public static int[] millisecondMV(long[] millis, String timezoneId) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.millisecond(millis[i], timezoneId);
        }
        return results;
    }

    @ScalarFunction(names={"dateTrunc", "date_trunc"})
    public static long dateTrunc(String unit, long timeValue) {
        return DateTimeFunctions.dateTrunc(unit, timeValue, TimeUnit.MILLISECONDS.name(), ISOChronology.getInstanceUTC(), TimeUnit.MILLISECONDS.name());
    }

    @ScalarFunction(names={"dateTruncMV", "date_trunc_mv"})
    public static long[] dateTruncMV(String unit, long[] timeValue) {
        long[] results = new long[timeValue.length];
        for (int i = 0; i < timeValue.length; ++i) {
            results[i] = DateTimeFunctions.dateTrunc(unit, timeValue[i]);
        }
        return results;
    }

    @ScalarFunction(names={"dateTrunc", "date_trunc"})
    public static long dateTrunc(String unit, long timeValue, String inputTimeUnit) {
        return DateTimeFunctions.dateTrunc(unit, timeValue, inputTimeUnit, ISOChronology.getInstanceUTC(), inputTimeUnit);
    }

    @ScalarFunction(names={"dateTruncMV", "date_trunc_mv"})
    public static long[] dateTruncMV(String unit, long[] timeValue, String inputTimeUnit) {
        long[] results = new long[timeValue.length];
        for (int i = 0; i < timeValue.length; ++i) {
            results[i] = DateTimeFunctions.dateTrunc(unit, timeValue[i], inputTimeUnit);
        }
        return results;
    }

    @ScalarFunction(names={"dateTrunc", "date_trunc"})
    public static long dateTrunc(String unit, long timeValue, String inputTimeUnit, String timeZone) {
        return DateTimeFunctions.dateTrunc(unit, timeValue, inputTimeUnit, DateTimeUtils.getChronology(TimeZoneKey.getTimeZoneKey(timeZone)), inputTimeUnit);
    }

    @ScalarFunction(names={"dateTruncMV", "date_trunc_mv"})
    public static long[] dateTruncMV(String unit, long[] timeValue, String inputTimeUnit, String timeZone) {
        long[] results = new long[timeValue.length];
        for (int i = 0; i < timeValue.length; ++i) {
            results[i] = DateTimeFunctions.dateTrunc(unit, timeValue[i], inputTimeUnit, timeZone);
        }
        return results;
    }

    @ScalarFunction(names={"dateTrunc", "date_trunc"})
    public static long dateTrunc(String unit, long timeValue, String inputTimeUnit, String timeZone, String outputTimeUnit) {
        return DateTimeFunctions.dateTrunc(unit, timeValue, inputTimeUnit, DateTimeUtils.getChronology(TimeZoneKey.getTimeZoneKey(timeZone)), outputTimeUnit);
    }

    @ScalarFunction(names={"dateTruncMV", "date_trunc_mv"})
    public static long[] dateTruncMV(String unit, long[] timeValue, String inputTimeUnit, String timeZone, String outputTimeUnit) {
        long[] results = new long[timeValue.length];
        for (int i = 0; i < timeValue.length; ++i) {
            results[i] = DateTimeFunctions.dateTrunc(unit, timeValue[i], inputTimeUnit, timeZone, outputTimeUnit);
        }
        return results;
    }

    private static long dateTrunc(String unit, long timeValue, String inputTimeUnit, ISOChronology chronology, String outputTimeUnit) {
        return TimeUnit.valueOf(outputTimeUnit.toUpperCase()).convert(DateTimeUtils.getTimestampField(chronology, unit).roundFloor(TimeUnit.MILLISECONDS.convert(timeValue, TimeUnit.valueOf(inputTimeUnit.toUpperCase()))), TimeUnit.MILLISECONDS);
    }

    @ScalarFunction(names={"timestampAdd", "timestamp_add", "dateAdd", "date_add"})
    public static long timestampAdd(String unit, long interval, long timestamp) {
        ISOChronology chronology = ISOChronology.getInstanceUTC();
        long millis = DateTimeUtils.getTimestampField(chronology, unit).add(timestamp, interval);
        return millis;
    }

    @ScalarFunction(names={"timestampAddMV", "timestamp_add_mv", "dateAddMV", "date_add_mv"})
    public static long[] timestampAddMV(String unit, long interval, long[] timestamp) {
        long[] results = new long[timestamp.length];
        for (int i = 0; i < timestamp.length; ++i) {
            results[i] = DateTimeFunctions.timestampAdd(unit, interval, timestamp[i]);
        }
        return results;
    }

    @ScalarFunction(names={"timestampDiff", "timestamp_diff", "dateDiff", "date_diff"})
    public static long timestampDiff(String unit, long timestamp1, long timestamp2) {
        ISOChronology chronology = ISOChronology.getInstanceUTC();
        return DateTimeUtils.getTimestampField(chronology, unit).getDifferenceAsLong(timestamp2, timestamp1);
    }

    @ScalarFunction(names={"timestampDiffMV", "timestamp_diff_mv", "dateDiffMV", "date_diff_mv"})
    public static long[] timestampDiffMV(String unit, long[] timestamp1, long timestamp2) {
        long[] results = new long[timestamp1.length];
        for (int i = 0; i < timestamp1.length; ++i) {
            results[i] = DateTimeFunctions.timestampDiff(unit, timestamp1[i], timestamp2);
        }
        return results;
    }

    @ScalarFunction(names={"timestampDiffMVReverse", "timestamp_diff_mv_reverse", "dateDiffMVReverse", "date_diff_mv_reverse"})
    public static long[] timestampDiffMVReverse(String unit, long timestamp1, long[] timestamp2) {
        long[] results = new long[timestamp2.length];
        for (int i = 0; i < timestamp2.length; ++i) {
            results[i] = DateTimeFunctions.timestampDiff(unit, timestamp1, timestamp2[i]);
        }
        return results;
    }
}

