/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar;

import org.apache.pinot.spi.annotations.ScalarFunction;

public class ComparisonFunctions {
    private static final double DOUBLE_COMPARISON_TOLERANCE = 1.0E-7;

    private ComparisonFunctions() {
    }

    @ScalarFunction(names={"greater_than", "greaterThan"})
    public static boolean greaterThan(double a, double b) {
        return a > b;
    }

    @ScalarFunction(names={"greater_than_or_equal", "greaterThanOrEqual"})
    public static boolean greaterThanOrEqual(double a, double b) {
        return a >= b;
    }

    @ScalarFunction(names={"less_than", "lessThan"})
    public static boolean lessThan(double a, double b) {
        return a < b;
    }

    @ScalarFunction(names={"less_than_or_equal", "lessThanOrEqual"})
    public static boolean lessThanOrEqual(double a, double b) {
        return a <= b;
    }

    @ScalarFunction(names={"not_equals", "notEquals"})
    public static boolean notEquals(double a, double b) {
        return Math.abs(a - b) >= 1.0E-7;
    }

    @ScalarFunction
    public static boolean equals(double a, double b) {
        return Math.abs(a - b) < 1.0E-7;
    }

    @ScalarFunction
    public static boolean between(double val, double a, double b) {
        return val >= a && val <= b;
    }
}

