/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.datablock;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.pinot.common.datablock.BaseDataBlock;
import org.apache.pinot.common.datablock.DataBlock;
import org.apache.pinot.common.datablock.DataBlockUtils;
import org.apache.pinot.common.utils.DataSchema;

public class RowDataBlock
extends BaseDataBlock {
    private static final int VERSION = 1;
    protected int[] _columnOffsets;
    protected int _rowSizeInBytes;

    public RowDataBlock() {
    }

    public RowDataBlock(int numRows, DataSchema dataSchema, String[] stringDictionary, byte[] fixedSizeDataBytes, byte[] variableSizeDataBytes) {
        super(numRows, dataSchema, stringDictionary, fixedSizeDataBytes, variableSizeDataBytes);
        this.computeBlockObjectConstants();
    }

    public RowDataBlock(ByteBuffer byteBuffer) throws IOException {
        super(byteBuffer);
        this.computeBlockObjectConstants();
    }

    protected void computeBlockObjectConstants() {
        if (this._dataSchema != null) {
            this._columnOffsets = new int[this._numColumns];
            this._rowSizeInBytes = DataBlockUtils.computeColumnOffsets(this._dataSchema, this._columnOffsets);
            this._fixDataSize = this._numRows * this._rowSizeInBytes;
        }
    }

    @Override
    protected int getDataBlockVersionType() {
        return 1 + (DataBlock.Type.ROW.ordinal() << 5);
    }

    @Override
    protected int getOffsetInFixedBuffer(int rowId, int colId) {
        return rowId * this._rowSizeInBytes + this._columnOffsets[colId];
    }

    @Override
    protected int positionOffsetInVariableBufferAndGetLength(int rowId, int colId) {
        int offset = this.getOffsetInFixedBuffer(rowId, colId);
        this._variableSizeData.position(this._fixedSizeData.getInt(offset));
        return this._fixedSizeData.getInt(offset + 4);
    }

    @Override
    public RowDataBlock toMetadataOnlyDataTable() {
        RowDataBlock metadataOnlyDataTable = new RowDataBlock();
        metadataOnlyDataTable._metadata.putAll(this._metadata);
        metadataOnlyDataTable._errCodeToExceptionMap.putAll(this._errCodeToExceptionMap);
        return metadataOnlyDataTable;
    }

    @Override
    public RowDataBlock toDataOnlyDataTable() {
        return new RowDataBlock(this._numRows, this._dataSchema, this._stringDictionary, this._fixedSizeDataBytes, this._variableSizeDataBytes);
    }

    public int getRowSizeInBytes() {
        return this._rowSizeInBytes;
    }
}

