/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.datablock;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.common.datablock.BaseDataBlock;
import org.apache.pinot.common.datablock.DataBlock;

public class MetadataBlock
extends BaseDataBlock {
    private static final ObjectMapper JSON = new ObjectMapper();
    @VisibleForTesting
    static final int VERSION = 1;
    private final Contents _contents;

    public MetadataBlock(MetadataBlockType type) {
        this(type, new HashMap<String, String>());
    }

    public MetadataBlock(MetadataBlockType type, Map<String, String> stats) {
        super(0, null, new String[0], new byte[]{0}, MetadataBlock.toContents(new Contents(type.name(), stats)));
        this._contents = new Contents(type.name(), stats);
    }

    private static byte[] toContents(Contents type) {
        try {
            return JSON.writeValueAsBytes((Object)type);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public MetadataBlock(ByteBuffer byteBuffer) throws IOException {
        super(byteBuffer);
        this._contents = this._variableSizeDataBytes != null && this._variableSizeDataBytes.length > 0 ? (Contents)JSON.readValue(this._variableSizeDataBytes, Contents.class) : new Contents();
    }

    public MetadataBlockType getType() {
        String type = this._contents.getType();
        return type == null ? (this.getExceptions().isEmpty() ? MetadataBlockType.EOS : MetadataBlockType.ERROR) : MetadataBlockType.valueOf(type);
    }

    public Map<String, String> getStats() {
        return this._contents.getStats() != null ? this._contents.getStats() : new HashMap();
    }

    @Override
    public int getDataBlockVersionType() {
        return 1 + (DataBlock.Type.METADATA.ordinal() << 5);
    }

    @Override
    protected int getOffsetInFixedBuffer(int rowId, int colId) {
        throw new UnsupportedOperationException("Metadata block uses JSON encoding for field access");
    }

    @Override
    protected int positionOffsetInVariableBufferAndGetLength(int rowId, int colId) {
        throw new UnsupportedOperationException("Metadata block uses JSON encoding for field access");
    }

    @Override
    public MetadataBlock toMetadataOnlyDataTable() {
        return this;
    }

    @Override
    public MetadataBlock toDataOnlyDataTable() {
        throw new UnsupportedOperationException();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @VisibleForTesting
    static class Contents {
        private String _type;
        private Map<String, String> _stats;

        @JsonCreator
        public Contents(@JsonProperty(value="type") String type, @JsonProperty(value="stats") Map<String, String> stats) {
            this._type = type;
            this._stats = stats;
        }

        @JsonCreator
        public Contents() {
            this(null, new HashMap<String, String>());
        }

        public String getType() {
            return this._type;
        }

        public void setType(String type) {
            this._type = type;
        }

        public Map<String, String> getStats() {
            return this._stats;
        }

        public void setStats(Map<String, String> stats) {
            this._stats = stats;
        }
    }

    public static enum MetadataBlockType {
        EOS,
        ERROR;

    }
}

