/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.datablock;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.apache.pinot.common.datablock.ColumnarDataBlock;
import org.apache.pinot.common.datablock.DataBlock;
import org.apache.pinot.common.datablock.MetadataBlock;
import org.apache.pinot.common.datablock.RowDataBlock;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;

public final class DataBlockUtils {
    static final int VERSION_TYPE_SHIFT = 5;

    private DataBlockUtils() {
    }

    public static MetadataBlock getErrorDataBlock(Exception e) {
        if (e instanceof ProcessingException) {
            return DataBlockUtils.getErrorDataBlock(Collections.singletonMap(((ProcessingException)((Object)e)).getErrorCode(), DataBlockUtils.extractErrorMsg(e)));
        }
        return DataBlockUtils.getErrorDataBlock(Collections.singletonMap(1000, DataBlockUtils.extractErrorMsg(e)));
    }

    private static String extractErrorMsg(Throwable t) {
        while (t.getCause() != null && t.getMessage() == null) {
            t = t.getCause();
        }
        return t.getMessage() + "\n" + QueryException.getTruncatedStackTrace(t);
    }

    public static MetadataBlock getErrorDataBlock(Map<Integer, String> exceptions) {
        MetadataBlock errorBlock = new MetadataBlock(MetadataBlock.MetadataBlockType.ERROR);
        for (Map.Entry<Integer, String> exception : exceptions.entrySet()) {
            errorBlock.addException(exception.getKey(), exception.getValue());
        }
        return errorBlock;
    }

    public static MetadataBlock getEndOfStreamDataBlock() {
        return new MetadataBlock(MetadataBlock.MetadataBlockType.EOS);
    }

    public static MetadataBlock getEndOfStreamDataBlock(Map<String, String> stats) {
        return new MetadataBlock(MetadataBlock.MetadataBlockType.EOS, stats);
    }

    public static DataBlock getDataBlock(ByteBuffer byteBuffer) throws IOException {
        int versionType = byteBuffer.getInt();
        int version = versionType & 0x1F;
        DataBlock.Type type = DataBlock.Type.fromOrdinal(versionType >> 5);
        switch (type) {
            case COLUMNAR: {
                return new ColumnarDataBlock(byteBuffer);
            }
            case ROW: {
                return new RowDataBlock(byteBuffer);
            }
            case METADATA: {
                return new MetadataBlock(byteBuffer);
            }
        }
        throw new UnsupportedOperationException("Unsupported data table version: " + version + " with type: " + type);
    }

    public static int computeColumnOffsets(DataSchema dataSchema, int[] columnOffsets) {
        int numColumns = columnOffsets.length;
        assert (numColumns == dataSchema.size());
        DataSchema.ColumnDataType[] storedColumnDataTypes = dataSchema.getStoredColumnDataTypes();
        int rowSizeInBytes = 0;
        block7: for (int i = 0; i < numColumns; ++i) {
            columnOffsets[i] = rowSizeInBytes;
            switch (storedColumnDataTypes[i]) {
                case INT: {
                    rowSizeInBytes += 4;
                    continue block7;
                }
                case LONG: {
                    rowSizeInBytes += 8;
                    continue block7;
                }
                case FLOAT: {
                    rowSizeInBytes += 4;
                    continue block7;
                }
                case DOUBLE: {
                    rowSizeInBytes += 8;
                    continue block7;
                }
                case STRING: {
                    rowSizeInBytes += 4;
                    continue block7;
                }
                default: {
                    rowSizeInBytes += 8;
                }
            }
        }
        return rowSizeInBytes;
    }

    public static void computeColumnSizeInBytes(DataSchema dataSchema, int[] columnSizes) {
        int numColumns = columnSizes.length;
        assert (numColumns == dataSchema.size());
        DataSchema.ColumnDataType[] storedColumnDataTypes = dataSchema.getStoredColumnDataTypes();
        block7: for (int i = 0; i < numColumns; ++i) {
            switch (storedColumnDataTypes[i]) {
                case INT: {
                    columnSizes[i] = 4;
                    continue block7;
                }
                case LONG: {
                    columnSizes[i] = 8;
                    continue block7;
                }
                case FLOAT: {
                    columnSizes[i] = 4;
                    continue block7;
                }
                case DOUBLE: {
                    columnSizes[i] = 8;
                    continue block7;
                }
                case STRING: {
                    columnSizes[i] = 4;
                    continue block7;
                }
                default: {
                    columnSizes[i] = 8;
                }
            }
        }
    }
}

