/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.auth;

import java.util.Base64;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.utils.BcryptUtils;

public final class BasicAuthUtils {
    private static final String ALL = "*";

    private BasicAuthUtils() {
    }

    @Nullable
    public static String toBasicAuthToken(String name, String password) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        String identifier = String.format("%s:%s", name, password);
        return BasicAuthUtils.normalizeBase64Token(String.format("Basic %s", Base64.getEncoder().encodeToString(identifier.getBytes())));
    }

    public static String decodeBasicAuthToken(String auth) {
        if (StringUtils.isBlank((CharSequence)auth)) {
            return null;
        }
        String replacedAuth = StringUtils.replace((String)auth, (String)"Basic ", (String)"");
        byte[] decodedBytes = Base64.getDecoder().decode(replacedAuth);
        String decodedString = new String(decodedBytes);
        return decodedString;
    }

    public static String extractUsername(String auth) {
        String decodedString = BasicAuthUtils.decodeBasicAuthToken(auth);
        return StringUtils.split((String)decodedString, (String)":")[0];
    }

    public static String extractPassword(String auth) {
        String decodedString = BasicAuthUtils.decodeBasicAuthToken(auth);
        return StringUtils.split((String)decodedString, (String)":")[1];
    }

    public static String toEncryptBasicAuthToken(String auth) {
        if (StringUtils.isBlank((CharSequence)auth)) {
            return null;
        }
        String replacedAuth = StringUtils.replace((String)auth, (String)"Basic ", (String)"");
        byte[] decodedBytes = Base64.getDecoder().decode(replacedAuth);
        String decodedString = new String(decodedBytes);
        String[] cretential = StringUtils.split((String)decodedString, (String)":");
        String rawUsername = cretential[0];
        String rawPassword = cretential[1];
        String encryptedPassword = BcryptUtils.encrypt(rawPassword);
        return BasicAuthUtils.toBasicAuthToken(rawUsername, encryptedPassword);
    }

    @Nullable
    public static String normalizeBase64Token(String token) {
        if (token == null) {
            return null;
        }
        return StringUtils.remove((String)token.trim(), (char)'=');
    }
}

