/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.sql.parsers.rewriter;

import java.util.Arrays;
import java.util.List;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.sql.parsers.SqlCompilationException;
import org.apache.pinot.sql.parsers.rewriter.QueryRewriter;

public class OrdinalsUpdater
implements QueryRewriter {
    @Override
    public PinotQuery rewrite(PinotQuery pinotQuery) {
        int ordinal;
        int i;
        for (i = 0; i < pinotQuery.getGroupByListSize(); ++i) {
            Expression groupByExpr = pinotQuery.getGroupByList().get(i);
            if (!groupByExpr.isSetLiteral() || !groupByExpr.getLiteral().isSetLongValue()) continue;
            ordinal = (int)groupByExpr.getLiteral().getLongValue();
            pinotQuery.getGroupByList().set(i, OrdinalsUpdater.getExpressionFromOrdinal(pinotQuery.getSelectList(), ordinal));
        }
        for (i = 0; i < pinotQuery.getOrderByListSize(); ++i) {
            Expression orderByExpr = pinotQuery.getOrderByList().get(i).getFunctionCall().getOperands().get(0);
            if (!orderByExpr.isSetLiteral() || !orderByExpr.getLiteral().isSetLongValue()) continue;
            ordinal = (int)orderByExpr.getLiteral().getLongValue();
            pinotQuery.getOrderByList().get(i).getFunctionCall().setOperands(Arrays.asList(OrdinalsUpdater.getExpressionFromOrdinal(pinotQuery.getSelectList(), ordinal)));
        }
        return pinotQuery;
    }

    private static Expression getExpressionFromOrdinal(List<Expression> selectList, int ordinal) {
        if (ordinal > 0 && ordinal <= selectList.size()) {
            Expression expression = selectList.get(ordinal - 1);
            if (expression.isSetFunctionCall() && expression.getFunctionCall().getOperator().equals("as")) {
                return expression.getFunctionCall().getOperands().get(0);
            }
            return expression;
        }
        throw new SqlCompilationException(String.format("Expected Ordinal value to be between 1 and %d.", selectList.size()));
    }
}

