/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.serde;

import javax.annotation.concurrent.NotThreadSafe;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class SerDe {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SerDe.class);
    private final TSerializer _serializer;
    private final TDeserializer _deserializer;

    public SerDe(TProtocolFactory factory) {
        try {
            this._serializer = new TSerializer(factory);
            this._deserializer = new TDeserializer(factory);
        }
        catch (TTransportException ttException) {
            LOGGER.error("Unable to initialize Serde instance", (Throwable)ttException);
            throw new RuntimeException("Unable to initialize Serde instance", ttException);
        }
    }

    public byte[] serialize(TBase obj) {
        try {
            return this._serializer.serialize(obj);
        }
        catch (TException e) {
            LOGGER.error("Unable to serialize object :" + obj, (Throwable)e);
            return null;
        }
    }

    public boolean deserialize(TBase obj, byte[] payload) {
        try {
            this._deserializer.deserialize(obj, payload);
        }
        catch (TException e) {
            LOGGER.error("Unable to deserialize to object :" + obj, (Throwable)e);
            return false;
        }
        return true;
    }
}

