/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.grpc;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslProvider;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.apache.pinot.common.config.GrpcConfig;
import org.apache.pinot.common.proto.PinotQueryServerGrpc;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.common.utils.TlsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcQueryClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrpcQueryClient.class);
    private static final int DEFAULT_CHANNEL_SHUTDOWN_TIMEOUT_SECOND = 10;
    private final ManagedChannel _managedChannel;
    private final PinotQueryServerGrpc.PinotQueryServerBlockingStub _blockingStub;

    public GrpcQueryClient(String host, int port) {
        this(host, port, new GrpcConfig(Collections.emptyMap()));
    }

    public GrpcQueryClient(String host, int port, GrpcConfig config) {
        if (config.isUsePlainText()) {
            this._managedChannel = ManagedChannelBuilder.forAddress((String)host, (int)port).maxInboundMessageSize(config.getMaxInboundMessageSizeBytes()).usePlaintext().build();
        } else {
            try {
                SslContextBuilder sslContextBuilder = SslContextBuilder.forClient();
                if (config.getTlsConfig().getKeyStorePath() != null) {
                    KeyManagerFactory keyManagerFactory = TlsUtils.createKeyManagerFactory(config.getTlsConfig());
                    sslContextBuilder.keyManager(keyManagerFactory);
                }
                if (config.getTlsConfig().getTrustStorePath() != null) {
                    TrustManagerFactory trustManagerFactory = TlsUtils.createTrustManagerFactory(config.getTlsConfig());
                    sslContextBuilder.trustManager(trustManagerFactory);
                }
                sslContextBuilder = config.getTlsConfig().getSslProvider() != null ? GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder, (SslProvider)SslProvider.valueOf((String)config.getTlsConfig().getSslProvider())) : GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder);
                this._managedChannel = NettyChannelBuilder.forAddress((String)host, (int)port).maxInboundMessageSize(config.getMaxInboundMessageSizeBytes()).sslContext(sslContextBuilder.build()).build();
            }
            catch (SSLException e) {
                throw new RuntimeException("Failed to create Netty gRPC channel with SSL Context", e);
            }
        }
        this._blockingStub = PinotQueryServerGrpc.newBlockingStub((Channel)this._managedChannel);
    }

    public Iterator<Server.ServerResponse> submit(Server.ServerRequest request) {
        return this._blockingStub.submit(request);
    }

    public void close() {
        if (!this._managedChannel.isShutdown()) {
            try {
                this._managedChannel.shutdownNow();
                if (!this._managedChannel.awaitTermination(10L, TimeUnit.SECONDS)) {
                    LOGGER.warn("Timed out forcefully shutting down connection: {}. ", (Object)this._managedChannel);
                }
            }
            catch (Exception e) {
                LOGGER.error("Unexpected exception while waiting for channel termination", (Throwable)e);
            }
        }
    }
}

