/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private static final AtomicInteger THREAD_POOL_NUMBER = new AtomicInteger(1);
    private static final String NAME_PATTERN = "%s-%d-thread";
    private final ThreadGroup _group;
    private final AtomicInteger _threadNumber = new AtomicInteger(1);
    private final String _threadNamePrefix;

    public NamedThreadFactory(String threadNamePrefix) {
        SecurityManager s = System.getSecurityManager();
        this._group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this._threadNamePrefix = String.format(NAME_PATTERN, NamedThreadFactory.checkPrefix(threadNamePrefix), THREAD_POOL_NUMBER.getAndIncrement());
    }

    private static String checkPrefix(String prefix) {
        return prefix == null || prefix.isEmpty() ? "Pinot" : prefix;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this._group, r, String.format("%s-%d", this._threadNamePrefix, this._threadNumber.getAndIncrement()), 0L);
        t.setDaemon(false);
        t.setPriority(5);
        return t;
    }
}

