/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.request.context;

import java.util.Objects;
import java.util.Set;
import org.apache.pinot.common.request.context.FunctionContext;

public class ExpressionContext {
    private final Type _type;
    private final String _value;
    private final FunctionContext _function;

    public static ExpressionContext forLiteral(String literal) {
        return new ExpressionContext(Type.LITERAL, literal, null);
    }

    public static ExpressionContext forIdentifier(String identifier) {
        return new ExpressionContext(Type.IDENTIFIER, identifier, null);
    }

    public static ExpressionContext forFunction(FunctionContext function) {
        return new ExpressionContext(Type.FUNCTION, null, function);
    }

    private ExpressionContext(Type type, String value, FunctionContext function) {
        this._type = type;
        this._value = value;
        this._function = function;
    }

    public Type getType() {
        return this._type;
    }

    public String getLiteral() {
        return this._value;
    }

    public String getIdentifier() {
        return this._value;
    }

    public FunctionContext getFunction() {
        return this._function;
    }

    public void getColumns(Set<String> columns) {
        if (this._type == Type.IDENTIFIER) {
            if (!this._value.equals("*")) {
                columns.add(this._value);
            }
        } else if (this._type == Type.FUNCTION) {
            this._function.getColumns(columns);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExpressionContext)) {
            return false;
        }
        ExpressionContext that = (ExpressionContext)o;
        return this._type == that._type && Objects.equals(this._value, that._value) && Objects.equals(this._function, that._function);
    }

    public int hashCode() {
        int hash = 961 * this._type.hashCode();
        if (this._type == Type.FUNCTION) {
            return hash + this._function.hashCode();
        }
        return hash + 31 * this._value.hashCode();
    }

    public String toString() {
        switch (this._type) {
            case LITERAL: {
                return "'" + this._value + "'";
            }
            case IDENTIFIER: {
                return this._value;
            }
            case FUNCTION: {
                return this._function.toString();
            }
        }
        throw new IllegalStateException();
    }

    public static enum Type {
        LITERAL,
        IDENTIFIER,
        FUNCTION;

    }
}

