/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar;

import org.apache.pinot.spi.annotations.ScalarFunction;

public class ComparisonFunctions {
    private static final double DOUBLE_COMPARISON_TOLERANCE = 1.0E-7;

    private ComparisonFunctions() {
    }

    @ScalarFunction
    public static boolean greaterThan(double a, double b) {
        return a > b;
    }

    @ScalarFunction
    public static boolean greaterThanOrEqual(double a, double b) {
        return a >= b;
    }

    @ScalarFunction
    public static boolean lessThan(double a, double b) {
        return a < b;
    }

    @ScalarFunction
    public static boolean lessThanOrEqual(double a, double b) {
        return a <= b;
    }

    @ScalarFunction
    public static boolean notEquals(double a, double b) {
        return Math.abs(a - b) >= 1.0E-7;
    }

    @ScalarFunction
    public static boolean equals(double a, double b) {
        return Math.abs(a - b) < 1.0E-7;
    }

    @ScalarFunction
    public static boolean between(double val, double a, double b) {
        return val > a && val < b;
    }
}

