/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.io;

import java.io.Serializable;
import java.net.InetSocketAddress;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.actor.Terminated$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.io.Tcp;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.StreamTcpException;
import org.apache.pekko.stream.SubscriptionWithCancelException;
import org.apache.pekko.stream.impl.ReactiveStreamsCompliance$;
import org.apache.pekko.stream.impl.io.TcpConnectionStage$;
import org.apache.pekko.stream.impl.io.TcpConnectionStage$Inbound$;
import org.apache.pekko.stream.impl.io.TcpConnectionStage$Outbound$;
import org.apache.pekko.stream.impl.io.TcpConnectionStage$WriteAck$;
import org.apache.pekko.stream.impl.io.TcpConnectionStage$WriteDelayAck$;
import org.apache.pekko.stream.scaladsl.TcpAttributes;
import org.apache.pekko.stream.scaladsl.TcpAttributes$TcpWriteBufferSize$;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.GraphStageLogic$EagerTerminateOutput$;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.stream.stage.StageLogging;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.concurrent.Promise;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

@InternalApi
public final class TcpConnectionStage {

    public static class Inbound
    implements TcpRole,
    Product,
    Serializable {
        private final ActorRef connection;
        private final boolean halfClose;
        private final Function0 registerCallback;

        public static Inbound apply(ActorRef actorRef, boolean bl, Function0<BoxedUnit> function0) {
            return TcpConnectionStage$Inbound$.MODULE$.apply(actorRef, bl, function0);
        }

        public static Inbound fromProduct(Product product) {
            return TcpConnectionStage$Inbound$.MODULE$.fromProduct(product);
        }

        public static Inbound unapply(Inbound inbound) {
            return TcpConnectionStage$Inbound$.MODULE$.unapply(inbound);
        }

        public Inbound(ActorRef connection, boolean halfClose, Function0<BoxedUnit> registerCallback) {
            this.connection = connection;
            this.halfClose = halfClose;
            this.registerCallback = registerCallback;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.connection()));
            n = Statics.mix((int)n, (int)(this.halfClose() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.registerCallback()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Inbound)) return false;
            Inbound inbound = (Inbound)object;
            if (this.halfClose() != inbound.halfClose()) return false;
            ActorRef actorRef = this.connection();
            ActorRef actorRef2 = inbound.connection();
            if (actorRef == null) {
                if (actorRef2 != null) {
                    return false;
                }
            } else if (!actorRef.equals(actorRef2)) return false;
            Function0<BoxedUnit> function0 = this.registerCallback();
            Function0<BoxedUnit> function02 = inbound.registerCallback();
            if (function0 == null) {
                if (function02 != null) {
                    return false;
                }
            } else if (!function0.equals(function02)) return false;
            if (!inbound.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Inbound;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Inbound";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this._2());
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "connection";
                }
                case 1: {
                    return "halfClose";
                }
                case 2: {
                    return "registerCallback";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ActorRef connection() {
            return this.connection;
        }

        @Override
        public boolean halfClose() {
            return this.halfClose;
        }

        public Function0<BoxedUnit> registerCallback() {
            return this.registerCallback;
        }

        public Inbound copy(ActorRef connection, boolean halfClose, Function0<BoxedUnit> registerCallback) {
            return new Inbound(connection, halfClose, registerCallback);
        }

        public ActorRef copy$default$1() {
            return this.connection();
        }

        public boolean copy$default$2() {
            return this.halfClose();
        }

        public Function0<BoxedUnit> copy$default$3() {
            return this.registerCallback();
        }

        public ActorRef _1() {
            return this.connection();
        }

        public boolean _2() {
            return this.halfClose();
        }

        public Function0<BoxedUnit> _3() {
            return this.registerCallback();
        }
    }

    public static class Outbound
    implements TcpRole,
    Product,
    Serializable {
        private final ActorRef manager;
        private final Tcp.Connect connectCmd;
        private final Promise localAddressPromise;
        private final boolean halfClose;

        public static Outbound apply(ActorRef actorRef, Tcp.Connect connect, Promise<InetSocketAddress> promise, boolean bl) {
            return TcpConnectionStage$Outbound$.MODULE$.apply(actorRef, connect, promise, bl);
        }

        public static Outbound fromProduct(Product product) {
            return TcpConnectionStage$Outbound$.MODULE$.fromProduct(product);
        }

        public static Outbound unapply(Outbound outbound) {
            return TcpConnectionStage$Outbound$.MODULE$.unapply(outbound);
        }

        public Outbound(ActorRef manager, Tcp.Connect connectCmd, Promise<InetSocketAddress> localAddressPromise, boolean halfClose) {
            this.manager = manager;
            this.connectCmd = connectCmd;
            this.localAddressPromise = localAddressPromise;
            this.halfClose = halfClose;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.manager()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.connectCmd()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.localAddressPromise()));
            n = Statics.mix((int)n, (int)(this.halfClose() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Outbound)) return false;
            Outbound outbound = (Outbound)object;
            if (this.halfClose() != outbound.halfClose()) return false;
            ActorRef actorRef = this.manager();
            ActorRef actorRef2 = outbound.manager();
            if (actorRef == null) {
                if (actorRef2 != null) {
                    return false;
                }
            } else if (!actorRef.equals(actorRef2)) return false;
            Tcp.Connect connect = this.connectCmd();
            Tcp.Connect connect2 = outbound.connectCmd();
            if (connect == null) {
                if (connect2 != null) {
                    return false;
                }
            } else if (!connect.equals(connect2)) return false;
            Promise<InetSocketAddress> promise = this.localAddressPromise();
            Promise<InetSocketAddress> promise2 = outbound.localAddressPromise();
            if (promise == null) {
                if (promise2 != null) {
                    return false;
                }
            } else if (!promise.equals(promise2)) return false;
            if (!outbound.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Outbound;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Outbound";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToBoolean((boolean)this._4());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "manager";
                }
                case 1: {
                    return "connectCmd";
                }
                case 2: {
                    return "localAddressPromise";
                }
                case 3: {
                    return "halfClose";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ActorRef manager() {
            return this.manager;
        }

        public Tcp.Connect connectCmd() {
            return this.connectCmd;
        }

        public Promise<InetSocketAddress> localAddressPromise() {
            return this.localAddressPromise;
        }

        @Override
        public boolean halfClose() {
            return this.halfClose;
        }

        public Outbound copy(ActorRef manager, Tcp.Connect connectCmd, Promise<InetSocketAddress> localAddressPromise, boolean halfClose) {
            return new Outbound(manager, connectCmd, localAddressPromise, halfClose);
        }

        public ActorRef copy$default$1() {
            return this.manager();
        }

        public Tcp.Connect copy$default$2() {
            return this.connectCmd();
        }

        public Promise<InetSocketAddress> copy$default$3() {
            return this.localAddressPromise();
        }

        public boolean copy$default$4() {
            return this.halfClose();
        }

        public ActorRef _1() {
            return this.manager();
        }

        public Tcp.Connect _2() {
            return this.connectCmd();
        }

        public Promise<InetSocketAddress> _3() {
            return this.localAddressPromise();
        }

        public boolean _4() {
            return this.halfClose();
        }
    }

    public static interface TcpRole {
        public boolean halfClose();
    }

    public static class TcpStreamLogic
    extends GraphStageLogic
    implements StageLogging {
        private LoggingAdapter org$apache$pekko$stream$stage$StageLogging$$_log;
        private final FlowShape shape;
        private final TcpRole role;
        public final InetSocketAddress org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$remoteAddress;
        public ActorRef org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$connection;
        public final int org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeBufferSize;
        public ByteString org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeBuffer;
        public boolean org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeInProgress;
        private boolean connectionClosePending;
        public final int org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$coalesceWrites;
        public int org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeDelayCountDown;
        private int previousWriteBufferSize;
        private final OutHandler readHandler;

        public TcpStreamLogic(FlowShape<ByteString, ByteString> shape, TcpRole role, Attributes inheritedAttributes, InetSocketAddress remoteAddress, Materializer eagerMaterializer) {
            this.shape = shape;
            this.role = role;
            this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$remoteAddress = remoteAddress;
            super(shape);
            StageLogging.$init$(this);
            this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeBufferSize = inheritedAttributes.get(TcpAttributes$TcpWriteBufferSize$.MODULE$.apply(eagerMaterializer.settings().ioSettings().tcpWriteBufferSize()), ClassTag$.MODULE$.apply(TcpAttributes.TcpWriteBufferSize.class)).size();
            this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeBuffer = ByteString$.MODULE$.empty();
            this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeInProgress = false;
            this.connectionClosePending = false;
            this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$coalesceWrites = eagerMaterializer.settings().ioSettings().coalesceWrites();
            this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeDelayCountDown = 0;
            this.previousWriteBufferSize = 0;
            this.setHandler(this.bytesOut(), GraphStageLogic$EagerTerminateOutput$.MODULE$);
            this.readHandler = new OutHandler(this){
                private final /* synthetic */ TcpStreamLogic $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void onPull() {
                    this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$connection.$bang((Object)Tcp.ResumeReading$.MODULE$, this.$outer.self());
                }

                public void onDownstreamFinish(Throwable cause) {
                    Throwable throwable = cause;
                    if (throwable instanceof SubscriptionWithCancelException.NonFailureCancellation) {
                        this.$outer.log().debug("Closing connection from {}:{} because downstream cancelled stream without failure", (Object)this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$remoteAddress.getHostString(), (Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$remoteAddress.getPort()));
                        this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$closeConnectionDownstreamFinished();
                        return;
                    }
                    Throwable ex = throwable;
                    this.$outer.log().debug("Aborting connection from {}:{} because of downstream failure: {}", (Object)this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$remoteAddress.getHostString(), (Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$remoteAddress.getPort()), (Object)ex);
                    this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$connection.$bang((Object)Tcp.Abort$.MODULE$, this.$outer.self());
                    this.$outer.failStage(cause);
                }
            };
            this.setHandler(this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$bytesIn(), new InHandler(this){
                private final /* synthetic */ TcpStreamLogic $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void onPush() {
                    ByteString elem = this.$outer.protected$grab(this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$bytesIn());
                    ReactiveStreamsCompliance$.MODULE$.requireNonNullElement(elem);
                    if (this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeInProgress) {
                        this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeBuffer = this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeBuffer.$plus$plus(elem);
                    } else if (this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$coalesceWritesDisabled() || this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeBuffer.length() >= this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeBufferSize) {
                        this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeBuffer = this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeBuffer.$plus$plus(elem);
                        this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$sendWriteBuffer();
                    } else {
                        this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeBuffer = this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeBuffer.$plus$plus(elem);
                        this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeDelayCountDown = this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$coalesceWrites;
                        this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$sendWriteDelay();
                    }
                    if (this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeBuffer.length() < this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeBufferSize) {
                        this.$outer.protected$pull(this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$bytesIn());
                        return;
                    }
                }

                public void onUpstreamFinish() {
                    this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$closeConnectionUpstreamFinished();
                }

                public void onUpstreamFailure(Throwable ex) {
                    if (this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$connection != null) {
                        if (this.$outer.interpreter().log().isDebugEnabled()) {
                            String msg = "Aborting tcp connection to {} because of upstream failure: {}";
                            Object object = Predef$.MODULE$.refArrayOps((Object[])ex.getStackTrace());
                            if (ArrayOps$.MODULE$.isEmpty$extension(object)) {
                                this.$outer.interpreter().log().debug(msg, (Object)this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$remoteAddress, (Object)ex);
                            } else {
                                this.$outer.interpreter().log().debug(new StringBuilder(3).append(msg).append("\n{}").toString(), (Object)this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$remoteAddress, (Object)ex, (Object)Predef$.MODULE$.wrapRefArray((Object[])ex.getStackTrace()).mkString("\n"));
                            }
                        }
                        this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$connection.$bang((Object)Tcp.Abort$.MODULE$, this.$outer.self());
                        return;
                    }
                    this.$outer.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$fail(ex);
                }
            });
            this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeBuffer = ByteString$.MODULE$.empty();
        }

        @Override
        public LoggingAdapter org$apache$pekko$stream$stage$StageLogging$$_log() {
            return this.org$apache$pekko$stream$stage$StageLogging$$_log;
        }

        @Override
        public void org$apache$pekko$stream$stage$StageLogging$$_log_$eq(LoggingAdapter x$1) {
            this.org$apache$pekko$stream$stage$StageLogging$$_log = x$1;
        }

        public FlowShape<ByteString, ByteString> shape() {
            return this.shape;
        }

        public TcpRole role() {
            return this.role;
        }

        public ActorRef self() {
            return this.stageActor().ref();
        }

        public Inlet<ByteString> org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$bytesIn() {
            return this.shape().in();
        }

        private Outlet<ByteString> bytesOut() {
            return this.shape().out();
        }

        public boolean org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$coalesceWritesDisabled() {
            return this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$coalesceWrites == 0;
        }

        @Override
        public void preStart() {
            this.setKeepGoing(true);
            TcpRole tcpRole = this.role();
            if (tcpRole instanceof Inbound) {
                Inbound inbound = TcpConnectionStage$Inbound$.MODULE$.unapply((Inbound)tcpRole);
                ActorRef actorRef = inbound._1();
                boolean bl = inbound._2();
                Function0<BoxedUnit> function0 = inbound._3();
                ActorRef conn = actorRef;
                Function0<BoxedUnit> registerCallback = function0;
                this.setHandler(this.bytesOut(), this.readHandler());
                this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$connection = conn;
                this.getStageActor((Function1<Tuple2<ActorRef, Object>, BoxedUnit>)(JProcedure1 & Serializable)evt -> this.connected((Tuple2<ActorRef, Object>)evt)).watch(this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$connection);
                this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$connection.$bang((Object)Tcp.Register$.MODULE$.apply(this.self(), true, false), this.self());
                registerCallback.apply$mcV$sp();
                this.pull(this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$bytesIn());
                return;
            }
            if (tcpRole instanceof Outbound) {
                Outbound outbound = (Outbound)tcpRole;
                Outbound outbound2 = TcpConnectionStage$Outbound$.MODULE$.unapply(outbound);
                ActorRef actorRef = outbound2._1();
                Tcp.Connect connect = outbound2._2();
                Promise<InetSocketAddress> promise = outbound2._3();
                boolean bl = outbound2._4();
                ActorRef manager = actorRef;
                Tcp.Connect cmd = connect;
                Outbound ob = outbound;
                this.getStageActor((Function1<Tuple2<ActorRef, Object>, BoxedUnit>)(JProcedure1 & Serializable)evt -> this.connecting(ob, (Tuple2<ActorRef, Object>)evt)).watch(manager);
                manager.$bang((Object)cmd, this.self());
                return;
            }
            TcpRole other = tcpRole;
            throw new IllegalArgumentException(new StringBuilder(22).append("Unsupported TCP role: ").append(other).toString());
        }

        private void connecting(Outbound ob, Tuple2<ActorRef, Object> evt2) {
            ActorRef sender = (ActorRef)evt2._1();
            Object msg = evt2._2();
            Object object = msg;
            if (object instanceof Terminated) {
                Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                ActorRef actorRef = terminated._1();
                this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$fail(new StreamTcpException("The IO manager actor (TCP) has terminated. Stopping now."));
                return;
            }
            if (object instanceof Tcp.CommandFailed) {
                Tcp.Command command;
                Tcp.CommandFailed commandFailed = (Tcp.CommandFailed)object;
                Tcp.CommandFailed commandFailed2 = Tcp.CommandFailed$.MODULE$.unapply(commandFailed);
                Tcp.Command cmd = command = commandFailed2._1();
                Tcp.CommandFailed f = commandFailed;
                this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$fail(new StreamTcpException(new StringBuilder(21).append("Tcp command [").append(cmd).append("] failed").append(f.causedByString()).toString()).initCause((Throwable)f.cause().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
                return;
            }
            if (object instanceof Tcp.Connected) {
                Tcp.Connected c = (Tcp.Connected)object;
                ((Outbound)this.role()).localAddressPromise().success((Object)c.localAddress());
                this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$connection = sender;
                this.setHandler(this.bytesOut(), this.readHandler());
                this.stageActor().unwatch(ob.manager());
                this.stageActor().become((Function1<Tuple2<ActorRef, Object>, BoxedUnit>)(JProcedure1 & Serializable)evt -> this.connected((Tuple2<ActorRef, Object>)evt));
                this.stageActor().watch(this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$connection);
                this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$connection.$bang((Object)Tcp.Register$.MODULE$.apply(this.self(), true, false), this.self());
                if (this.isAvailable(this.bytesOut())) {
                    this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$connection.$bang((Object)Tcp.ResumeReading$.MODULE$, this.self());
                }
                if (this.isClosed(this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$bytesIn())) {
                    this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$connection.$bang((Object)Tcp.ConfirmedClose$.MODULE$, this.self());
                    return;
                }
                this.pull(this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$bytesIn());
                return;
            }
            Object other = object;
            this.log().warning("Unexpected message to connecting TcpStage: [{}]", other.getClass());
        }

        public void org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$sendWriteBuffer() {
            this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$connection.$bang((Object)Tcp.Write$.MODULE$.apply(this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeBuffer, (Tcp.Event)TcpConnectionStage$WriteAck$.MODULE$), this.self());
            this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeInProgress = true;
            this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeBuffer = ByteString$.MODULE$.empty();
        }

        public void org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$sendWriteDelay() {
            this.previousWriteBufferSize = this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeBuffer.length();
            this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeInProgress = true;
            this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$connection.$bang((Object)TcpConnectionStage$.org$apache$pekko$stream$impl$io$TcpConnectionStage$$$WriteDelayMessage, this.self());
        }

        private void connected(Tuple2<ActorRef, Object> evt) {
            Object msg = evt._2();
            Object object = msg;
            if (object instanceof Tcp.Received) {
                ByteString byteString;
                Tcp.Received received = Tcp.Received$.MODULE$.unapply((Tcp.Received)object);
                ByteString data = byteString = received._1();
                if (this.isClosed(this.bytesOut())) {
                    this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$connection.$bang((Object)Tcp.ResumeReading$.MODULE$, this.self());
                    return;
                }
                this.push(this.bytesOut(), data);
                return;
            }
            if (TcpConnectionStage$WriteDelayAck$.MODULE$.equals(object)) {
                --this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeDelayCountDown;
                if (this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeDelayCountDown == 0 || this.previousWriteBufferSize == this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeBuffer.length() || this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeBuffer.length() >= this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeBufferSize) {
                    this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$sendWriteBuffer();
                    return;
                }
                this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$sendWriteDelay();
                return;
            }
            if (TcpConnectionStage$WriteAck$.MODULE$.equals(object)) {
                if (this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeBuffer.isEmpty()) {
                    this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeInProgress = false;
                } else if (this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$coalesceWritesDisabled() || this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeBuffer.length() >= this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeBufferSize) {
                    this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$sendWriteBuffer();
                } else {
                    this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeDelayCountDown = this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$coalesceWrites;
                    this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$sendWriteDelay();
                }
                if (!this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeInProgress && this.connectionClosePending) {
                    this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$closeConnectionUpstreamFinished();
                }
                if (!this.isClosed(this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$bytesIn()) && !this.hasBeenPulled(this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$bytesIn())) {
                    this.pull(this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$bytesIn());
                    return;
                }
                return;
            }
            if (object instanceof Terminated) {
                Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                ActorRef actorRef = terminated._1();
                this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$fail(new StreamTcpException("The connection actor has terminated. Stopping now."));
                return;
            }
            if (object instanceof Tcp.CommandFailed) {
                Tcp.Command command;
                Tcp.CommandFailed commandFailed = (Tcp.CommandFailed)object;
                Tcp.CommandFailed commandFailed2 = Tcp.CommandFailed$.MODULE$.unapply(commandFailed);
                Tcp.Command cmd = command = commandFailed2._1();
                Tcp.CommandFailed f = commandFailed;
                this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$fail(new StreamTcpException(new StringBuilder(21).append("Tcp command [").append(cmd).append("] failed").append(f.causedByString()).toString()).initCause((Throwable)f.cause().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
                return;
            }
            if (object instanceof Tcp.ErrorClosed) {
                String string;
                Tcp.ErrorClosed errorClosed = Tcp.ErrorClosed$.MODULE$.unapply((Tcp.ErrorClosed)object);
                String cause = string = errorClosed._1();
                this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$fail(new StreamTcpException(new StringBuilder(34).append("The connection closed with error: ").append(cause).toString()));
                return;
            }
            if (Tcp.Aborted$.MODULE$.equals(object)) {
                this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$fail(new StreamTcpException("The connection has been aborted"));
                return;
            }
            if (Tcp.Closed$.MODULE$.equals(object)) {
                this.completeStage();
                return;
            }
            if (Tcp.ConfirmedClosed$.MODULE$.equals(object)) {
                this.completeStage();
                return;
            }
            if (Tcp.PeerClosed$.MODULE$.equals(object)) {
                this.complete(this.bytesOut());
                return;
            }
            Object other = object;
            this.log().warning("Unexpected message to connected TcpStage: [{}]", other.getClass());
        }

        public void org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$closeConnectionUpstreamFinished() {
            if (this.isClosed(this.bytesOut()) || !this.role().halfClose()) {
                if (this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeInProgress) {
                    this.connectionClosePending = true;
                    return;
                }
                this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$connection.$bang((Object)Tcp.Close$.MODULE$, this.self());
                return;
            }
            if (this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$connection != null) {
                if (this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeInProgress) {
                    this.connectionClosePending = true;
                    return;
                }
                this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$connection.$bang((Object)Tcp.ConfirmedClose$.MODULE$, this.self());
                return;
            }
        }

        public void org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$closeConnectionDownstreamFinished() {
            if (this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$connection == null) {
                return;
            }
            if (this.role().halfClose()) {
                if (this.isClosed(this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$bytesIn()) && !this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeInProgress) {
                    this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$connection.$bang((Object)Tcp.Close$.MODULE$, this.self());
                    return;
                }
                this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$connection.$bang((Object)Tcp.ResumeReading$.MODULE$, this.self());
                return;
            }
            if (!this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$writeInProgress) {
                this.org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$connection.$bang((Object)Tcp.Close$.MODULE$, this.self());
                return;
            }
        }

        public OutHandler readHandler() {
            return this.readHandler;
        }

        public void org$apache$pekko$stream$impl$io$TcpConnectionStage$TcpStreamLogic$$fail(Throwable ex) {
            this.reportExceptionToPromise(ex);
            this.failStage(ex);
        }

        private void reportExceptionToPromise(Throwable ex) {
            TcpRole tcpRole = this.role();
            if (tcpRole instanceof Outbound) {
                Outbound outbound = TcpConnectionStage$Outbound$.MODULE$.unapply((Outbound)tcpRole);
                ActorRef actorRef = outbound._1();
                Tcp.Connect connect = outbound._2();
                Promise<InetSocketAddress> promise = outbound._3();
                boolean bl = outbound._4();
                Promise<InetSocketAddress> localAddressPromise = promise;
                localAddressPromise.tryFailure(ex);
                return;
            }
        }

        @Override
        public void postStop() {
            this.reportExceptionToPromise(new StreamTcpException("Connection failed."));
        }

        public <T> T protected$grab(Inlet<T> in) {
            return this.grab(in);
        }

        public <T> void protected$pull(Inlet<T> in) {
            this.pull(in);
        }
    }
}

