/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.fusing;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.impl.Stages$DefaultAttributes$;
import org.apache.pekko.stream.impl.fusing.GroupedWeighted$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ReusableBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@InternalApi
public final class GroupedWeighted<T>
extends GraphStage<FlowShape<T, Seq<T>>>
implements Product,
Serializable {
    private final long minWeight;
    private final Function1 costFn;
    private final Inlet in;
    private final Outlet out;
    private final FlowShape shape;

    public static <T> GroupedWeighted<T> apply(long l, Function1<T, Object> function1) {
        return GroupedWeighted$.MODULE$.apply(l, function1);
    }

    public static GroupedWeighted<?> fromProduct(Product product) {
        return GroupedWeighted$.MODULE$.fromProduct(product);
    }

    public static <T> GroupedWeighted<T> unapply(GroupedWeighted<T> groupedWeighted) {
        return GroupedWeighted$.MODULE$.unapply(groupedWeighted);
    }

    public GroupedWeighted(long minWeight, Function1<T, Object> costFn) {
        this.minWeight = minWeight;
        this.costFn = costFn;
        Predef$.MODULE$.require(minWeight > 0L, GroupedWeighted::$init$$$anonfun$3);
        this.in = Inlet$.MODULE$.apply("GroupedWeighted.in");
        this.out = Outlet$.MODULE$.apply("GroupedWeighted.out");
        this.shape = FlowShape$.MODULE$.apply(this.in(), this.out());
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.minWeight()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.costFn()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof GroupedWeighted)) return false;
        GroupedWeighted groupedWeighted = (GroupedWeighted)object;
        if (this.minWeight() != groupedWeighted.minWeight()) return false;
        Function1<T, Object> function1 = this.costFn();
        Function1<T, Object> function12 = groupedWeighted.costFn();
        if (function1 != null) {
            if (!function1.equals(function12)) return false;
            return true;
        }
        if (function12 == null) return true;
        return false;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof GroupedWeighted;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "GroupedWeighted";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return BoxesRunTime.boxToLong((long)this._1());
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "minWeight";
        }
        if (1 == n2) {
            return "costFn";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public long minWeight() {
        return this.minWeight;
    }

    public Function1<T, Object> costFn() {
        return this.costFn;
    }

    public Inlet<T> in() {
        return this.in;
    }

    public Outlet<Seq<T>> out() {
        return this.out;
    }

    @Override
    public FlowShape<T, Seq<T>> shape() {
        return this.shape;
    }

    @Override
    public Attributes initialAttributes() {
        return Stages$DefaultAttributes$.MODULE$.groupedWeighted();
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(this){
            private ReusableBuilder builder;
            private long left;
            private final /* synthetic */ GroupedWeighted $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                this.builder = package$.MODULE$.Vector().newBuilder();
                this.left = $outer.minWeight();
                this.setHandlers($outer.in(), $outer.out(), this);
            }

            public void onPush() {
                T elem = this.grab(this.$outer.in());
                long cost = BoxesRunTime.unboxToLong((Object)this.$outer.costFn().apply(elem));
                if (cost < 0L) {
                    this.failStage(new IllegalArgumentException(new StringBuilder(48).append("Negative weight [").append(cost).append("] for element [").append(elem).append("] is not allowed").toString()));
                    return;
                }
                this.builder.$plus$eq(elem);
                this.left -= cost;
                if (this.left <= 0L) {
                    Vector elements = (Vector)this.builder.result();
                    this.builder.clear();
                    this.left = this.$outer.minWeight();
                    this.push(this.$outer.out(), elements);
                    return;
                }
                this.pull(this.$outer.in());
            }

            public void onPull() {
                this.pull(this.$outer.in());
            }

            public void onUpstreamFinish() {
                Vector elements = (Vector)this.builder.result();
                if (elements.nonEmpty()) {
                    this.left = this.$outer.minWeight();
                    this.push(this.$outer.out(), elements);
                }
                this.builder = null;
                this.completeStage();
            }
        };
    }

    public <T> GroupedWeighted<T> copy(long minWeight, Function1<T, Object> costFn) {
        return new GroupedWeighted<T>(minWeight, costFn);
    }

    public long copy$default$1() {
        return this.minWeight();
    }

    public <T> Function1<T, Object> copy$default$2() {
        return this.costFn();
    }

    public long _1() {
        return this.minWeight();
    }

    public Function1<T, Object> _2() {
        return this.costFn();
    }

    private static final Object $init$$$anonfun$3() {
        return "minWeight must be greater than 0";
    }
}

