/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.impl.ReactiveStreamsCompliance$;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import scala.concurrent.Promise;

@InternalApi
public final class SinkholeSubscriber<T>
implements Subscriber<T> {
    private final Promise<Done> whenComplete;
    private boolean running;

    public SinkholeSubscriber(Promise<Done> whenComplete) {
        this.whenComplete = whenComplete;
        this.running = false;
    }

    public void onSubscribe(Subscription sub) {
        ReactiveStreamsCompliance$.MODULE$.requireNonNullSubscription(sub);
        if (this.running) {
            sub.cancel();
            return;
        }
        this.running = true;
        sub.request(Long.MAX_VALUE);
    }

    public void onError(Throwable cause) {
        ReactiveStreamsCompliance$.MODULE$.requireNonNullException(cause);
        this.whenComplete.tryFailure(cause);
    }

    public void onComplete() {
        this.whenComplete.trySuccess((Object)Done$.MODULE$);
    }

    public void onNext(T element) {
        ReactiveStreamsCompliance$.MODULE$.requireNonNullElement(element);
    }
}

