/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import java.io.Serializable;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.DeadLetterSuppression;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.annotation.DoNotInherit;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.stream.AbruptTerminationException$;
import org.apache.pekko.stream.ActorAttributes;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.impl.ActorSubscriberMessage$OnComplete$;
import org.apache.pekko.stream.impl.ActorSubscriberMessage$OnNext$;
import org.apache.pekko.stream.impl.ActorSubscriberMessage$OnSubscribe$;
import org.apache.pekko.stream.impl.BatchingInputBuffer;
import org.apache.pekko.stream.impl.FanIn$;
import org.apache.pekko.stream.impl.FanIn$OnComplete$;
import org.apache.pekko.stream.impl.FanIn$OnError$;
import org.apache.pekko.stream.impl.FanIn$OnNext$;
import org.apache.pekko.stream.impl.FanIn$OnSubscribe$;
import org.apache.pekko.stream.impl.FanIn$SubInput$;
import org.apache.pekko.stream.impl.Outputs;
import org.apache.pekko.stream.impl.Pump;
import org.apache.pekko.stream.impl.ReactiveStreamsCompliance$;
import org.apache.pekko.stream.impl.SimpleOutputs;
import org.apache.pekko.stream.impl.SubReceive;
import org.apache.pekko.stream.impl.TransferPhase;
import org.apache.pekko.stream.impl.TransferState;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import scala.Array$;
import scala.Byte$;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@DoNotInherit
public class FanIn
implements Actor,
ActorLogging,
Pump {
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private TransferState org$apache$pekko$stream$impl$Pump$$transferState;
    private Function0 org$apache$pekko$stream$impl$Pump$$currentAction;
    private TransferPhase completedPhase;
    private final int inputCount;
    private final Outputs primaryOutputs;
    private final InputBunch inputBunch;
    private final boolean debugLoggingEnabled;

    public static int Cancelled() {
        return FanIn$.MODULE$.Cancelled();
    }

    public static int Completed() {
        return FanIn$.MODULE$.Completed();
    }

    public static int Depleted() {
        return FanIn$.MODULE$.Depleted();
    }

    public static int Marked() {
        return FanIn$.MODULE$.Marked();
    }

    public static int Pending() {
        return FanIn$.MODULE$.Pending();
    }

    public FanIn(Attributes attributes, int inputCount) {
        this.inputCount = inputCount;
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        Pump.$init$(this);
        this.primaryOutputs = new SimpleOutputs(this.self(), this);
        int maxInputBufferSize = ((Attributes.InputBuffer)attributes.mandatoryAttribute(ClassTag$.MODULE$.apply(Attributes.InputBuffer.class))).max();
        this.inputBunch = new InputBunch(maxInputBufferSize, this){
            private final /* synthetic */ FanIn $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.inputCount(), maxInputBufferSize$1, $outer);
            }

            public void onError(int input, Throwable e) {
                this.$outer.fail(e);
            }

            public void onCompleteWhenNoInput() {
                this.$outer.pumpFinished();
            }
        };
        this.debugLoggingEnabled = ((ActorAttributes.DebugLogging)attributes.mandatoryAttribute(ClassTag$.MODULE$.apply(ActorAttributes.DebugLogging.class))).enabled();
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public TransferState org$apache$pekko$stream$impl$Pump$$transferState() {
        return this.org$apache$pekko$stream$impl$Pump$$transferState;
    }

    public Function0 org$apache$pekko$stream$impl$Pump$$currentAction() {
        return this.org$apache$pekko$stream$impl$Pump$$currentAction;
    }

    @Override
    public final TransferPhase completedPhase() {
        return this.completedPhase;
    }

    @Override
    public void org$apache$pekko$stream$impl$Pump$$transferState_$eq(TransferState x$1) {
        this.org$apache$pekko$stream$impl$Pump$$transferState = x$1;
    }

    public void org$apache$pekko$stream$impl$Pump$$currentAction_$eq(Function0 x$1) {
        this.org$apache$pekko$stream$impl$Pump$$currentAction = x$1;
    }

    @Override
    public void org$apache$pekko$stream$impl$Pump$_setter_$completedPhase_$eq(TransferPhase x$0) {
        this.completedPhase = x$0;
    }

    public int inputCount() {
        return this.inputCount;
    }

    public Outputs primaryOutputs() {
        return this.primaryOutputs;
    }

    public InputBunch inputBunch() {
        return this.inputBunch;
    }

    @Override
    public void pumpFinished() {
        this.inputBunch().cancel();
        this.primaryOutputs().complete();
        this.context().stop(this.self());
    }

    @Override
    public void pumpFailed(Throwable e) {
        this.fail(e);
    }

    public void fail(Throwable e) {
        if (this.debugLoggingEnabled) {
            this.log().debug("fail due to: {}", (Object)e.getMessage());
        }
        this.nextPhase(this.completedPhase());
        this.primaryOutputs().error(e);
        this.pump();
    }

    public void postStop() {
        this.inputBunch().cancel();
        this.primaryOutputs().error(AbruptTerminationException$.MODULE$.apply(this.self()));
    }

    public void postRestart(Throwable reason) {
        Actor.postRestart$((Actor)this, (Throwable)reason);
        throw new IllegalStateException("This actor cannot be restarted");
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.inputBunch().subreceive().orElse(this.primaryOutputs().subreceive());
    }

    public static abstract class InputBunch {
        private final int inputCount;
        public final int org$apache$pekko$stream$impl$FanIn$InputBunch$$bufferSize;
        public final Pump org$apache$pekko$stream$impl$FanIn$InputBunch$$pump;
        private boolean allCancelled;
        public final BatchingInputBuffer[] org$apache$pekko$stream$impl$FanIn$InputBunch$$inputs;
        private final byte[] states;
        public int org$apache$pekko$stream$impl$FanIn$InputBunch$$markCount;
        public int org$apache$pekko$stream$impl$FanIn$InputBunch$$markedPending;
        public int org$apache$pekko$stream$impl$FanIn$InputBunch$$markedDepleted;
        public boolean org$apache$pekko$stream$impl$FanIn$InputBunch$$receivedInput;
        private int completedCounter;
        private int preferredId;
        private int _lastDequeuedId;
        private final TransferState AllOfMarkedInputs;
        private final TransferState AnyOfMarkedInputs;

        public InputBunch(int inputCount, int bufferSize, Pump pump) {
            this.inputCount = inputCount;
            this.org$apache$pekko$stream$impl$FanIn$InputBunch$$bufferSize = bufferSize;
            this.org$apache$pekko$stream$impl$FanIn$InputBunch$$pump = pump;
            this.allCancelled = false;
            this.org$apache$pekko$stream$impl$FanIn$InputBunch$$inputs = (BatchingInputBuffer[])Array$.MODULE$.tabulate(inputCount, (Function1 & Serializable)i -> this.$init$$$anonfun$1(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(BatchingInputBuffer.class));
            this.states = new byte[inputCount];
            this.org$apache$pekko$stream$impl$FanIn$InputBunch$$markCount = 0;
            this.org$apache$pekko$stream$impl$FanIn$InputBunch$$markedPending = 0;
            this.org$apache$pekko$stream$impl$FanIn$InputBunch$$markedDepleted = 0;
            this.org$apache$pekko$stream$impl$FanIn$InputBunch$$receivedInput = false;
            this.completedCounter = 0;
            this.preferredId = 0;
            this._lastDequeuedId = 0;
            this.AllOfMarkedInputs = new TransferState(this){
                private final /* synthetic */ InputBunch $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public boolean isCompleted() {
                    return this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$markedDepleted > 0;
                }

                public boolean isReady() {
                    return this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$markedPending == this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$markCount;
                }
            };
            this.AnyOfMarkedInputs = new TransferState(this){
                private final /* synthetic */ InputBunch $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public boolean isCompleted() {
                    return this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$markedDepleted == this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$markCount && this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$markedPending == 0;
                }

                public boolean isReady() {
                    return this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$markedPending > 0;
                }
            };
        }

        private final boolean hasState(int index, int flag) {
            return (this.states[index] & flag) != 0;
        }

        private final void setState(int index, int flag, boolean on) {
            this.states[index] = on ? (byte)(this.states[index] | flag) : (byte)(this.states[index] & ~flag);
        }

        public final boolean org$apache$pekko$stream$impl$FanIn$InputBunch$$cancelled(int index) {
            return this.hasState(index, 16);
        }

        private final void cancelled(int index, boolean on) {
            this.setState(index, 16, on);
        }

        public final boolean org$apache$pekko$stream$impl$FanIn$InputBunch$$completed(int index) {
            return this.hasState(index, 8);
        }

        public final void org$apache$pekko$stream$impl$FanIn$InputBunch$$registerCompleted(int index) {
            ++this.completedCounter;
            this.setState(index, 8, true);
        }

        public final boolean org$apache$pekko$stream$impl$FanIn$InputBunch$$depleted(int index) {
            return this.hasState(index, 4);
        }

        public final void org$apache$pekko$stream$impl$FanIn$InputBunch$$depleted(int index, boolean on) {
            this.setState(index, 4, on);
        }

        public final boolean org$apache$pekko$stream$impl$FanIn$InputBunch$$pending(int index) {
            return this.hasState(index, 2);
        }

        public final void org$apache$pekko$stream$impl$FanIn$InputBunch$$pending(int index, boolean on) {
            this.setState(index, 2, on);
        }

        public final boolean org$apache$pekko$stream$impl$FanIn$InputBunch$$marked(int index) {
            return this.hasState(index, 1);
        }

        private final void marked(int index, boolean on) {
            this.setState(index, 1, on);
        }

        public String toString() {
            Object object = Predef$.MODULE$.byteArrayOps(this.states);
            Object object2 = Predef$.MODULE$.byteArrayOps(this.states);
            Object object3 = Predef$.MODULE$.byteArrayOps(this.states);
            Object object4 = Predef$.MODULE$.byteArrayOps(this.states);
            Object object5 = Predef$.MODULE$.byteArrayOps(this.states);
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(187).append("|InputBunch\n          |  marked:    ").append(ArrayOps$.MODULE$.iterator$extension(object).map((Function1 & Serializable)_$1 -> this.toString$$anonfun$1(BoxesRunTime.unboxToByte((Object)_$1))).mkString(", ")).append("\n          |  pending:   ").append(ArrayOps$.MODULE$.iterator$extension(object2).map((Function1 & Serializable)_$2 -> this.toString$$anonfun$2(BoxesRunTime.unboxToByte((Object)_$2))).mkString(", ")).append("\n          |  depleted:  ").append(ArrayOps$.MODULE$.iterator$extension(object3).map((Function1 & Serializable)_$3 -> this.toString$$anonfun$3(BoxesRunTime.unboxToByte((Object)_$3))).mkString(", ")).append("\n          |  completed: ").append(ArrayOps$.MODULE$.iterator$extension(object4).map((Function1 & Serializable)_$4 -> this.toString$$anonfun$4(BoxesRunTime.unboxToByte((Object)_$4))).mkString(", ")).append("\n          |  cancelled: ").append(ArrayOps$.MODULE$.iterator$extension(object5).map((Function1 & Serializable)_$5 -> this.toString$$anonfun$5(BoxesRunTime.unboxToByte((Object)_$5))).mkString(", ")).append("\n          |\n          |    mark=").append(this.org$apache$pekko$stream$impl$FanIn$InputBunch$$markCount).append(" pend=").append(this.org$apache$pekko$stream$impl$FanIn$InputBunch$$markedPending).append(" depl=").append(this.org$apache$pekko$stream$impl$FanIn$InputBunch$$markedDepleted).append(" pref=").append(this.preferredId).toString()));
        }

        public int lastDequeuedId() {
            return this._lastDequeuedId;
        }

        public void cancel() {
            if (!this.allCancelled) {
                this.allCancelled = true;
                for (int i = 0; i < this.org$apache$pekko$stream$impl$FanIn$InputBunch$$inputs.length; ++i) {
                    this.cancel(i);
                }
                return;
            }
        }

        public void cancel(int input) {
            if (!this.org$apache$pekko$stream$impl$FanIn$InputBunch$$cancelled(input)) {
                this.org$apache$pekko$stream$impl$FanIn$InputBunch$$inputs[input].cancel();
                this.cancelled(input, true);
                this.unmarkInput(input);
                return;
            }
        }

        public abstract void onError(int var1, Throwable var2);

        public void onDepleted(int input) {
        }

        public void onCompleteWhenNoInput() {
        }

        public void markInput(int input) {
            if (!this.org$apache$pekko$stream$impl$FanIn$InputBunch$$marked(input)) {
                if (this.org$apache$pekko$stream$impl$FanIn$InputBunch$$depleted(input)) {
                    ++this.org$apache$pekko$stream$impl$FanIn$InputBunch$$markedDepleted;
                }
                if (this.org$apache$pekko$stream$impl$FanIn$InputBunch$$pending(input)) {
                    ++this.org$apache$pekko$stream$impl$FanIn$InputBunch$$markedPending;
                }
                this.marked(input, true);
                ++this.org$apache$pekko$stream$impl$FanIn$InputBunch$$markCount;
                return;
            }
        }

        public void unmarkInput(int input) {
            if (this.org$apache$pekko$stream$impl$FanIn$InputBunch$$marked(input)) {
                if (this.org$apache$pekko$stream$impl$FanIn$InputBunch$$depleted(input)) {
                    --this.org$apache$pekko$stream$impl$FanIn$InputBunch$$markedDepleted;
                }
                if (this.org$apache$pekko$stream$impl$FanIn$InputBunch$$pending(input)) {
                    --this.org$apache$pekko$stream$impl$FanIn$InputBunch$$markedPending;
                }
                this.marked(input, false);
                --this.org$apache$pekko$stream$impl$FanIn$InputBunch$$markCount;
                return;
            }
        }

        public void markAllInputs() {
            for (int i = 0; i < this.inputCount; ++i) {
                this.markInput(i);
            }
        }

        public void unmarkAllInputs() {
            for (int i = 0; i < this.inputCount; ++i) {
                this.unmarkInput(i);
            }
        }

        public boolean isPending(int input) {
            return this.org$apache$pekko$stream$impl$FanIn$InputBunch$$pending(input);
        }

        public boolean isDepleted(int input) {
            return this.org$apache$pekko$stream$impl$FanIn$InputBunch$$depleted(input);
        }

        public boolean isCancelled(int input) {
            return this.org$apache$pekko$stream$impl$FanIn$InputBunch$$cancelled(input);
        }

        public boolean isAllCompleted() {
            return this.inputCount == this.completedCounter;
        }

        public int idToDequeue() {
            int id = this.preferredId;
            while (!this.org$apache$pekko$stream$impl$FanIn$InputBunch$$marked(id) || !this.org$apache$pekko$stream$impl$FanIn$InputBunch$$pending(id)) {
                if (++id == this.inputCount) {
                    id = 0;
                }
                Predef$.MODULE$.require(id != this.preferredId, FanIn$::org$apache$pekko$stream$impl$FanIn$InputBunch$$_$idToDequeue$$anonfun$1);
            }
            return id;
        }

        public Object dequeue(int id) {
            Predef$.MODULE$.require(!this.isDepleted(id), () -> FanIn$.org$apache$pekko$stream$impl$FanIn$InputBunch$$_$dequeue$$anonfun$1(id));
            Predef$.MODULE$.require(this.isPending(id), () -> FanIn$.org$apache$pekko$stream$impl$FanIn$InputBunch$$_$dequeue$$anonfun$2(id));
            this._lastDequeuedId = id;
            BatchingInputBuffer input = this.org$apache$pekko$stream$impl$FanIn$InputBunch$$inputs[id];
            Object elem = input.dequeueInputElement();
            if (!input.inputsAvailable()) {
                if (this.org$apache$pekko$stream$impl$FanIn$InputBunch$$marked(id)) {
                    --this.org$apache$pekko$stream$impl$FanIn$InputBunch$$markedPending;
                }
                this.org$apache$pekko$stream$impl$FanIn$InputBunch$$pending(id, false);
            }
            if (input.inputsDepleted()) {
                if (this.org$apache$pekko$stream$impl$FanIn$InputBunch$$marked(id)) {
                    ++this.org$apache$pekko$stream$impl$FanIn$InputBunch$$markedDepleted;
                }
                this.org$apache$pekko$stream$impl$FanIn$InputBunch$$depleted(id, true);
                this.onDepleted(id);
            }
            return elem;
        }

        public Object dequeueAndYield() {
            return this.dequeueAndYield(this.idToDequeue());
        }

        public Object dequeueAndYield(int id) {
            this.preferredId = id + 1;
            if (this.preferredId == this.inputCount) {
                this.preferredId = 0;
            }
            return this.dequeue(id);
        }

        public Object dequeuePreferring(int preferred) {
            this.preferredId = preferred;
            int id = this.idToDequeue();
            return this.dequeue(id);
        }

        public TransferState AllOfMarkedInputs() {
            return this.AllOfMarkedInputs;
        }

        public TransferState AnyOfMarkedInputs() {
            return this.AnyOfMarkedInputs;
        }

        public TransferState inputsAvailableFor(int id) {
            return new TransferState(id, this){
                private final int id$3;
                private final /* synthetic */ InputBunch $outer;
                {
                    this.id$3 = id$5;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public boolean isCompleted() {
                    return this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$depleted(this.id$3) || this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$cancelled(this.id$3) || !this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$pending(this.id$3) && this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$completed(this.id$3);
                }

                public boolean isReady() {
                    return this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$pending(this.id$3);
                }
            };
        }

        public TransferState inputsOrCompleteAvailableFor(int id) {
            return new TransferState(id, this){
                private final int id$4;
                private final /* synthetic */ InputBunch $outer;
                {
                    this.id$4 = id$6;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public boolean isCompleted() {
                    return false;
                }

                public boolean isReady() {
                    return this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$pending(this.id$4) || this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$depleted(this.id$4);
                }
            };
        }

        public SubReceive subreceive() {
            return new SubReceive((PartialFunction<Object, BoxedUnit>)new Serializable(this){
                private final /* synthetic */ InputBunch $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Object x) {
                    Object object = x;
                    if (object instanceof OnNext) {
                        OnNext onNext = FanIn$OnNext$.MODULE$.unapply((OnNext)object);
                        int n = onNext._1();
                        Object object2 = onNext._2();
                        int id = n;
                        Object elem = object2;
                        return true;
                    }
                    if (object instanceof OnComplete) {
                        int n;
                        OnComplete onComplete = FanIn$OnComplete$.MODULE$.unapply((OnComplete)object);
                        int id = n = onComplete._1();
                        return true;
                    }
                    if (object instanceof OnError) {
                        OnError onError = FanIn$OnError$.MODULE$.unapply((OnError)object);
                        int n = onError._1();
                        Throwable throwable = onError._2();
                        int id = n;
                        Throwable e = throwable;
                        return true;
                    }
                    if (object instanceof OnSubscribe) {
                        OnSubscribe onSubscribe = FanIn$OnSubscribe$.MODULE$.unapply((OnSubscribe)object);
                        int n = onSubscribe._1();
                        Subscription subscription = onSubscribe._2();
                        int id = n;
                        Subscription subscription2 = subscription;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Object x, Function1 function1) {
                    Object object = x;
                    if (object instanceof OnNext) {
                        OnNext onNext = FanIn$OnNext$.MODULE$.unapply((OnNext)object);
                        int n = onNext._1();
                        Object object2 = onNext._2();
                        int id = n;
                        Object elem = object2;
                        if (this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$marked(id) && !this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$pending(id)) {
                            ++this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$markedPending;
                        }
                        this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$pending(id, true);
                        this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$receivedInput = true;
                        this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$inputs[id].subreceive().apply(ActorSubscriberMessage$OnNext$.MODULE$.apply(elem));
                        return BoxedUnit.UNIT;
                    }
                    if (object instanceof OnComplete) {
                        OnComplete onComplete = FanIn$OnComplete$.MODULE$.unapply((OnComplete)object);
                        int n = onComplete._1();
                        int id = n;
                        if (!this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$pending(id)) {
                            if (this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$marked(id) && !this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$depleted(id)) {
                                ++this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$markedDepleted;
                            }
                            this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$depleted(id, true);
                            this.$outer.onDepleted(id);
                        }
                        this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$registerCompleted(id);
                        this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$inputs[id].subreceive().apply(ActorSubscriberMessage$OnComplete$.MODULE$);
                        if (!this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$receivedInput && this.$outer.isAllCompleted()) {
                            this.$outer.onCompleteWhenNoInput();
                            return BoxedUnit.UNIT;
                        }
                        return BoxedUnit.UNIT;
                    }
                    if (object instanceof OnError) {
                        OnError onError = FanIn$OnError$.MODULE$.unapply((OnError)object);
                        int n = onError._1();
                        Throwable throwable = onError._2();
                        int id = n;
                        Throwable e = throwable;
                        this.$outer.onError(id, e);
                        return BoxedUnit.UNIT;
                    }
                    if (object instanceof OnSubscribe) {
                        OnSubscribe onSubscribe = FanIn$OnSubscribe$.MODULE$.unapply((OnSubscribe)object);
                        int n = onSubscribe._1();
                        Subscription subscription = onSubscribe._2();
                        int id = n;
                        Subscription subscription2 = subscription;
                        this.$outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$inputs[id].subreceive().apply(ActorSubscriberMessage$OnSubscribe$.MODULE$.apply(subscription2));
                        return BoxedUnit.UNIT;
                    }
                    return function1.apply(x);
                }
            });
        }

        private final /* synthetic */ BatchingInputBuffer $init$$$anonfun$1(int i) {
            return new BatchingInputBuffer(i, this){
                private final int i$1;
                private final /* synthetic */ InputBunch $outer;
                {
                    this.i$1 = i$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$bufferSize, $outer.org$apache$pekko$stream$impl$FanIn$InputBunch$$pump);
                }

                public void onError(Throwable e) {
                    this.$outer.onError(this.i$1, e);
                }
            };
        }

        private final /* synthetic */ boolean toString$$anonfun$1(byte _$1) {
            return this.org$apache$pekko$stream$impl$FanIn$InputBunch$$marked(Byte$.MODULE$.byte2int(_$1));
        }

        private final /* synthetic */ boolean toString$$anonfun$2(byte _$2) {
            return this.org$apache$pekko$stream$impl$FanIn$InputBunch$$pending(Byte$.MODULE$.byte2int(_$2));
        }

        private final /* synthetic */ boolean toString$$anonfun$3(byte _$3) {
            return this.org$apache$pekko$stream$impl$FanIn$InputBunch$$depleted(Byte$.MODULE$.byte2int(_$3));
        }

        private final /* synthetic */ boolean toString$$anonfun$4(byte _$4) {
            return this.org$apache$pekko$stream$impl$FanIn$InputBunch$$completed(Byte$.MODULE$.byte2int(_$4));
        }

        private final /* synthetic */ boolean toString$$anonfun$5(byte _$5) {
            return this.org$apache$pekko$stream$impl$FanIn$InputBunch$$cancelled(Byte$.MODULE$.byte2int(_$5));
        }
    }

    public static final class OnComplete
    implements DeadLetterSuppression,
    NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final int id;

        public static OnComplete apply(int n) {
            return FanIn$OnComplete$.MODULE$.apply(n);
        }

        public static OnComplete fromProduct(Product product) {
            return FanIn$OnComplete$.MODULE$.fromProduct(product);
        }

        public static OnComplete unapply(OnComplete onComplete) {
            return FanIn$OnComplete$.MODULE$.unapply(onComplete);
        }

        public OnComplete(int id) {
            this.id = id;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.id());
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof OnComplete)) return false;
            OnComplete onComplete = (OnComplete)object;
            if (this.id() != onComplete.id()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof OnComplete;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "OnComplete";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToInteger((int)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "id";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int id() {
            return this.id;
        }

        public OnComplete copy(int id) {
            return new OnComplete(id);
        }

        public int copy$default$1() {
            return this.id();
        }

        public int _1() {
            return this.id();
        }
    }

    public static final class OnError
    implements DeadLetterSuppression,
    NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final int id;
        private final Throwable cause;

        public static OnError apply(int n, Throwable throwable) {
            return FanIn$OnError$.MODULE$.apply(n, throwable);
        }

        public static OnError fromProduct(Product product) {
            return FanIn$OnError$.MODULE$.fromProduct(product);
        }

        public static OnError unapply(OnError onError) {
            return FanIn$OnError$.MODULE$.unapply(onError);
        }

        public OnError(int id, Throwable cause) {
            this.id = id;
            this.cause = cause;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.id());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.cause()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof OnError)) return false;
            OnError onError = (OnError)object;
            if (this.id() != onError.id()) return false;
            Throwable throwable = this.cause();
            Throwable throwable2 = onError.cause();
            if (throwable != null) {
                if (!throwable.equals(throwable2)) return false;
                return true;
            }
            if (throwable2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof OnError;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "OnError";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "id";
            }
            if (1 == n2) {
                return "cause";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int id() {
            return this.id;
        }

        public Throwable cause() {
            return this.cause;
        }

        public OnError copy(int id, Throwable cause) {
            return new OnError(id, cause);
        }

        public int copy$default$1() {
            return this.id();
        }

        public Throwable copy$default$2() {
            return this.cause();
        }

        public int _1() {
            return this.id();
        }

        public Throwable _2() {
            return this.cause();
        }
    }

    public static final class OnNext
    implements DeadLetterSuppression,
    NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final int id;
        private final Object e;

        public static OnNext apply(int n, Object object) {
            return FanIn$OnNext$.MODULE$.apply(n, object);
        }

        public static OnNext fromProduct(Product product) {
            return FanIn$OnNext$.MODULE$.fromProduct(product);
        }

        public static OnNext unapply(OnNext onNext) {
            return FanIn$OnNext$.MODULE$.unapply(onNext);
        }

        public OnNext(int id, Object e) {
            this.id = id;
            this.e = e;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.id());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.e()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof OnNext)) return false;
            OnNext onNext = (OnNext)object;
            if (this.id() != onNext.id()) return false;
            if (!BoxesRunTime.equals((Object)this.e(), (Object)onNext.e())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof OnNext;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "OnNext";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "id";
            }
            if (1 == n2) {
                return "e";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int id() {
            return this.id;
        }

        public Object e() {
            return this.e;
        }

        public OnNext copy(int id, Object e) {
            return new OnNext(id, e);
        }

        public int copy$default$1() {
            return this.id();
        }

        public Object copy$default$2() {
            return this.e();
        }

        public int _1() {
            return this.id();
        }

        public Object _2() {
            return this.e();
        }
    }

    public static final class OnSubscribe
    implements DeadLetterSuppression,
    NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final int id;
        private final Subscription subscription;

        public static OnSubscribe apply(int n, Subscription subscription) {
            return FanIn$OnSubscribe$.MODULE$.apply(n, subscription);
        }

        public static OnSubscribe fromProduct(Product product) {
            return FanIn$OnSubscribe$.MODULE$.fromProduct(product);
        }

        public static OnSubscribe unapply(OnSubscribe onSubscribe) {
            return FanIn$OnSubscribe$.MODULE$.unapply(onSubscribe);
        }

        public OnSubscribe(int id, Subscription subscription) {
            this.id = id;
            this.subscription = subscription;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.id());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.subscription()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof OnSubscribe)) return false;
            OnSubscribe onSubscribe = (OnSubscribe)object;
            if (this.id() != onSubscribe.id()) return false;
            Subscription subscription = this.subscription();
            Subscription subscription2 = onSubscribe.subscription();
            if (subscription != null) {
                if (!subscription.equals(subscription2)) return false;
                return true;
            }
            if (subscription2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof OnSubscribe;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "OnSubscribe";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "id";
            }
            if (1 == n2) {
                return "subscription";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int id() {
            return this.id;
        }

        public Subscription subscription() {
            return this.subscription;
        }

        public OnSubscribe copy(int id, Subscription subscription) {
            return new OnSubscribe(id, subscription);
        }

        public int copy$default$1() {
            return this.id();
        }

        public Subscription copy$default$2() {
            return this.subscription();
        }

        public int _1() {
            return this.id();
        }

        public Subscription _2() {
            return this.subscription();
        }
    }

    public static final class SubInput<T>
    implements Subscriber<T>,
    Product,
    Serializable {
        private final ActorRef impl;
        private final int id;

        public static <T> SubInput<T> apply(ActorRef actorRef, int n) {
            return FanIn$SubInput$.MODULE$.apply(actorRef, n);
        }

        public static SubInput<?> fromProduct(Product product) {
            return FanIn$SubInput$.MODULE$.fromProduct(product);
        }

        public static <T> SubInput<T> unapply(SubInput<T> subInput) {
            return FanIn$SubInput$.MODULE$.unapply(subInput);
        }

        public SubInput(ActorRef impl, int id) {
            this.impl = impl;
            this.id = id;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.impl()));
            n = Statics.mix((int)n, (int)this.id());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SubInput)) return false;
            SubInput subInput = (SubInput)object;
            if (this.id() != subInput.id()) return false;
            ActorRef actorRef = this.impl();
            ActorRef actorRef2 = subInput.impl();
            if (actorRef != null) {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SubInput;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SubInput";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToInteger((int)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "impl";
            }
            if (1 == n2) {
                return "id";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ActorRef impl() {
            return this.impl;
        }

        public int id() {
            return this.id;
        }

        public void onError(Throwable cause) {
            ReactiveStreamsCompliance$.MODULE$.requireNonNullException(cause);
            OnError onError = FanIn$OnError$.MODULE$.apply(this.id(), cause);
            this.impl().$bang((Object)onError, this.impl().$bang$default$2((Object)onError));
        }

        public void onComplete() {
            OnComplete onComplete = FanIn$OnComplete$.MODULE$.apply(this.id());
            this.impl().$bang((Object)onComplete, this.impl().$bang$default$2((Object)onComplete));
        }

        public void onNext(T element) {
            ReactiveStreamsCompliance$.MODULE$.requireNonNullElement(element);
            OnNext onNext = FanIn$OnNext$.MODULE$.apply(this.id(), element);
            this.impl().$bang((Object)onNext, this.impl().$bang$default$2((Object)onNext));
        }

        public void onSubscribe(Subscription subscription) {
            ReactiveStreamsCompliance$.MODULE$.requireNonNullSubscription(subscription);
            OnSubscribe onSubscribe = FanIn$OnSubscribe$.MODULE$.apply(this.id(), subscription);
            this.impl().$bang((Object)onSubscribe, this.impl().$bang$default$2((Object)onSubscribe));
        }

        public <T> SubInput<T> copy(ActorRef impl, int id) {
            return new SubInput<T>(impl, id);
        }

        public <T> ActorRef copy$default$1() {
            return this.impl();
        }

        public int copy$default$2() {
            return this.id();
        }

        public ActorRef _1() {
            return this.impl();
        }

        public int _2() {
            return this.id();
        }
    }
}

