/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.pekko.util;

import com.typesafe.sslconfig.util.NoDepsLogger;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.EventStream;
import org.apache.pekko.event.Logging;

@InternalApi
public class PekkoLoggerBridge
extends NoDepsLogger {
    private final EventStream bus;
    private final String logSource;
    private final Class<?> logClass;

    public PekkoLoggerBridge(EventStream bus, String logSource, Class<?> logClass) {
        this.bus = bus;
        this.logSource = logSource;
        this.logClass = logClass;
    }

    public PekkoLoggerBridge(EventStream bus, Class<?> clazz) {
        this(bus, clazz.getCanonicalName(), clazz);
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public void debug(String msg) {
        this.bus.publish((Object)Logging.Debug$.MODULE$.apply(this.logSource, this.logClass, (Object)msg));
    }

    public void info(String msg) {
        this.bus.publish((Object)Logging.Info$.MODULE$.apply(this.logSource, this.logClass, (Object)msg));
    }

    public void warn(String msg) {
        this.bus.publish((Object)Logging.Warning$.MODULE$.apply(this.logSource, this.logClass, (Object)msg));
    }

    public void error(String msg) {
        this.bus.publish((Object)Logging.Error$.MODULE$.apply(this.logSource, this.logClass, (Object)msg));
    }

    public void error(String msg, Throwable throwable) {
        this.bus.publish((Object)Logging.Error$.MODULE$.apply(this.logSource, this.logClass, (Object)msg));
    }
}

