/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.io;

import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pekko.NotUsed;
import org.apache.pekko.NotUsed$;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.impl.io.TcpConnectionStage;
import org.apache.pekko.stream.impl.io.TcpConnectionStage$Inbound$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.util.ByteString;
import scala.Function0;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxedUnit;

@InternalApi
public class IncomingConnectionStage
extends GraphStage<FlowShape<ByteString, ByteString>> {
    private final ActorRef connection;
    private final InetSocketAddress remoteAddress;
    private final boolean halfClose;
    private final Function0<BoxedUnit> registerCallback;
    private final AtomicBoolean hasBeenCreated;
    private final Inlet bytesIn;
    private final Outlet bytesOut;
    private final FlowShape shape;

    public IncomingConnectionStage(ActorRef connection, InetSocketAddress remoteAddress, boolean halfClose, Function0<BoxedUnit> registerCallback) {
        this.connection = connection;
        this.remoteAddress = remoteAddress;
        this.halfClose = halfClose;
        this.registerCallback = registerCallback;
        this.hasBeenCreated = new AtomicBoolean(false);
        this.bytesIn = Inlet$.MODULE$.apply("IncomingTCP.in");
        this.bytesOut = Outlet$.MODULE$.apply("IncomingTCP.out");
        this.shape = FlowShape$.MODULE$.apply(this.bytesIn(), this.bytesOut());
    }

    public Inlet<ByteString> bytesIn() {
        return this.bytesIn;
    }

    public Outlet<ByteString> bytesOut() {
        return this.bytesOut;
    }

    @Override
    public Attributes initialAttributes() {
        return Attributes$.MODULE$.name("IncomingConnection");
    }

    @Override
    public FlowShape<ByteString, ByteString> shape() {
        return this.shape;
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        throw new UnsupportedOperationException("Not used");
    }

    @Override
    public Tuple2<GraphStageLogic, NotUsed> createLogicAndMaterializedValue(Attributes inheritedAttributes, Materializer eagerMaterializer) {
        if (this.hasBeenCreated.get()) {
            throw new IllegalStateException("Cannot materialize an incoming connection Flow twice.");
        }
        this.hasBeenCreated.set(true);
        return Tuple2$.MODULE$.apply((Object)new TcpConnectionStage.TcpStreamLogic((FlowShape<ByteString, ByteString>)this.shape(), TcpConnectionStage$Inbound$.MODULE$.apply(this.connection, this.halfClose, this.registerCallback), inheritedAttributes, this.remoteAddress, eagerMaterializer), (Object)NotUsed$.MODULE$);
    }

    public String toString() {
        return new StringBuilder(10).append("TCP-from(").append(this.remoteAddress).append(")").toString();
    }
}

