/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import java.io.Serializable;
import org.apache.pekko.stream.impl.ReactiveStreamsCompliance;
import org.apache.pekko.stream.impl.ReactiveStreamsCompliance$;
import org.apache.pekko.stream.impl.ResizableMultiReaderRingBuffer;
import org.apache.pekko.stream.impl.SubscriberManagement$;
import org.apache.pekko.stream.impl.SubscriberManagement$Completed$;
import org.apache.pekko.stream.impl.SubscriberManagement$ErrorCompleted$;
import org.apache.pekko.stream.impl.SubscriberManagement$NotReached$;
import org.apache.pekko.stream.impl.SubscriptionWithCursor;
import org.reactivestreams.Subscriber;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Product;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public interface SubscriberManagement<T>
extends ResizableMultiReaderRingBuffer.Cursors {
    public static ErrorCompleted ShutDown() {
        return SubscriberManagement$.MODULE$.ShutDown();
    }

    public static void $init$(SubscriberManagement $this) {
        $this.org$apache$pekko$stream$impl$SubscriberManagement$_setter_$org$apache$pekko$stream$impl$SubscriberManagement$$buffer_$eq(new ResizableMultiReaderRingBuffer($this.initialBufferSize(), $this.maxBufferSize(), $this));
        $this.org$apache$pekko$stream$impl$SubscriberManagement$$subscriptions_$eq((List<SubscriptionWithCursor>)scala.package$.MODULE$.Nil());
        $this.org$apache$pekko$stream$impl$SubscriberManagement$$pendingFromUpstream_$eq(0L);
        $this.org$apache$pekko$stream$impl$SubscriberManagement$$endOfStream_$eq(SubscriberManagement$NotReached$.MODULE$);
    }

    public int initialBufferSize();

    public int maxBufferSize();

    public void requestFromUpstream(long var1);

    public void cancelUpstream();

    public void shutdown(boolean var1);

    public SubscriptionWithCursor createSubscription(Subscriber<? super T> var1);

    public ResizableMultiReaderRingBuffer<T> org$apache$pekko$stream$impl$SubscriberManagement$$buffer();

    public void org$apache$pekko$stream$impl$SubscriberManagement$_setter_$org$apache$pekko$stream$impl$SubscriberManagement$$buffer_$eq(ResizableMultiReaderRingBuffer var1);

    public static String bufferDebug$(SubscriberManagement $this) {
        return $this.bufferDebug();
    }

    default public String bufferDebug() {
        return this.org$apache$pekko$stream$impl$SubscriberManagement$$buffer().toString();
    }

    public List<SubscriptionWithCursor> org$apache$pekko$stream$impl$SubscriberManagement$$subscriptions();

    public void org$apache$pekko$stream$impl$SubscriberManagement$$subscriptions_$eq(List<SubscriptionWithCursor> var1);

    public long org$apache$pekko$stream$impl$SubscriberManagement$$pendingFromUpstream();

    public void org$apache$pekko$stream$impl$SubscriberManagement$$pendingFromUpstream_$eq(long var1);

    public EndOfStream org$apache$pekko$stream$impl$SubscriberManagement$$endOfStream();

    public void org$apache$pekko$stream$impl$SubscriberManagement$$endOfStream_$eq(EndOfStream var1);

    public static List cursors$(SubscriberManagement $this) {
        return $this.cursors();
    }

    @Override
    default public List<ResizableMultiReaderRingBuffer.Cursor> cursors() {
        return this.org$apache$pekko$stream$impl$SubscriberManagement$$subscriptions();
    }

    public static void moreRequested$(SubscriberManagement $this, SubscriptionWithCursor subscription, long elements) {
        $this.moreRequested(subscription, elements);
    }

    default public void moreRequested(SubscriptionWithCursor subscription, long elements) {
        if (subscription.active()) {
            if (elements < 1L) {
                try {
                    ReactiveStreamsCompliance$.MODULE$.tryOnError(subscription.subscriber(), ReactiveStreamsCompliance$.MODULE$.numberOfElementsInRequestMustBePositiveException());
                }
                finally {
                    this.unregisterSubscriptionInternal(subscription);
                }
                return;
            }
            EndOfStream endOfStream = this.org$apache$pekko$stream$impl$SubscriberManagement$$endOfStream();
            if (SubscriberManagement$NotReached$.MODULE$.equals(endOfStream) || SubscriberManagement$Completed$.MODULE$.equals(endOfStream)) {
                EndOfStream eos = endOfStream;
                long d = subscription.totalDemand() + elements;
                long demand = d < 1L ? Long.MAX_VALUE : d;
                subscription.totalDemand_$eq(demand);
                long l = this.dispatchFromBufferAndReturnRemainingRequested$1(subscription, demand, eos);
                if (Long.MIN_VALUE == l) {
                    eos.apply(subscription.subscriber());
                    this.unregisterSubscriptionInternal(subscription);
                    return;
                }
                long x = l;
                subscription.totalDemand_$eq(x);
                this.requestFromUpstreamIfRequired();
                return;
            }
            if (endOfStream instanceof ErrorCompleted) {
                ErrorCompleted errorCompleted = SubscriberManagement$ErrorCompleted$.MODULE$.unapply((ErrorCompleted)endOfStream);
                Throwable throwable = errorCompleted._1();
                return;
            }
            throw new MatchError((Object)endOfStream);
        }
    }

    private void requestFromUpstreamIfRequired() {
        int desired = (int)Math.min(Integer.MAX_VALUE, Math.min(SubscriberManagement.maxRequested$1(this.org$apache$pekko$stream$impl$SubscriberManagement$$subscriptions(), SubscriberManagement.maxRequested$default$2$1()), Int$.MODULE$.int2long(this.org$apache$pekko$stream$impl$SubscriberManagement$$buffer().maxAvailable())) - this.org$apache$pekko$stream$impl$SubscriberManagement$$pendingFromUpstream());
        if (desired > 0) {
            this.org$apache$pekko$stream$impl$SubscriberManagement$$pendingFromUpstream_$eq(this.org$apache$pekko$stream$impl$SubscriberManagement$$pendingFromUpstream() + (long)desired);
            this.requestFromUpstream(Int$.MODULE$.int2long(desired));
            return;
        }
    }

    public static void pushToDownstream$(SubscriberManagement $this, Object value) {
        $this.pushToDownstream(value);
    }

    default public void pushToDownstream(T value) {
        EndOfStream endOfStream = this.org$apache$pekko$stream$impl$SubscriberManagement$$endOfStream();
        if (SubscriberManagement$NotReached$.MODULE$.equals(endOfStream)) {
            this.org$apache$pekko$stream$impl$SubscriberManagement$$pendingFromUpstream_$eq(this.org$apache$pekko$stream$impl$SubscriberManagement$$pendingFromUpstream() - 1L);
            if (!this.org$apache$pekko$stream$impl$SubscriberManagement$$buffer().write(value)) {
                throw new IllegalStateException("Output buffer overflow");
            }
            if (this.dispatch$1(this.org$apache$pekko$stream$impl$SubscriberManagement$$subscriptions(), SubscriberManagement.dispatch$default$2$1())) {
                this.requestFromUpstreamIfRequired();
                return;
            }
            return;
        }
        throw new IllegalStateException("pushToDownStream(...) after completeDownstream() or abortDownstream(...)");
    }

    public static void completeDownstream$(SubscriberManagement $this) {
        $this.completeDownstream();
    }

    default public void completeDownstream() {
        if (this.org$apache$pekko$stream$impl$SubscriberManagement$$endOfStream() == SubscriberManagement$NotReached$.MODULE$) {
            this.org$apache$pekko$stream$impl$SubscriberManagement$$endOfStream_$eq(SubscriberManagement$Completed$.MODULE$);
            this.org$apache$pekko$stream$impl$SubscriberManagement$$subscriptions_$eq((List<SubscriptionWithCursor>)this.completeDoneSubscriptions$1(this.org$apache$pekko$stream$impl$SubscriberManagement$$subscriptions(), SubscriberManagement.completeDoneSubscriptions$default$2$1()));
            if (this.org$apache$pekko$stream$impl$SubscriberManagement$$subscriptions().isEmpty()) {
                this.shutdown(true);
                return;
            }
            return;
        }
    }

    public static void abortDownstream$(SubscriberManagement $this, Throwable cause) {
        $this.abortDownstream(cause);
    }

    default public void abortDownstream(Throwable cause) {
        this.org$apache$pekko$stream$impl$SubscriberManagement$$endOfStream_$eq(SubscriberManagement$ErrorCompleted$.MODULE$.apply(cause));
        this.org$apache$pekko$stream$impl$SubscriberManagement$$subscriptions().foreach((Function1)(JProcedure1 & Serializable)s -> this.org$apache$pekko$stream$impl$SubscriberManagement$$endOfStream().apply(s.subscriber()));
        this.org$apache$pekko$stream$impl$SubscriberManagement$$subscriptions_$eq((List<SubscriptionWithCursor>)scala.package$.MODULE$.Nil());
    }

    public static void registerSubscriber$(SubscriberManagement $this, Subscriber subscriber) {
        $this.registerSubscriber(subscriber);
    }

    default public void registerSubscriber(Subscriber<? super T> subscriber) {
        EndOfStream endOfStream = this.org$apache$pekko$stream$impl$SubscriberManagement$$endOfStream();
        if (SubscriberManagement$NotReached$.MODULE$.equals(endOfStream)) {
            if (this.org$apache$pekko$stream$impl$SubscriberManagement$$subscriptions().exists((Function1 & Serializable)_$1 -> {
                Subscriber subscriber = _$1.subscriber();
                Subscriber subscriber2 = subscriber;
                return !(subscriber != null ? !subscriber.equals(subscriber2) : subscriber2 != null);
            })) {
                ReactiveStreamsCompliance$.MODULE$.rejectDuplicateSubscriber(subscriber);
                return;
            }
            this.addSubscription(subscriber);
            return;
        }
        if (SubscriberManagement$Completed$.MODULE$.equals(endOfStream) && this.org$apache$pekko$stream$impl$SubscriberManagement$$buffer().nonEmpty()) {
            this.addSubscription(subscriber);
            return;
        }
        EndOfStream eos = endOfStream;
        eos.apply(subscriber);
    }

    private void addSubscription(Subscriber<? super T> subscriber) {
        SubscriptionWithCursor newSubscription = this.createSubscription(subscriber);
        this.org$apache$pekko$stream$impl$SubscriberManagement$$subscriptions_$eq((List<SubscriptionWithCursor>)this.org$apache$pekko$stream$impl$SubscriberManagement$$subscriptions().$colon$colon((Object)newSubscription));
        this.org$apache$pekko$stream$impl$SubscriberManagement$$buffer().initCursor(newSubscription);
        try {
            ReactiveStreamsCompliance$.MODULE$.tryOnSubscribe(subscriber, newSubscription);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ReactiveStreamsCompliance.SpecViolation) {
                this.unregisterSubscriptionInternal(newSubscription);
            }
            throw throwable;
        }
    }

    public static void unregisterSubscription$(SubscriberManagement $this, SubscriptionWithCursor subscription) {
        $this.unregisterSubscription(subscription);
    }

    default public void unregisterSubscription(SubscriptionWithCursor subscription) {
        this.unregisterSubscriptionInternal(subscription);
    }

    private void unregisterSubscriptionInternal(SubscriptionWithCursor subscription) {
        if (subscription.active()) {
            this.org$apache$pekko$stream$impl$SubscriberManagement$$subscriptions_$eq((List<SubscriptionWithCursor>)SubscriberManagement.removeFrom$1(subscription, this.org$apache$pekko$stream$impl$SubscriberManagement$$subscriptions(), SubscriberManagement.removeFrom$default$2$1()));
            this.org$apache$pekko$stream$impl$SubscriberManagement$$buffer().onCursorRemoved(subscription);
            subscription.active_$eq(false);
            if (this.org$apache$pekko$stream$impl$SubscriberManagement$$subscriptions().isEmpty()) {
                if (this.org$apache$pekko$stream$impl$SubscriberManagement$$endOfStream() == SubscriberManagement$NotReached$.MODULE$) {
                    this.org$apache$pekko$stream$impl$SubscriberManagement$$endOfStream_$eq(SubscriberManagement$.MODULE$.ShutDown());
                    this.cancelUpstream();
                }
                this.shutdown(false);
                return;
            }
            this.requestFromUpstreamIfRequired();
            return;
        }
    }

    private long dispatchFromBufferAndReturnRemainingRequested$1(SubscriptionWithCursor subscription$1, long requested, EndOfStream eos) {
        block7: {
            while (true) {
                boolean bl;
                if (requested == 0L) {
                    if (eos != SubscriberManagement$NotReached$.MODULE$ && this.org$apache$pekko$stream$impl$SubscriberManagement$$buffer().count(subscription$1) == 0) {
                        return Long.MIN_VALUE;
                    }
                    return 0L;
                }
                if (this.org$apache$pekko$stream$impl$SubscriberManagement$$buffer().count(subscription$1) <= 0) break block7;
                try {
                    subscription$1.dispatch(this.org$apache$pekko$stream$impl$SubscriberManagement$$buffer().read(subscription$1));
                    bl = true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof ReactiveStreamsCompliance.SpecViolation) {
                        this.unregisterSubscriptionInternal(subscription$1);
                        bl = false;
                    }
                    throw throwable;
                }
                boolean goOn = bl;
                if (!goOn) break;
                --requested;
            }
            return Long.MIN_VALUE;
        }
        if (eos != SubscriberManagement$NotReached$.MODULE$) {
            return Long.MIN_VALUE;
        }
        return requested;
    }

    private static long maxRequested$1(List remaining, long result) {
        List list;
        while ((list = remaining) instanceof .colon.colon) {
            List tail;
            .colon.colon colon2 = (.colon.colon)list;
            List list2 = colon2.next$access$1();
            SubscriptionWithCursor head = (SubscriptionWithCursor)colon2.head();
            List list3 = tail = list2;
            long l = package$.MODULE$.max(head.totalDemand(), result);
            remaining = list3;
            result = l;
        }
        return result;
    }

    private static long maxRequested$default$2$1() {
        return 0L;
    }

    private boolean dispatch$1(List remaining, boolean sent) {
        List list;
        while ((list = remaining) instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list2 = colon2.next$access$1();
            SubscriptionWithCursor head = (SubscriptionWithCursor)colon2.head();
            List tail = list2;
            if (head.totalDemand() > 0L) {
                T element = this.org$apache$pekko$stream$impl$SubscriberManagement$$buffer().read(head);
                head.dispatch(element);
                head.totalDemand_$eq(head.totalDemand() - 1L);
                List list3 = tail;
                boolean bl = true;
                remaining = list3;
                sent = bl;
                continue;
            }
            remaining = tail;
        }
        return sent;
    }

    private static boolean dispatch$default$2$1() {
        return false;
    }

    private List completeDoneSubscriptions$1(List remaining, List result) {
        List list;
        while ((list = remaining) instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list2 = colon2.next$access$1();
            SubscriptionWithCursor head = (SubscriptionWithCursor)colon2.head();
            List tail = list2;
            if (this.org$apache$pekko$stream$impl$SubscriberManagement$$buffer().count(head) == 0) {
                head.active_$eq(false);
                SubscriberManagement$Completed$.MODULE$.apply(head.subscriber());
                remaining = tail;
                continue;
            }
            List list3 = tail;
            List list4 = result.$colon$colon((Object)head);
            remaining = list3;
            result = list4;
        }
        return result;
    }

    private static List completeDoneSubscriptions$default$2$1() {
        return scala.package$.MODULE$.Nil();
    }

    private static List removeFrom$1(SubscriptionWithCursor subscription$2, List remaining, List result) {
        List list;
        while ((list = remaining) instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list2 = colon2.next$access$1();
            SubscriptionWithCursor head = (SubscriptionWithCursor)colon2.head();
            List tail = list2;
            if (head == subscription$2) {
                return result.reverse_$colon$colon$colon(tail);
            }
            List list3 = tail;
            List list4 = result.$colon$colon((Object)head);
            remaining = list3;
            result = list4;
        }
        throw new IllegalStateException("Subscription to unregister not found");
    }

    private static List removeFrom$default$2$1() {
        return scala.package$.MODULE$.Nil();
    }

    public static interface EndOfStream {
        public <T> void apply(Subscriber<T> var1);
    }

    public static final class ErrorCompleted
    implements EndOfStream,
    Product,
    Serializable {
        private final Throwable cause;

        public static ErrorCompleted fromProduct(Product product) {
            return SubscriberManagement$ErrorCompleted$.MODULE$.fromProduct(product);
        }

        public static ErrorCompleted unapply(ErrorCompleted errorCompleted) {
            return SubscriberManagement$ErrorCompleted$.MODULE$.unapply(errorCompleted);
        }

        public ErrorCompleted(Throwable cause) {
            this.cause = cause;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ErrorCompleted)) return false;
            ErrorCompleted errorCompleted = (ErrorCompleted)object;
            Throwable throwable = this.cause();
            Throwable throwable2 = errorCompleted.cause();
            if (throwable != null) {
                if (!throwable.equals(throwable2)) return false;
                return true;
            }
            if (throwable2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ErrorCompleted;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ErrorCompleted";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "cause";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Throwable cause() {
            return this.cause;
        }

        @Override
        public <T> void apply(Subscriber<T> subscriber) {
            ReactiveStreamsCompliance$.MODULE$.tryOnError(subscriber, this.cause());
        }

        public ErrorCompleted copy(Throwable cause) {
            return new ErrorCompleted(cause);
        }

        public Throwable copy$default$1() {
            return this.cause();
        }

        public Throwable _1() {
            return this.cause();
        }
    }
}

