/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import java.util.function.BiConsumer;
import java.util.stream.Collector;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.impl.CollectorState;

@InternalApi
public final class MutableCollectorState<T, R>
implements CollectorState<T, R> {
    private final Collector<T, Object, R> collector;
    private final BiConsumer<Object, T> accumulator;
    private final Object _accumulated;

    public MutableCollectorState(Collector<T, Object, R> collector, BiConsumer<Object, T> accumulator, Object _accumulated) {
        this.collector = collector;
        this.accumulator = accumulator;
        this._accumulated = _accumulated;
    }

    @Override
    public Object accumulated() {
        return this._accumulated;
    }

    @Override
    public CollectorState<T, R> update(T elem) {
        this.accumulator.accept(this._accumulated, elem);
        return this;
    }

    @Override
    public R finish() {
        return this.collector.finisher().apply(this._accumulated);
    }
}

