/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import java.io.Serializable;
import java.util.LinkedList;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.impl.Buffer;
import org.apache.pekko.stream.impl.Buffer$;
import scala.Function1;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;

@InternalApi
public final class BoundedBuffer<T>
implements Buffer<T> {
    private final int capacity;
    private Buffer<T> q;

    public BoundedBuffer(int capacity) {
        this.capacity = capacity;
        this.q = new FixedQueue(capacity, (JProcedure1 & Serializable)newBuffer -> {
            this.q = newBuffer;
        });
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int used() {
        return this.q.used();
    }

    @Override
    public boolean isFull() {
        return this.q.isFull();
    }

    @Override
    public boolean isEmpty() {
        return this.q.isEmpty();
    }

    @Override
    public boolean nonEmpty() {
        return this.q.nonEmpty();
    }

    @Override
    public void enqueue(T elem) {
        this.q.enqueue(elem);
    }

    @Override
    public T dequeue() {
        return this.q.dequeue();
    }

    @Override
    public T peek() {
        return this.q.peek();
    }

    @Override
    public void clear() {
        this.q.clear();
    }

    @Override
    public void dropHead() {
        this.q.dropHead();
    }

    @Override
    public void dropTail() {
        this.q.dropTail();
    }

    public static final class DynamicQueue<T>
    extends LinkedList<T>
    implements Buffer<T> {
        private final int capacity;

        public DynamicQueue(int capacity) {
            this.capacity = capacity;
        }

        @Override
        public int capacity() {
            return this.capacity;
        }

        @Override
        public int used() {
            return this.size();
        }

        @Override
        public boolean isFull() {
            return this.size() == this.capacity();
        }

        @Override
        public boolean nonEmpty() {
            return !this.isEmpty();
        }

        @Override
        public void enqueue(T elem) {
            this.add(elem);
        }

        @Override
        public T dequeue() {
            return (T)this.remove();
        }

        @Override
        public void dropHead() {
            this.remove();
        }

        @Override
        public void dropTail() {
            this.removeLast();
        }
    }

    public static final class FixedQueue<T>
    implements Buffer<T> {
        private final int capacity;
        private final Function1<Buffer<T>, BoxedUnit> switchBuffer;
        private final Object[] queue;
        private int head;
        private int tail;

        public FixedQueue(int capacity, Function1<Buffer<T>, BoxedUnit> switchBuffer) {
            this.capacity = capacity;
            this.switchBuffer = switchBuffer;
            this.queue = new Object[Buffer$.MODULE$.FixedQueueSize()];
            this.head = 0;
            this.tail = 0;
        }

        @Override
        public int capacity() {
            return this.capacity;
        }

        @Override
        public int used() {
            return this.tail - this.head;
        }

        @Override
        public boolean isFull() {
            return this.used() == this.capacity();
        }

        @Override
        public boolean isEmpty() {
            return this.tail == this.head;
        }

        @Override
        public boolean nonEmpty() {
            return this.tail != this.head;
        }

        @Override
        public void enqueue(T elem) {
            if (this.tail - this.head == Buffer$.MODULE$.FixedQueueSize()) {
                DynamicQueue<T> queue = new DynamicQueue<T>(this.capacity());
                while (this.nonEmpty()) {
                    queue.enqueue(this.dequeue());
                }
                this.switchBuffer.apply(queue);
                queue.enqueue(elem);
                return;
            }
            this.queue[this.tail & Buffer$.MODULE$.FixedQueueMask()] = elem;
            ++this.tail;
        }

        @Override
        public T dequeue() {
            int pos = this.head & Buffer$.MODULE$.FixedQueueMask();
            Object ret = this.queue[pos];
            this.queue[pos] = null;
            ++this.head;
            return (T)ret;
        }

        @Override
        public T peek() {
            if (this.tail == this.head) {
                return null;
            }
            return (T)this.queue[this.head & Buffer$.MODULE$.FixedQueueMask()];
        }

        @Override
        public void clear() {
            while (this.nonEmpty()) {
                this.dequeue();
            }
        }

        @Override
        public void dropHead() {
            this.dequeue();
        }

        @Override
        public void dropTail() {
            --this.tail;
            this.queue[this.tail & Buffer$.MODULE$.FixedQueueMask()] = null;
        }
    }
}

