/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.testkit;

import java.io.Serializable;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.MaterializationContext;
import org.apache.pekko.stream.SinkShape;
import org.apache.pekko.stream.SourceShape;
import org.apache.pekko.stream.SubscriptionWithCancelException;
import org.apache.pekko.stream.impl.SinkModule;
import org.apache.pekko.stream.impl.SourceModule;
import org.apache.pekko.stream.testkit.StreamTestKit$CompletedSubscription$;
import org.apache.pekko.stream.testkit.StreamTestKit$FailedSubscription$;
import org.apache.pekko.stream.testkit.StreamTestKit$PublisherProbeSubscription$;
import org.apache.pekko.stream.testkit.TestPublisher;
import org.apache.pekko.stream.testkit.TestPublisher$;
import org.apache.pekko.stream.testkit.TestPublisher$CancelSubscription$;
import org.apache.pekko.stream.testkit.TestPublisher$RequestMore$;
import org.apache.pekko.stream.testkit.TestSubscriber;
import org.apache.pekko.stream.testkit.TestSubscriber$;
import org.apache.pekko.testkit.TestProbe;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import scala.Function1;
import scala.PartialFunction;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class StreamTestKit {

    public static final class CompletedSubscription<T>
    implements Subscription,
    Product,
    Serializable {
        private final Subscriber subscriber;

        public static <T> CompletedSubscription<T> apply(Subscriber<T> subscriber) {
            return StreamTestKit$CompletedSubscription$.MODULE$.apply(subscriber);
        }

        public static CompletedSubscription<?> fromProduct(Product product) {
            return StreamTestKit$CompletedSubscription$.MODULE$.fromProduct(product);
        }

        public static <T> CompletedSubscription<T> unapply(CompletedSubscription<T> completedSubscription) {
            return StreamTestKit$CompletedSubscription$.MODULE$.unapply(completedSubscription);
        }

        public CompletedSubscription(Subscriber<T> subscriber) {
            this.subscriber = subscriber;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CompletedSubscription)) return false;
            CompletedSubscription completedSubscription = (CompletedSubscription)object;
            Subscriber<T> subscriber = this.subscriber();
            Subscriber<T> subscriber2 = completedSubscription.subscriber();
            if (subscriber != null) {
                if (!subscriber.equals(subscriber2)) return false;
                return true;
            }
            if (subscriber2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CompletedSubscription;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "CompletedSubscription";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "subscriber";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Subscriber<T> subscriber() {
            return this.subscriber;
        }

        public void request(long elements) {
            this.subscriber().onComplete();
        }

        public void cancel() {
        }

        public <T> CompletedSubscription<T> copy(Subscriber<T> subscriber) {
            return new CompletedSubscription<T>(subscriber);
        }

        public <T> Subscriber<T> copy$default$1() {
            return this.subscriber();
        }

        public Subscriber<T> _1() {
            return this.subscriber();
        }
    }

    public static final class FailedSubscription<T>
    implements Subscription,
    Product,
    Serializable {
        private final Subscriber subscriber;
        private final Throwable cause;

        public static <T> FailedSubscription<T> apply(Subscriber<T> subscriber, Throwable throwable) {
            return StreamTestKit$FailedSubscription$.MODULE$.apply(subscriber, throwable);
        }

        public static FailedSubscription<?> fromProduct(Product product) {
            return StreamTestKit$FailedSubscription$.MODULE$.fromProduct(product);
        }

        public static <T> FailedSubscription<T> unapply(FailedSubscription<T> failedSubscription) {
            return StreamTestKit$FailedSubscription$.MODULE$.unapply(failedSubscription);
        }

        public FailedSubscription(Subscriber<T> subscriber, Throwable cause) {
            this.subscriber = subscriber;
            this.cause = cause;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FailedSubscription)) return false;
            FailedSubscription failedSubscription = (FailedSubscription)object;
            Subscriber<T> subscriber = this.subscriber();
            Subscriber<T> subscriber2 = failedSubscription.subscriber();
            if (subscriber == null) {
                if (subscriber2 != null) {
                    return false;
                }
            } else if (!subscriber.equals(subscriber2)) return false;
            Throwable throwable = this.cause();
            Throwable throwable2 = failedSubscription.cause();
            if (throwable == null) {
                if (throwable2 == null) return true;
                return false;
            } else {
                if (!throwable.equals(throwable2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof FailedSubscription;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "FailedSubscription";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "subscriber";
            }
            if (1 == n2) {
                return "cause";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Subscriber<T> subscriber() {
            return this.subscriber;
        }

        public Throwable cause() {
            return this.cause;
        }

        public void request(long elements) {
            this.subscriber().onError(this.cause());
        }

        public void cancel() {
        }

        public <T> FailedSubscription<T> copy(Subscriber<T> subscriber, Throwable cause) {
            return new FailedSubscription<T>(subscriber, cause);
        }

        public <T> Subscriber<T> copy$default$1() {
            return this.subscriber();
        }

        public <T> Throwable copy$default$2() {
            return this.cause();
        }

        public Subscriber<T> _1() {
            return this.subscriber();
        }

        public Throwable _2() {
            return this.cause();
        }
    }

    public static final class ProbeSink<T>
    extends SinkModule<T, TestSubscriber.Probe<T>> {
        private final Attributes attributes;
        private final ActorSystem system;

        public ProbeSink(Attributes attributes, SinkShape<T> shape, ActorSystem system) {
            this.attributes = attributes;
            this.system = system;
            super(shape);
        }

        public Attributes attributes() {
            return this.attributes;
        }

        private SinkShape<T> shape$accessor() {
            return super.shape();
        }

        public Tuple2<Object, TestSubscriber.Probe<T>> create(MaterializationContext context) {
            TestSubscriber.Probe probe = TestSubscriber$.MODULE$.probe(this.system);
            return Tuple2$.MODULE$.apply(probe, probe);
        }

        public SinkModule<T, TestSubscriber.Probe<T>> withAttributes(Attributes attr) {
            return new ProbeSink<T>(attr, this.amendShape(attr), this.system);
        }
    }

    public static final class ProbeSource<T>
    extends SourceModule<T, TestPublisher.Probe<T>> {
        private final Attributes attributes;
        private final ActorSystem system;

        public ProbeSource(Attributes attributes, SourceShape<T> shape, ActorSystem system) {
            this.attributes = attributes;
            this.system = system;
            super(shape);
        }

        public Attributes attributes() {
            return this.attributes;
        }

        private SourceShape<T> shape$accessor() {
            return super.shape();
        }

        public Tuple2<Publisher<T>, TestPublisher.Probe<T>> create(MaterializationContext context) {
            TestPublisher.Probe probe = TestPublisher$.MODULE$.probe(TestPublisher$.MODULE$.probe$default$1(), this.system);
            return Tuple2$.MODULE$.apply(probe, probe);
        }

        public SourceModule<T, TestPublisher.Probe<T>> withAttributes(Attributes attr) {
            return new ProbeSource<T>(attr, this.amendShape(attr), this.system);
        }
    }

    public static final class PublisherProbeSubscription<I>
    implements SubscriptionWithCancelException,
    Product,
    Serializable {
        private final Subscriber subscriber;
        private final TestProbe publisherProbe;

        public static <I> PublisherProbeSubscription<I> apply(Subscriber<? super I> subscriber, TestProbe testProbe) {
            return StreamTestKit$PublisherProbeSubscription$.MODULE$.apply(subscriber, testProbe);
        }

        public static PublisherProbeSubscription<?> fromProduct(Product product) {
            return StreamTestKit$PublisherProbeSubscription$.MODULE$.fromProduct(product);
        }

        public static <I> PublisherProbeSubscription<I> unapply(PublisherProbeSubscription<I> publisherProbeSubscription) {
            return StreamTestKit$PublisherProbeSubscription$.MODULE$.unapply(publisherProbeSubscription);
        }

        public PublisherProbeSubscription(Subscriber<? super I> subscriber, TestProbe publisherProbe) {
            this.subscriber = subscriber;
            this.publisherProbe = publisherProbe;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PublisherProbeSubscription)) return false;
            PublisherProbeSubscription publisherProbeSubscription = (PublisherProbeSubscription)object;
            Subscriber<I> subscriber = this.subscriber();
            Subscriber<I> subscriber2 = publisherProbeSubscription.subscriber();
            if (subscriber == null) {
                if (subscriber2 != null) {
                    return false;
                }
            } else if (!subscriber.equals(subscriber2)) return false;
            TestProbe testProbe = this.publisherProbe();
            TestProbe testProbe2 = publisherProbeSubscription.publisherProbe();
            if (testProbe == null) {
                if (testProbe2 == null) return true;
                return false;
            } else {
                if (!testProbe.equals(testProbe2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PublisherProbeSubscription;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "PublisherProbeSubscription";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "subscriber";
            }
            if (1 == n2) {
                return "publisherProbe";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Subscriber<? super I> subscriber() {
            return this.subscriber;
        }

        public TestProbe publisherProbe() {
            return this.publisherProbe;
        }

        public void request(long elements) {
            ActorRef actorRef = this.publisherProbe().ref();
            TestPublisher.RequestMore requestMore = TestPublisher$RequestMore$.MODULE$.apply((Subscription)this, elements);
            actorRef.$bang((Object)requestMore, actorRef.$bang$default$2((Object)requestMore));
        }

        public void cancel(Throwable cause) {
            ActorRef actorRef = this.publisherProbe().ref();
            TestPublisher.CancelSubscription cancelSubscription = TestPublisher$CancelSubscription$.MODULE$.apply((Subscription)this, cause);
            actorRef.$bang((Object)cancelSubscription, actorRef.$bang$default$2((Object)cancelSubscription));
        }

        public void expectRequest(long n) {
            this.publisherProbe().expectMsg((Object)TestPublisher$RequestMore$.MODULE$.apply((Subscription)this, n));
        }

        public long expectRequest() {
            return BoxesRunTime.unboxToLong((Object)this.publisherProbe().expectMsgPF(this.publisherProbe().expectMsgPF$default$1(), "expecting request() signal", (PartialFunction)new Serializable(this){
                private final /* synthetic */ PublisherProbeSubscription $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Object x) {
                    Object object = x;
                    if (object instanceof TestPublisher.RequestMore) {
                        TestPublisher.RequestMore requestMore = TestPublisher$RequestMore$.MODULE$.unapply((TestPublisher.RequestMore)object);
                        Subscription subscription = requestMore._1();
                        long l = requestMore._2();
                        Subscription sub = subscription;
                        long n = l;
                        if (sub == this.$outer) {
                            return true;
                        }
                    }
                    return false;
                }

                public final Object applyOrElse(Object x, Function1 function1) {
                    Object object = x;
                    if (object instanceof TestPublisher.RequestMore) {
                        TestPublisher.RequestMore requestMore = TestPublisher$RequestMore$.MODULE$.unapply((TestPublisher.RequestMore)object);
                        Subscription subscription = requestMore._1();
                        long l = requestMore._2();
                        Subscription sub = subscription;
                        long n = l;
                        if (sub == this.$outer) {
                            return BoxesRunTime.boxToLong((long)n);
                        }
                    }
                    return function1.apply(x);
                }
            }));
        }

        public Throwable expectCancellation() {
            return (Throwable)this.publisherProbe().fishForSpecificMessage(this.publisherProbe().fishForSpecificMessage$default$1(), "Expecting cancellation", (PartialFunction)new Serializable(this){
                private final /* synthetic */ PublisherProbeSubscription $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Object x) {
                    Object object = x;
                    if (object instanceof TestPublisher.CancelSubscription) {
                        TestPublisher.CancelSubscription cancelSubscription = TestPublisher$CancelSubscription$.MODULE$.unapply((TestPublisher.CancelSubscription)object);
                        Subscription subscription = cancelSubscription._1();
                        Throwable throwable = cancelSubscription._2();
                        Subscription sub = subscription;
                        Throwable cause = throwable;
                        if (sub == this.$outer) {
                            return true;
                        }
                    }
                    return false;
                }

                public final Object applyOrElse(Object x, Function1 function1) {
                    Object object = x;
                    if (object instanceof TestPublisher.CancelSubscription) {
                        TestPublisher.CancelSubscription cancelSubscription = TestPublisher$CancelSubscription$.MODULE$.unapply((TestPublisher.CancelSubscription)object);
                        Subscription subscription = cancelSubscription._1();
                        Throwable throwable = cancelSubscription._2();
                        Subscription sub = subscription;
                        Throwable cause = throwable;
                        if (sub == this.$outer) {
                            return cause;
                        }
                    }
                    return function1.apply(x);
                }
            });
        }

        public void sendNext(I element) {
            this.subscriber().onNext(element);
        }

        public void sendComplete() {
            this.subscriber().onComplete();
        }

        public void sendError(Throwable cause) {
            this.subscriber().onError(cause);
        }

        public void sendOnSubscribe() {
            this.subscriber().onSubscribe((Subscription)this);
        }

        public <I> PublisherProbeSubscription<I> copy(Subscriber<? super I> subscriber, TestProbe publisherProbe) {
            return new PublisherProbeSubscription<I>(subscriber, publisherProbe);
        }

        public <I> Subscriber<? super I> copy$default$1() {
            return this.subscriber();
        }

        public <I> TestProbe copy$default$2() {
            return this.publisherProbe();
        }

        public Subscriber<? super I> _1() {
            return this.subscriber();
        }

        public TestProbe _2() {
            return this.publisherProbe();
        }
    }
}

