/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.event.slf4j;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.dispatch.RequiresMessageQueue;
import org.apache.pekko.event.LogMarker;
import org.apache.pekko.event.LoggerMessageQueueSemantics;
import org.apache.pekko.event.Logging;
import org.apache.pekko.event.LoggingBus;
import org.apache.pekko.event.slf4j.Logger$;
import org.apache.pekko.event.slf4j.SLF4JLogging;
import org.apache.pekko.event.slf4j.Slf4jLogMarker;
import org.apache.pekko.util.Helpers$;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class Slf4jLogger
implements Actor,
SLF4JLogging,
RequiresMessageQueue<LoggerMessageQueueSemantics> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Slf4jLogger.class.getDeclaredField("log$lzy1"));
    private ActorContext context;
    private ActorRef self;
    private volatile transient Object log$lzy1;
    private final String mdcThreadAttributeName;
    private final String mdcActorSystemAttributeName;
    private final String mdcPekkoSourceAttributeName;
    private final String mdcPekkoTimestamp;
    private final String mdcPekkoAddressAttributeName;
    private final String mdcPekkoUidAttributeName;
    private final String pekkoUid;

    public Slf4jLogger() {
        Actor.$init$((Actor)this);
        SLF4JLogging.$init$(this);
        this.mdcThreadAttributeName = "sourceThread";
        this.mdcActorSystemAttributeName = "sourceActorSystem";
        this.mdcPekkoSourceAttributeName = "pekkoSource";
        this.mdcPekkoTimestamp = "pekkoTimestamp";
        this.mdcPekkoAddressAttributeName = "pekkoAddress";
        this.mdcPekkoUidAttributeName = "pekkoUid";
        this.pekkoUid = BoxesRunTime.boxToLong((long)((ExtendedActorSystem)this.context().system()).uid()).toString();
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    @Override
    public Logger log() {
        Object object = this.log$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = SLF4JLogging.log$(this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String mdcThreadAttributeName() {
        return this.mdcThreadAttributeName;
    }

    public String mdcActorSystemAttributeName() {
        return this.mdcActorSystemAttributeName;
    }

    public String mdcPekkoSourceAttributeName() {
        return this.mdcPekkoSourceAttributeName;
    }

    public String mdcPekkoTimestamp() {
        return this.mdcPekkoTimestamp;
    }

    public String mdcPekkoAddressAttributeName() {
        return this.mdcPekkoAddressAttributeName;
    }

    public String mdcPekkoUidAttributeName() {
        return this.mdcPekkoUidAttributeName;
    }

    private String pekkoAddress() {
        return ((ExtendedActorSystem)this.context().system()).provider().addressString();
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ Slf4jLogger $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof Logging.Error) {
                    Logging.Error error = (Logging.Error)object;
                    Logging.Error error2 = Logging.Error$.MODULE$.unapply(error);
                    Throwable throwable = error2._1();
                    String string = error2._2();
                    Class clazz = error2._3();
                    Object object2 = error2._4();
                    Throwable cause = throwable;
                    String logSource = string;
                    Class logClass = clazz;
                    Object message = object2;
                    Logging.Error event = error;
                    return true;
                }
                if (object instanceof Logging.Warning) {
                    Logging.Warning warning = (Logging.Warning)object;
                    Logging.Warning warning2 = Logging.Warning$.MODULE$.unapply(warning);
                    String string = warning2._1();
                    Class clazz = warning2._2();
                    Object object3 = warning2._3();
                    String logSource = string;
                    Class logClass = clazz;
                    Object message = object3;
                    Logging.Warning event = warning;
                    return true;
                }
                if (object instanceof Logging.Info) {
                    Logging.Info info = (Logging.Info)object;
                    Logging.Info info2 = Logging.Info$.MODULE$.unapply(info);
                    String string = info2._1();
                    Class clazz = info2._2();
                    Object object4 = info2._3();
                    String logSource = string;
                    Class logClass = clazz;
                    Object message = object4;
                    Logging.Info event = info;
                    return true;
                }
                if (object instanceof Logging.Debug) {
                    Logging.Debug debug = (Logging.Debug)object;
                    Logging.Debug debug2 = Logging.Debug$.MODULE$.unapply(debug);
                    String string = debug2._1();
                    Class clazz = debug2._2();
                    Object object5 = debug2._3();
                    String logSource = string;
                    Class logClass = clazz;
                    Object message = object5;
                    Logging.Debug event = debug;
                    return true;
                }
                if (object instanceof Logging.InitializeLogger) {
                    Logging.InitializeLogger initializeLogger = Logging.InitializeLogger$.MODULE$.unapply((Logging.InitializeLogger)object);
                    LoggingBus loggingBus = initializeLogger._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof Logging.Error) {
                    Logging.Error error = (Logging.Error)object;
                    Logging.Error error2 = Logging.Error$.MODULE$.unapply(error);
                    Throwable throwable = error2._1();
                    String string = error2._2();
                    Class clazz = error2._3();
                    Object object2 = error2._4();
                    Throwable cause = throwable;
                    String logSource = string;
                    Class logClass = clazz;
                    Object message = object2;
                    Logging.Error event = error;
                    this.$outer.withMdc(logSource, (Logging.LogEvent)event, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                        this.applyOrElse$$anonfun$1(message, logClass, logSource, cause, event);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Logging.Warning) {
                    Logging.Warning warning = (Logging.Warning)object;
                    Logging.Warning warning2 = Logging.Warning$.MODULE$.unapply(warning);
                    String string = warning2._1();
                    Class clazz = warning2._2();
                    Object object3 = warning2._3();
                    String logSource = string;
                    Class logClass = clazz;
                    Object message = object3;
                    Logging.Warning event = warning;
                    this.$outer.withMdc(logSource, (Logging.LogEvent)event, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                        this.applyOrElse$$anonfun$2(message, logClass, logSource, event);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Logging.Info) {
                    Logging.Info info = (Logging.Info)object;
                    Logging.Info info2 = Logging.Info$.MODULE$.unapply(info);
                    String string = info2._1();
                    Class clazz = info2._2();
                    Object object4 = info2._3();
                    String logSource = string;
                    Class logClass = clazz;
                    Object message = object4;
                    Logging.Info event = info;
                    this.$outer.withMdc(logSource, (Logging.LogEvent)event, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                        this.applyOrElse$$anonfun$3(message, logClass, logSource, event);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Logging.Debug) {
                    Logging.Debug debug = (Logging.Debug)object;
                    Logging.Debug debug2 = Logging.Debug$.MODULE$.unapply(debug);
                    String string = debug2._1();
                    Class clazz = debug2._2();
                    Object object5 = debug2._3();
                    String logSource = string;
                    Class logClass = clazz;
                    Object message = object5;
                    Logging.Debug event = debug;
                    this.$outer.withMdc(logSource, (Logging.LogEvent)event, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                        this.applyOrElse$$anonfun$4(message, logClass, logSource, event);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Logging.InitializeLogger) {
                    Logging.InitializeLogger initializeLogger = Logging.InitializeLogger$.MODULE$.unapply((Logging.InitializeLogger)object);
                    LoggingBus loggingBus = initializeLogger._1();
                    this.$outer.log().info("Slf4jLogger started");
                    this.$outer.sender().$bang((Object)Logging.LoggerInitialized$.MODULE$, this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            private final void applyOrElse$$anonfun$1(Object message$1, Class logClass$1, String logSource$1, Throwable cause$1, Logging.Error event$1) {
                Throwable throwable = cause$1;
                if (Logging.Error$.NoCause$.MODULE$.equals(throwable) || throwable == null) {
                    Logger$.MODULE$.apply(logClass$1, logSource$1).error(this.$outer.org$apache$pekko$event$slf4j$Slf4jLogger$$markerIfPresent((Logging.LogEvent)event$1), message$1 != null ? message$1.toString() : null);
                    return;
                }
                Logger$.MODULE$.apply(logClass$1, logSource$1).error(this.$outer.org$apache$pekko$event$slf4j$Slf4jLogger$$markerIfPresent((Logging.LogEvent)event$1), message$1 != null ? message$1.toString() : cause$1.getLocalizedMessage(), cause$1);
            }

            private final void applyOrElse$$anonfun$2(Object message$2, Class logClass$2, String logSource$2, Logging.Warning event$2) {
                Logging.Warning warning = event$2;
                if (warning instanceof Logging.LogEventWithCause) {
                    Logging.Warning e = (Logging.Warning)((Logging.LogEventWithCause)warning);
                    Logger$.MODULE$.apply(logClass$2, logSource$2).warn(this.$outer.org$apache$pekko$event$slf4j$Slf4jLogger$$markerIfPresent((Logging.LogEvent)event$2), message$2 != null ? message$2.toString() : ((Logging.LogEventWithCause)e).cause().getLocalizedMessage(), ((Logging.LogEventWithCause)e).cause());
                    return;
                }
                Logger$.MODULE$.apply(logClass$2, logSource$2).warn(this.$outer.org$apache$pekko$event$slf4j$Slf4jLogger$$markerIfPresent((Logging.LogEvent)event$2), message$2 != null ? message$2.toString() : null);
            }

            private final void applyOrElse$$anonfun$3(Object message$3, Class logClass$3, String logSource$3, Logging.Info event$3) {
                Logger$.MODULE$.apply(logClass$3, logSource$3).info(this.$outer.org$apache$pekko$event$slf4j$Slf4jLogger$$markerIfPresent((Logging.LogEvent)event$3), "{}", message$3);
            }

            private final void applyOrElse$$anonfun$4(Object message$4, Class logClass$4, String logSource$4, Logging.Debug event$4) {
                Logger$.MODULE$.apply(logClass$4, logSource$4).debug(this.$outer.org$apache$pekko$event$slf4j$Slf4jLogger$$markerIfPresent((Logging.LogEvent)event$4), "{}", message$4);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$adapted$1(java.lang.Object java.lang.Class java.lang.String java.lang.Throwable org.apache.pekko.event.Logging$Error ), applyOrElse$$anonfun$adapted$2(java.lang.Object java.lang.Class java.lang.String org.apache.pekko.event.Logging$Warning ), applyOrElse$$anonfun$adapted$3(java.lang.Object java.lang.Class java.lang.String org.apache.pekko.event.Logging$Info ), applyOrElse$$anonfun$adapted$4(java.lang.Object java.lang.Class java.lang.String org.apache.pekko.event.Logging$Debug )}, serializedLambda);
            }
        };
    }

    public final void withMdc(String logSource, Logging.LogEvent logEvent, Function0<BoxedUnit> logStatement) {
        Map properties;
        Logging.LogEventWithMarker m;
        Logging.LogEvent logEvent2 = logEvent;
        if (logEvent2 instanceof Logging.LogEventWithMarker && (m = (Logging.LogEventWithMarker)logEvent2).marker() != null && (properties = m.marker().properties()).nonEmpty()) {
            properties.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Object v = tuple2._2();
                    MDC.put((String)k, (String)String.valueOf(v));
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
        }
        MDC.put((String)this.mdcPekkoSourceAttributeName(), (String)logSource);
        MDC.put((String)this.mdcThreadAttributeName(), (String)logEvent.thread().getName());
        MDC.put((String)this.mdcPekkoTimestamp(), (String)this.formatTimestamp(logEvent.timestamp()));
        MDC.put((String)this.mdcActorSystemAttributeName(), (String)this.context().system().name());
        MDC.put((String)this.mdcPekkoAddressAttributeName(), (String)this.pekkoAddress());
        MDC.put((String)this.mdcPekkoUidAttributeName(), (String)this.pekkoUid);
        logEvent.mdc().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                MDC.put((String)k, (String)String.valueOf(v));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        try {
            logStatement.apply$mcV$sp();
        }
        finally {
            MDC.clear();
        }
    }

    public final Marker org$apache$pekko$event$slf4j$Slf4jLogger$$markerIfPresent(Logging.LogEvent event) {
        Logging.LogEvent logEvent = event;
        if (logEvent instanceof Logging.LogEventWithMarker) {
            Logging.LogEventWithMarker m = (Logging.LogEventWithMarker)logEvent;
            LogMarker logMarker = m.marker();
            if (logMarker == null) {
                return null;
            }
            if (logMarker instanceof Slf4jLogMarker) {
                Slf4jLogMarker slf4jMarker = (Slf4jLogMarker)logMarker;
                return slf4jMarker.marker();
            }
            LogMarker marker = logMarker;
            return MarkerFactory.getMarker((String)marker.name());
        }
        return null;
    }

    public String formatTimestamp(long timestamp) {
        return Helpers$.MODULE$.currentTimeMillisToUTCString(timestamp);
    }
}

