/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport.netty;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.remote.RemoteTransportException;
import org.apache.pekko.remote.artery.tcp.SecureRandomFactory$;
import org.apache.pekko.remote.transport.netty.SSLEngineProvider;
import org.apache.pekko.remote.transport.netty.SSLSettings;
import org.apache.pekko.stream.Client$;
import org.apache.pekko.stream.Server$;
import org.apache.pekko.stream.TLSRole;
import scala.Function0;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Try$;

public class ConfigSSLEngineProvider
implements SSLEngineProvider {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ConfigSSLEngineProvider.class.getDeclaredField("sslContext$lzy1"));
    private final MarkerLoggingAdapter log;
    private final SSLSettings settings;
    private volatile Object sslContext$lzy1;

    public ConfigSSLEngineProvider(MarkerLoggingAdapter log, SSLSettings settings) {
        this.log = log;
        this.settings = settings;
    }

    public MarkerLoggingAdapter log() {
        return this.log;
    }

    private SSLSettings settings() {
        return this.settings;
    }

    public ConfigSSLEngineProvider(ActorSystem system) {
        this(Logging$.MODULE$.withMarker(system, (Object)ConfigSSLEngineProvider.class.getName(), LogSource$.MODULE$.fromString()), new SSLSettings(system.settings().config().getConfig("pekko.remote.classic.netty.ssl.security")));
    }

    private SSLContext sslContext() {
        Object object = this.sslContext$lzy1;
        if (object instanceof SSLContext) {
            return (SSLContext)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (SSLContext)this.sslContext$lzyINIT1();
    }

    private Object sslContext$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.sslContext$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    SSLContext sSLContext = null;
                    try {
                        sSLContext = this.liftedTree1$1();
                        object2 = sSLContext == null ? LazyVals.NullValue$.MODULE$ : sSLContext;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.sslContext$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return sSLContext;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public KeyStore loadKeystore(String filename, String password) {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        InputStream fin = Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]);
        try {
            keyStore.load(fin, password.toCharArray());
        }
        finally {
            Try$.MODULE$.apply((Function0 & Serializable)() -> {
                ConfigSSLEngineProvider.loadKeystore$$anonfun$1(fin);
                return BoxedUnit.UNIT;
            });
        }
        return keyStore;
    }

    public KeyManager[] keyManagers() {
        KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        factory.init(this.loadKeystore(this.settings().SSLKeyStore(), this.settings().SSLKeyStorePassword()), this.settings().SSLKeyPassword().toCharArray());
        return factory.getKeyManagers();
    }

    public TrustManager[] trustManagers() {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(this.loadKeystore(this.settings().SSLTrustStore(), this.settings().SSLTrustStorePassword()));
        return trustManagerFactory.getTrustManagers();
    }

    public SecureRandom createSecureRandom() {
        return SecureRandomFactory$.MODULE$.createSecureRandom(this.settings().SSLRandomNumberGenerator(), this.log());
    }

    @Override
    public SSLEngine createServerSSLEngine() {
        return this.createSSLEngine((TLSRole)Server$.MODULE$);
    }

    @Override
    public SSLEngine createClientSSLEngine() {
        return this.createSSLEngine((TLSRole)Client$.MODULE$);
    }

    private SSLEngine createSSLEngine(TLSRole role) {
        return this.createSSLEngine(this.sslContext(), role);
    }

    private SSLEngine createSSLEngine(SSLContext sslContext, TLSRole role) {
        SSLEngine engine = sslContext.createSSLEngine();
        TLSRole tLSRole = role;
        Client$ client$ = Client$.MODULE$;
        engine.setUseClientMode(!(tLSRole != null ? !tLSRole.equals(client$) : client$ != null));
        engine.setEnabledCipherSuites((String[])this.settings().SSLEnabledAlgorithms().toArray(ClassTag$.MODULE$.apply(String.class)));
        engine.setEnabledProtocols(new String[]{this.settings().SSLProtocol()});
        TLSRole tLSRole2 = role;
        Client$ client$2 = Client$.MODULE$;
        if ((tLSRole2 == null ? client$2 != null : !tLSRole2.equals(client$2)) && this.settings().SSLRequireMutualAuthentication()) {
            engine.setNeedClientAuth(true);
        }
        return engine;
    }

    /*
     * WARNING - void declaration
     */
    private final SSLContext liftedTree1$1() {
        void v0;
        try {
            void var2_2;
            SecureRandom rng = this.createSecureRandom();
            SSLContext ctx = SSLContext.getInstance(this.settings().SSLProtocol());
            ctx.init(this.keyManagers(), this.trustManagers(), rng);
            v0 = var2_2;
        }
        catch (FileNotFoundException e) {
            throw new RemoteTransportException("Server SSL connection could not be established because key store could not be loaded", e);
        }
        catch (IOException e) {
            throw new RemoteTransportException(new StringBuilder(56).append("Server SSL connection could not be established because: ").append(e.getMessage()).toString(), e);
        }
        catch (GeneralSecurityException e) {
            throw new RemoteTransportException("Server SSL connection could not be established because SSL context could not be constructed", e);
        }
        return v0;
    }

    private static final void loadKeystore$$anonfun$1(InputStream fin$1) {
        fin$1.close();
    }
}

