/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.AddressFromURIString$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.remote.transport.AssociationHandle;
import org.apache.pekko.remote.transport.AssociationHandle$Disassociated$;
import org.apache.pekko.remote.transport.AssociationHandle$InboundPayload$;
import org.apache.pekko.remote.transport.AssociationHandle$Unknown$;
import org.apache.pekko.remote.transport.AssociationRegistry$;
import org.apache.pekko.remote.transport.TestAssociationHandle;
import org.apache.pekko.remote.transport.TestTransport$;
import org.apache.pekko.remote.transport.TestTransport$AssociateAttempt$;
import org.apache.pekko.remote.transport.TestTransport$DisassociateAttempt$;
import org.apache.pekko.remote.transport.TestTransport$ListenAttempt$;
import org.apache.pekko.remote.transport.TestTransport$ShutdownAttempt$;
import org.apache.pekko.remote.transport.TestTransport$WriteAttempt$;
import org.apache.pekko.remote.transport.Transport;
import org.apache.pekko.remote.transport.Transport$InboundAssociation$;
import org.apache.pekko.util.ByteString;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class TestTransport
implements Transport {
    private final Address localAddress;
    private final AssociationRegistry registry;
    private final int maximumPayloadBytes;
    private final String schemeIdentifier;
    private final Promise<Transport.AssociationEventListener> associationListenerPromise;
    private final SwitchableLoggedBehavior listenBehavior;
    private final SwitchableLoggedBehavior associateBehavior;
    private final SwitchableLoggedBehavior shutdownBehavior;
    private final SwitchableLoggedBehavior writeBehavior;
    private final SwitchableLoggedBehavior disassociateBehavior;

    public static int $lessinit$greater$default$3() {
        return TestTransport$.MODULE$.$lessinit$greater$default$3();
    }

    public static String $lessinit$greater$default$4() {
        return TestTransport$.MODULE$.$lessinit$greater$default$4();
    }

    public TestTransport(Address localAddress, AssociationRegistry registry, int maximumPayloadBytes, String schemeIdentifier) {
        this.localAddress = localAddress;
        this.registry = registry;
        this.maximumPayloadBytes = maximumPayloadBytes;
        this.schemeIdentifier = schemeIdentifier;
        this.associationListenerPromise = Promise$.MODULE$.apply();
        this.listenBehavior = new SwitchableLoggedBehavior((Function1 & Serializable)_$2 -> this.defaultListen(), (JProcedure1 & Serializable)_$3 -> registry.logActivity(TestTransport$ListenAttempt$.MODULE$.apply(localAddress)));
        this.associateBehavior = new SwitchableLoggedBehavior((Function1 & Serializable)remoteAddress -> this.defaultAssociate((Address)remoteAddress), (JProcedure1 & Serializable)remoteAddress -> registry.logActivity(TestTransport$AssociateAttempt$.MODULE$.apply(localAddress, (Address)remoteAddress)));
        this.shutdownBehavior = new SwitchableLoggedBehavior((Function1 & Serializable)_$4 -> this.defaultShutdown(), (JProcedure1 & Serializable)_$5 -> registry.logActivity(TestTransport$ShutdownAttempt$.MODULE$.apply(localAddress)));
        this.writeBehavior = new SwitchableLoggedBehavior((Function1 & Serializable)params -> this.defaultWrite((Tuple2<TestAssociationHandle, ByteString>)params), (JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                TestAssociationHandle handle = (TestAssociationHandle)tuple2._1();
                ByteString payload = (ByteString)tuple2._2();
                registry.logActivity(TestTransport$WriteAttempt$.MODULE$.apply(handle.localAddress(), handle.remoteAddress(), payload));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        this.disassociateBehavior = new SwitchableLoggedBehavior((Function1 & Serializable)handle -> this.defaultDisassociate((TestAssociationHandle)handle), (JProcedure1 & Serializable)handle -> registry.logActivity(TestTransport$DisassociateAttempt$.MODULE$.apply(handle.localAddress(), handle.remoteAddress())));
    }

    public Address localAddress() {
        return this.localAddress;
    }

    public final AssociationRegistry registry() {
        return this.registry;
    }

    @Override
    public int maximumPayloadBytes() {
        return this.maximumPayloadBytes;
    }

    @Override
    public String schemeIdentifier() {
        return this.schemeIdentifier;
    }

    public TestTransport(ExtendedActorSystem system, Config conf) {
        this(AddressFromURIString$.MODULE$.apply(conf.getString("local-address")), AssociationRegistry$.MODULE$.get(conf.getString("registry-key")), (int)Predef$.MODULE$.Long2long(conf.getBytes("maximum-payload-bytes")), conf.getString("scheme-identifier"));
    }

    @Override
    public boolean isResponsibleFor(Address address) {
        return true;
    }

    private Future<Tuple2<Address, Promise<Transport.AssociationEventListener>>> defaultListen() {
        this.registry().registerTransport(this, (Future<Transport.AssociationEventListener>)this.associationListenerPromise.future());
        return Future$.MODULE$.successful((Object)Tuple2$.MODULE$.apply((Object)this.localAddress(), this.associationListenerPromise));
    }

    private Future<AssociationHandle> defaultAssociate(Address remoteAddress) {
        Tuple2 tuple2;
        Option<Tuple2<TestTransport, Future<Transport.AssociationEventListener>>> option = this.registry().transportFor(remoteAddress);
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            TestTransport remoteTransport = (TestTransport)tuple2._1();
            Future remoteListenerFuture = (Future)tuple2._2();
            Tuple2<TestAssociationHandle, TestAssociationHandle> tuple22 = this.createHandlePair(remoteTransport, remoteAddress);
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            TestAssociationHandle localHandle = (TestAssociationHandle)tuple22._1();
            TestAssociationHandle remoteHandle = (TestAssociationHandle)tuple22._2();
            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)localHandle, (Object)remoteHandle);
            TestAssociationHandle localHandle2 = (TestAssociationHandle)tuple23._1();
            TestAssociationHandle remoteHandle2 = (TestAssociationHandle)tuple23._2();
            localHandle2.writable_$eq(false);
            remoteHandle2.writable_$eq(false);
            return remoteListenerFuture.flatMap((Function1 & Serializable)x$1 -> {
                Transport.AssociationEventListener associationEventListener;
                Transport.AssociationEventListener listener = associationEventListener = x$1;
                listener.notify(Transport$InboundAssociation$.MODULE$.apply(remoteHandle2));
                Future remoteHandlerFuture = remoteHandle2.readHandlerPromise().future();
                remoteHandlerFuture.foreach((Function1)(JProcedure1 & Serializable)remoteListener -> localHandle2.readHandlerPromise().future().foreach((Function1)(JProcedure1 & Serializable)localListener -> {
                    this.registry().registerListenerPair(localHandle2.key(), (Tuple2<AssociationHandle.HandleEventListener, AssociationHandle.HandleEventListener>)Tuple2$.MODULE$.apply(localListener, remoteListener));
                    localHandle2.writable_$eq(true);
                    remoteHandle2.writable_$eq(true);
                }, ExecutionContext.Implicits$.MODULE$.global()), ExecutionContext.Implicits$.MODULE$.global());
                return remoteHandlerFuture.map((Function1 & Serializable)_$1 -> localHandle2, ExecutionContext.Implicits$.MODULE$.global());
            }, ExecutionContext.Implicits$.MODULE$.global());
        }
        if (None$.MODULE$.equals(option)) {
            return Future$.MODULE$.failed((Throwable)((Object)new Transport.InvalidAssociationException(new StringBuilder(25).append("No registered transport: ").append(remoteAddress).toString(), null)));
        }
        throw new MatchError(option);
    }

    private Tuple2<TestAssociationHandle, TestAssociationHandle> createHandlePair(TestTransport remoteTransport, Address remoteAddress) {
        TestAssociationHandle localHandle = new TestAssociationHandle(this.localAddress(), remoteAddress, this, false);
        TestAssociationHandle remoteHandle = new TestAssociationHandle(remoteAddress, this.localAddress(), remoteTransport, true);
        return Tuple2$.MODULE$.apply((Object)localHandle, (Object)remoteHandle);
    }

    private Future<Object> defaultShutdown() {
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public SwitchableLoggedBehavior<BoxedUnit, Tuple2<Address, Promise<Transport.AssociationEventListener>>> listenBehavior() {
        return this.listenBehavior;
    }

    public SwitchableLoggedBehavior<Address, AssociationHandle> associateBehavior() {
        return this.associateBehavior;
    }

    public SwitchableLoggedBehavior<BoxedUnit, Object> shutdownBehavior() {
        return this.shutdownBehavior;
    }

    @Override
    public Future<Tuple2<Address, Promise<Transport.AssociationEventListener>>> listen() {
        return this.listenBehavior().apply(BoxedUnit.UNIT);
    }

    public Address boundAddress() {
        return this.localAddress();
    }

    @Override
    public Future<AssociationHandle> associate(Address remoteAddress) {
        return this.associateBehavior().apply(remoteAddress);
    }

    @Override
    public Future<Object> shutdown() {
        return this.shutdownBehavior().apply(BoxedUnit.UNIT);
    }

    private Future<Object> defaultWrite(Tuple2<TestAssociationHandle, ByteString> params) {
        Option<AssociationHandle.HandleEventListener> option = this.registry().getRemoteReadHandlerFor((TestAssociationHandle)params._1());
        if (option instanceof Some) {
            AssociationHandle.HandleEventListener listener = (AssociationHandle.HandleEventListener)((Some)option).value();
            listener.notify(AssociationHandle$InboundPayload$.MODULE$.apply((ByteString)params._2()));
            return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        if (None$.MODULE$.equals(option)) {
            return Future$.MODULE$.failed((Throwable)new IllegalStateException("No association present"));
        }
        throw new MatchError(option);
    }

    private Future<BoxedUnit> defaultDisassociate(TestAssociationHandle handle) {
        this.registry().deregisterAssociation(handle.key()).foreach((Function1)(JProcedure1 & Serializable)_$6 -> this.registry().remoteListenerRelativeTo(handle, (Tuple2<AssociationHandle.HandleEventListener, AssociationHandle.HandleEventListener>)_$6).notify(AssociationHandle$Disassociated$.MODULE$.apply(AssociationHandle$Unknown$.MODULE$)));
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    public SwitchableLoggedBehavior<Tuple2<TestAssociationHandle, ByteString>, Object> writeBehavior() {
        return this.writeBehavior;
    }

    public SwitchableLoggedBehavior<TestAssociationHandle, BoxedUnit> disassociateBehavior() {
        return this.disassociateBehavior;
    }

    public boolean write(TestAssociationHandle handle, ByteString payload) {
        return BoxesRunTime.unboxToBoolean((Object)Await$.MODULE$.result(this.writeBehavior().apply((Tuple2<TestAssociationHandle, ByteString>)Tuple2$.MODULE$.apply((Object)handle, (Object)payload)), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(3)).seconds()));
    }

    public void disassociate(TestAssociationHandle handle) {
        this.disassociateBehavior().apply(handle);
    }

    public String toString() {
        return new StringBuilder(15).append("TestTransport(").append(this.localAddress()).append(")").toString();
    }

    public static interface Activity {
    }

    public static final class AssociateAttempt
    implements Activity,
    Product,
    Serializable {
        private final Address localAddress;
        private final Address remoteAddress;

        public static AssociateAttempt apply(Address address, Address address2) {
            return TestTransport$AssociateAttempt$.MODULE$.apply(address, address2);
        }

        public static AssociateAttempt fromProduct(Product product) {
            return TestTransport$AssociateAttempt$.MODULE$.fromProduct(product);
        }

        public static AssociateAttempt unapply(AssociateAttempt associateAttempt) {
            return TestTransport$AssociateAttempt$.MODULE$.unapply(associateAttempt);
        }

        public AssociateAttempt(Address localAddress, Address remoteAddress) {
            this.localAddress = localAddress;
            this.remoteAddress = remoteAddress;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AssociateAttempt)) return false;
            AssociateAttempt associateAttempt = (AssociateAttempt)object;
            Address address = this.localAddress();
            Address address2 = associateAttempt.localAddress();
            if (address == null) {
                if (address2 != null) {
                    return false;
                }
            } else if (!address.equals(address2)) return false;
            Address address3 = this.remoteAddress();
            Address address4 = associateAttempt.remoteAddress();
            if (address3 == null) {
                if (address4 == null) return true;
                return false;
            } else {
                if (!address3.equals(address4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AssociateAttempt;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "AssociateAttempt";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "localAddress";
            }
            if (1 == n2) {
                return "remoteAddress";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Address localAddress() {
            return this.localAddress;
        }

        public Address remoteAddress() {
            return this.remoteAddress;
        }

        public AssociateAttempt copy(Address localAddress, Address remoteAddress) {
            return new AssociateAttempt(localAddress, remoteAddress);
        }

        public Address copy$default$1() {
            return this.localAddress();
        }

        public Address copy$default$2() {
            return this.remoteAddress();
        }

        public Address _1() {
            return this.localAddress();
        }

        public Address _2() {
            return this.remoteAddress();
        }
    }

    public static class AssociationRegistry {
        private final CopyOnWriteArrayList<Activity> activityLog = new CopyOnWriteArrayList();
        private final ConcurrentHashMap<Address, Tuple2<TestTransport, Future<Transport.AssociationEventListener>>> transportTable = new ConcurrentHashMap();
        private final ConcurrentHashMap<Tuple2<Address, Address>, Tuple2<AssociationHandle.HandleEventListener, AssociationHandle.HandleEventListener>> listenersTable = new ConcurrentHashMap();

        public AssociationHandle.HandleEventListener remoteListenerRelativeTo(TestAssociationHandle handle, Tuple2<AssociationHandle.HandleEventListener, AssociationHandle.HandleEventListener> listenerPair) {
            Tuple2<AssociationHandle.HandleEventListener, AssociationHandle.HandleEventListener> tuple2 = listenerPair;
            if (tuple2 != null) {
                AssociationHandle.HandleEventListener initiator = (AssociationHandle.HandleEventListener)tuple2._1();
                AssociationHandle.HandleEventListener receiver = (AssociationHandle.HandleEventListener)tuple2._2();
                if (handle.inbound()) {
                    return initiator;
                }
                return receiver;
            }
            throw new MatchError(tuple2);
        }

        public void logActivity(Activity activity) {
            this.activityLog.add(activity);
        }

        public Seq<Activity> logSnapshot() {
            List result = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Activity[0]));
            Iterator<Activity> it = this.activityLog.iterator();
            while (it.hasNext()) {
                result = result.$colon$colon((Object)it.next());
            }
            return result.reverse();
        }

        public void clearLog() {
            this.activityLog.clear();
        }

        public void registerTransport(TestTransport transport, Future<Transport.AssociationEventListener> associationEventListenerFuture) {
            this.transportTable.put(transport.localAddress(), (Tuple2<TestTransport, Future<Transport.AssociationEventListener>>)Tuple2$.MODULE$.apply((Object)transport, associationEventListenerFuture));
        }

        public boolean transportsReady(Seq<Address> addresses) {
            return addresses.forall((Function1 & Serializable)_$10 -> this.transportTable.containsKey(_$10));
        }

        public void registerListenerPair(Tuple2<Address, Address> key, Tuple2<AssociationHandle.HandleEventListener, AssociationHandle.HandleEventListener> listeners) {
            this.listenersTable.put(key, listeners);
        }

        public Option<Tuple2<AssociationHandle.HandleEventListener, AssociationHandle.HandleEventListener>> deregisterAssociation(Tuple2<Address, Address> key) {
            return Option$.MODULE$.apply(this.listenersTable.remove(key));
        }

        public boolean existsAssociation(Address initiatorAddress, Address remoteAddress) {
            return this.listenersTable.containsKey(Tuple2$.MODULE$.apply((Object)initiatorAddress, (Object)remoteAddress));
        }

        public Option<AssociationHandle.HandleEventListener> getRemoteReadHandlerFor(TestAssociationHandle localHandle) {
            return Option$.MODULE$.apply(this.listenersTable.get(localHandle.key())).map((Function1 & Serializable)_$11 -> this.remoteListenerRelativeTo(localHandle, (Tuple2<AssociationHandle.HandleEventListener, AssociationHandle.HandleEventListener>)_$11));
        }

        public Option<Tuple2<TestTransport, Future<Transport.AssociationEventListener>>> transportFor(Address address) {
            return Option$.MODULE$.apply(this.transportTable.get(address));
        }

        public void reset() {
            this.clearLog();
            this.transportTable.clear();
            this.listenersTable.clear();
        }
    }

    public static final class DisassociateAttempt
    implements Activity,
    Product,
    Serializable {
        private final Address requester;
        private final Address remote;

        public static DisassociateAttempt apply(Address address, Address address2) {
            return TestTransport$DisassociateAttempt$.MODULE$.apply(address, address2);
        }

        public static DisassociateAttempt fromProduct(Product product) {
            return TestTransport$DisassociateAttempt$.MODULE$.fromProduct(product);
        }

        public static DisassociateAttempt unapply(DisassociateAttempt disassociateAttempt) {
            return TestTransport$DisassociateAttempt$.MODULE$.unapply(disassociateAttempt);
        }

        public DisassociateAttempt(Address requester, Address remote) {
            this.requester = requester;
            this.remote = remote;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DisassociateAttempt)) return false;
            DisassociateAttempt disassociateAttempt = (DisassociateAttempt)object;
            Address address = this.requester();
            Address address2 = disassociateAttempt.requester();
            if (address == null) {
                if (address2 != null) {
                    return false;
                }
            } else if (!address.equals(address2)) return false;
            Address address3 = this.remote();
            Address address4 = disassociateAttempt.remote();
            if (address3 == null) {
                if (address4 == null) return true;
                return false;
            } else {
                if (!address3.equals(address4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DisassociateAttempt;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "DisassociateAttempt";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "requester";
            }
            if (1 == n2) {
                return "remote";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Address requester() {
            return this.requester;
        }

        public Address remote() {
            return this.remote;
        }

        public DisassociateAttempt copy(Address requester, Address remote) {
            return new DisassociateAttempt(requester, remote);
        }

        public Address copy$default$1() {
            return this.requester();
        }

        public Address copy$default$2() {
            return this.remote();
        }

        public Address _1() {
            return this.requester();
        }

        public Address _2() {
            return this.remote();
        }
    }

    public static final class ListenAttempt
    implements Activity,
    Product,
    Serializable {
        private final Address boundAddress;

        public static ListenAttempt apply(Address address) {
            return TestTransport$ListenAttempt$.MODULE$.apply(address);
        }

        public static ListenAttempt fromProduct(Product product) {
            return TestTransport$ListenAttempt$.MODULE$.fromProduct(product);
        }

        public static ListenAttempt unapply(ListenAttempt listenAttempt) {
            return TestTransport$ListenAttempt$.MODULE$.unapply(listenAttempt);
        }

        public ListenAttempt(Address boundAddress) {
            this.boundAddress = boundAddress;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ListenAttempt)) return false;
            ListenAttempt listenAttempt = (ListenAttempt)object;
            Address address = this.boundAddress();
            Address address2 = listenAttempt.boundAddress();
            if (address != null) {
                if (!address.equals(address2)) return false;
                return true;
            }
            if (address2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ListenAttempt;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ListenAttempt";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "boundAddress";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Address boundAddress() {
            return this.boundAddress;
        }

        public ListenAttempt copy(Address boundAddress) {
            return new ListenAttempt(boundAddress);
        }

        public Address copy$default$1() {
            return this.boundAddress();
        }

        public Address _1() {
            return this.boundAddress();
        }
    }

    public static final class ShutdownAttempt
    implements Activity,
    Product,
    Serializable {
        private final Address boundAddress;

        public static ShutdownAttempt apply(Address address) {
            return TestTransport$ShutdownAttempt$.MODULE$.apply(address);
        }

        public static ShutdownAttempt fromProduct(Product product) {
            return TestTransport$ShutdownAttempt$.MODULE$.fromProduct(product);
        }

        public static ShutdownAttempt unapply(ShutdownAttempt shutdownAttempt) {
            return TestTransport$ShutdownAttempt$.MODULE$.unapply(shutdownAttempt);
        }

        public ShutdownAttempt(Address boundAddress) {
            this.boundAddress = boundAddress;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ShutdownAttempt)) return false;
            ShutdownAttempt shutdownAttempt = (ShutdownAttempt)object;
            Address address = this.boundAddress();
            Address address2 = shutdownAttempt.boundAddress();
            if (address != null) {
                if (!address.equals(address2)) return false;
                return true;
            }
            if (address2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ShutdownAttempt;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ShutdownAttempt";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "boundAddress";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Address boundAddress() {
            return this.boundAddress;
        }

        public ShutdownAttempt copy(Address boundAddress) {
            return new ShutdownAttempt(boundAddress);
        }

        public Address copy$default$1() {
            return this.boundAddress();
        }

        public Address _1() {
            return this.boundAddress();
        }
    }

    public static class SwitchableLoggedBehavior<A, B>
    implements Function1<A, Future<B>> {
        private final Function1<A, BoxedUnit> logCallback;
        private final CopyOnWriteArrayList<Function1<A, Future<B>>> behaviorStack;

        public SwitchableLoggedBehavior(Function1<A, Future<B>> defaultBehavior, Function1<A, BoxedUnit> logCallback) {
            this.logCallback = logCallback;
            this.behaviorStack = new CopyOnWriteArrayList();
            this.behaviorStack.add(0, defaultBehavior);
        }

        public void push(Function1<A, Future<B>> behavior) {
            this.behaviorStack.add(0, behavior);
        }

        public void pushConstant(B c) {
            this.push((Function1 & Serializable)_$7 -> Future$.MODULE$.successful(c));
        }

        public void pushError(Throwable e) {
            this.push((Function1 & Serializable)_$8 -> Future$.MODULE$.failed(e));
        }

        public Promise<BoxedUnit> pushDelayed() {
            Promise controlPromise = Promise$.MODULE$.apply();
            Function1<A, Future<B>> originalBehavior = this.currentBehavior();
            this.push((Function1 & Serializable)params -> controlPromise.future().flatMap((Function1 & Serializable)_$9 -> (Future)originalBehavior.apply(params), ExecutionContext.Implicits$.MODULE$.global()));
            return controlPromise;
        }

        public void pop() {
            if (this.behaviorStack.size() > 1) {
                this.behaviorStack.remove(0);
                return;
            }
        }

        private Function1<A, Future<B>> currentBehavior() {
            return this.behaviorStack.get(0);
        }

        public Future<B> apply(A params) {
            this.logCallback.apply(params);
            return (Future)this.currentBehavior().apply(params);
        }
    }

    public static final class WriteAttempt
    implements Activity,
    Product,
    Serializable {
        private final Address sender;
        private final Address recipient;
        private final ByteString payload;

        public static WriteAttempt apply(Address address, Address address2, ByteString byteString) {
            return TestTransport$WriteAttempt$.MODULE$.apply(address, address2, byteString);
        }

        public static WriteAttempt fromProduct(Product product) {
            return TestTransport$WriteAttempt$.MODULE$.fromProduct(product);
        }

        public static WriteAttempt unapply(WriteAttempt writeAttempt) {
            return TestTransport$WriteAttempt$.MODULE$.unapply(writeAttempt);
        }

        public WriteAttempt(Address sender, Address recipient, ByteString payload) {
            this.sender = sender;
            this.recipient = recipient;
            this.payload = payload;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WriteAttempt)) return false;
            WriteAttempt writeAttempt = (WriteAttempt)object;
            Address address = this.sender();
            Address address2 = writeAttempt.sender();
            if (address == null) {
                if (address2 != null) {
                    return false;
                }
            } else if (!address.equals(address2)) return false;
            Address address3 = this.recipient();
            Address address4 = writeAttempt.recipient();
            if (address3 == null) {
                if (address4 != null) {
                    return false;
                }
            } else if (!address3.equals(address4)) return false;
            ByteString byteString = this.payload();
            ByteString byteString2 = writeAttempt.payload();
            if (byteString == null) {
                if (byteString2 == null) return true;
                return false;
            } else {
                if (!byteString.equals(byteString2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WriteAttempt;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "WriteAttempt";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "sender";
                }
                case 1: {
                    return "recipient";
                }
                case 2: {
                    return "payload";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Address sender() {
            return this.sender;
        }

        public Address recipient() {
            return this.recipient;
        }

        public ByteString payload() {
            return this.payload;
        }

        public WriteAttempt copy(Address sender, Address recipient, ByteString payload) {
            return new WriteAttempt(sender, recipient, payload);
        }

        public Address copy$default$1() {
            return this.sender();
        }

        public Address copy$default$2() {
            return this.recipient();
        }

        public ByteString copy$default$3() {
            return this.payload();
        }

        public Address _1() {
            return this.sender();
        }

        public Address _2() {
            return this.recipient();
        }

        public ByteString _3() {
            return this.payload();
        }
    }
}

