/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport;

import java.io.Serializable;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.DeadLetterSuppression;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.transport.AssociationHandle$ActorHandleEventListener$;
import org.apache.pekko.remote.transport.AssociationHandle$Disassociated$;
import org.apache.pekko.remote.transport.AssociationHandle$InboundPayload$;
import org.apache.pekko.util.ByteString;
import scala.Product;
import scala.concurrent.Promise;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface AssociationHandle {
    public Address localAddress();

    public Address remoteAddress();

    public Promise<HandleEventListener> readHandlerPromise();

    public boolean write(ByteString var1);

    public void disassociate();

    public static void disassociate$(AssociationHandle $this, String reason, LoggingAdapter log) {
        $this.disassociate(reason, log);
    }

    default public void disassociate(String reason, LoggingAdapter log) {
        if (log.isDebugEnabled()) {
            log.debug("Association between local [{}] and remote [{}] was disassociated because {}", (Object)this.localAddress(), (Object)this.remoteAddress(), (Object)reason);
        }
        this.disassociate();
    }

    public static final class ActorHandleEventListener
    implements HandleEventListener,
    Product,
    Serializable {
        private final ActorRef actor;

        public static ActorHandleEventListener apply(ActorRef actorRef) {
            return AssociationHandle$ActorHandleEventListener$.MODULE$.apply(actorRef);
        }

        public static ActorHandleEventListener fromProduct(Product product) {
            return AssociationHandle$ActorHandleEventListener$.MODULE$.fromProduct(product);
        }

        public static ActorHandleEventListener unapply(ActorHandleEventListener actorHandleEventListener) {
            return AssociationHandle$ActorHandleEventListener$.MODULE$.unapply(actorHandleEventListener);
        }

        public ActorHandleEventListener(ActorRef actor) {
            this.actor = actor;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ActorHandleEventListener)) return false;
            ActorHandleEventListener actorHandleEventListener = (ActorHandleEventListener)object;
            ActorRef actorRef = this.actor();
            ActorRef actorRef2 = actorHandleEventListener.actor();
            if (actorRef != null) {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ActorHandleEventListener;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ActorHandleEventListener";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "actor";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ActorRef actor() {
            return this.actor;
        }

        @Override
        public void notify(HandleEvent ev) {
            this.actor().$bang((Object)ev, this.actor().$bang$default$2((Object)ev));
        }

        public ActorHandleEventListener copy(ActorRef actor) {
            return new ActorHandleEventListener(actor);
        }

        public ActorRef copy$default$1() {
            return this.actor();
        }

        public ActorRef _1() {
            return this.actor();
        }
    }

    public static interface DisassociateInfo {
    }

    public static final class Disassociated
    implements HandleEvent,
    DeadLetterSuppression,
    Product,
    Serializable {
        private final DisassociateInfo info;

        public static Disassociated apply(DisassociateInfo disassociateInfo) {
            return AssociationHandle$Disassociated$.MODULE$.apply(disassociateInfo);
        }

        public static Disassociated fromProduct(Product product) {
            return AssociationHandle$Disassociated$.MODULE$.fromProduct(product);
        }

        public static Disassociated unapply(Disassociated disassociated) {
            return AssociationHandle$Disassociated$.MODULE$.unapply(disassociated);
        }

        public Disassociated(DisassociateInfo info) {
            this.info = info;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Disassociated)) return false;
            Disassociated disassociated = (Disassociated)object;
            DisassociateInfo disassociateInfo = this.info();
            DisassociateInfo disassociateInfo2 = disassociated.info();
            if (disassociateInfo != null) {
                if (!disassociateInfo.equals(disassociateInfo2)) return false;
                return true;
            }
            if (disassociateInfo2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Disassociated;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Disassociated";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "info";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public DisassociateInfo info() {
            return this.info;
        }

        public Disassociated copy(DisassociateInfo info) {
            return new Disassociated(info);
        }

        public DisassociateInfo copy$default$1() {
            return this.info();
        }

        public DisassociateInfo _1() {
            return this.info();
        }
    }

    public static interface HandleEvent
    extends NoSerializationVerificationNeeded {
    }

    public static interface HandleEventListener {
        public void notify(HandleEvent var1);
    }

    public static final class InboundPayload
    implements HandleEvent,
    Product,
    Serializable {
        private final ByteString payload;

        public static InboundPayload apply(ByteString byteString) {
            return AssociationHandle$InboundPayload$.MODULE$.apply(byteString);
        }

        public static InboundPayload fromProduct(Product product) {
            return AssociationHandle$InboundPayload$.MODULE$.fromProduct(product);
        }

        public static InboundPayload unapply(InboundPayload inboundPayload) {
            return AssociationHandle$InboundPayload$.MODULE$.unapply(inboundPayload);
        }

        public InboundPayload(ByteString payload) {
            this.payload = payload;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof InboundPayload)) return false;
            InboundPayload inboundPayload = (InboundPayload)object;
            ByteString byteString = this.payload();
            ByteString byteString2 = inboundPayload.payload();
            if (byteString != null) {
                if (!byteString.equals(byteString2)) return false;
                return true;
            }
            if (byteString2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof InboundPayload;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "InboundPayload";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "payload";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ByteString payload() {
            return this.payload;
        }

        public String toString() {
            return new StringBuilder(29).append("InboundPayload(size = ").append(this.payload().length()).append(" bytes)").toString();
        }

        public InboundPayload copy(ByteString payload) {
            return new InboundPayload(payload);
        }

        public ByteString copy$default$1() {
            return this.payload();
        }

        public ByteString _1() {
            return this.payload();
        }
    }
}

