/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport;

import org.apache.pekko.actor.Address;
import org.apache.pekko.remote.transport.AssociationHandle;
import org.apache.pekko.remote.transport.SchemeAugmenter;

public abstract class AbstractTransportAdapterHandle
implements AssociationHandle,
SchemeAugmenter {
    private final Address originalLocalAddress;
    private final Address originalRemoteAddress;
    private final AssociationHandle wrappedHandle;
    private final String addedSchemeIdentifier;
    private final Address localAddress;
    private final Address remoteAddress;

    public AbstractTransportAdapterHandle(Address originalLocalAddress, Address originalRemoteAddress, AssociationHandle wrappedHandle, String addedSchemeIdentifier) {
        this.originalLocalAddress = originalLocalAddress;
        this.originalRemoteAddress = originalRemoteAddress;
        this.wrappedHandle = wrappedHandle;
        this.addedSchemeIdentifier = addedSchemeIdentifier;
        this.localAddress = this.augmentScheme(originalLocalAddress);
        this.remoteAddress = this.augmentScheme(originalRemoteAddress);
    }

    public Address originalLocalAddress() {
        return this.originalLocalAddress;
    }

    public Address originalRemoteAddress() {
        return this.originalRemoteAddress;
    }

    public AssociationHandle wrappedHandle() {
        return this.wrappedHandle;
    }

    @Override
    public String addedSchemeIdentifier() {
        return this.addedSchemeIdentifier;
    }

    public AbstractTransportAdapterHandle(AssociationHandle wrappedHandle, String addedSchemeIdentifier) {
        this(wrappedHandle.localAddress(), wrappedHandle.remoteAddress(), wrappedHandle, addedSchemeIdentifier);
    }

    @Override
    public Address localAddress() {
        return this.localAddress;
    }

    @Override
    public Address remoteAddress() {
        return this.remoteAddress;
    }
}

