/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport;

import java.io.Serializable;
import org.apache.pekko.actor.Address;
import org.apache.pekko.remote.transport.AssociationHandle;
import org.apache.pekko.remote.transport.SchemeAugmenter;
import org.apache.pekko.remote.transport.TestTransport;
import org.apache.pekko.remote.transport.Transport;
import org.apache.pekko.remote.transport.netty.NettyTransport;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;

public abstract class AbstractTransportAdapter
implements Transport,
SchemeAugmenter {
    private final Transport wrappedTransport;
    private final ExecutionContext ec;

    public AbstractTransportAdapter(Transport wrappedTransport, ExecutionContext ec) {
        this.wrappedTransport = wrappedTransport;
        this.ec = ec;
    }

    public Transport wrappedTransport() {
        return this.wrappedTransport;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public abstract int maximumOverhead();

    public abstract Future<Transport.AssociationEventListener> interceptListen(Address var1, Future<Transport.AssociationEventListener> var2);

    public abstract void interceptAssociate(Address var1, Promise<AssociationHandle> var2);

    @Override
    public String schemeIdentifier() {
        return this.augmentScheme(this.wrappedTransport().schemeIdentifier());
    }

    @Override
    public boolean isResponsibleFor(Address address) {
        return this.wrappedTransport().isResponsibleFor(address);
    }

    @Override
    public int maximumPayloadBytes() {
        return this.wrappedTransport().maximumPayloadBytes() - this.maximumOverhead();
    }

    @Override
    public Future<Tuple2<Address, Promise<Transport.AssociationEventListener>>> listen() {
        Promise upstreamListenerPromise = Promise$.MODULE$.apply();
        return this.wrappedTransport().listen().withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Address listenAddress = (Address)tuple2._1();
                Promise listenerPromise = (Promise)tuple2._2();
                return true;
            }
            return false;
        }, this.ec()).flatMap((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                Address listenAddress = (Address)tuple2._1();
                Promise listenerPromise = (Promise)tuple2._2();
                return listenerPromise.completeWith(this.interceptListen(listenAddress, (Future<Transport.AssociationEventListener>)upstreamListenerPromise.future())).future().map((Function1 & Serializable)x$1 -> {
                    Transport.AssociationEventListener associationEventListener = x$1;
                    return Tuple2$.MODULE$.apply((Object)this.augmentScheme(listenAddress), (Object)upstreamListenerPromise);
                }, this.ec());
            }
            throw new MatchError((Object)tuple2);
        }, this.ec());
    }

    public Address boundAddress() {
        Transport transport = this.wrappedTransport();
        if (transport instanceof AbstractTransportAdapter) {
            AbstractTransportAdapter t = (AbstractTransportAdapter)transport;
            return t.boundAddress();
        }
        if (transport instanceof NettyTransport) {
            NettyTransport t = (NettyTransport)transport;
            return t.boundAddress();
        }
        if (transport instanceof TestTransport) {
            TestTransport t = (TestTransport)transport;
            return t.boundAddress();
        }
        return null;
    }

    @Override
    public Future<AssociationHandle> associate(Address remoteAddress) {
        Promise statusPromise = Promise$.MODULE$.apply();
        this.interceptAssociate(this.removeScheme(remoteAddress), (Promise<AssociationHandle>)statusPromise);
        return statusPromise.future();
    }

    @Override
    public Future<Object> shutdown() {
        return this.wrappedTransport().shutdown();
    }
}

