/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.serialization;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.protobufv3.internal.ByteString;
import org.apache.pekko.remote.ByteStringUtils$;
import org.apache.pekko.remote.ContainerFormats;
import org.apache.pekko.remote.serialization.ThrowableNotSerializableException;
import org.apache.pekko.serialization.ByteBufferSerializer;
import org.apache.pekko.serialization.DisabledJavaSerializer;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.SerializerWithStringManifest;
import org.apache.pekko.serialization.Serializers$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class WrappedPayloadSupport$
implements Serializable {
    public static final WrappedPayloadSupport$ MODULE$ = new WrappedPayloadSupport$();

    private WrappedPayloadSupport$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(WrappedPayloadSupport$.class);
    }

    public ContainerFormats.Payload.Builder payloadBuilder(Object input, Serialization serialization, LoggingAdapter log) {
        ContainerFormats.Payload.Builder builder;
        block1: {
            Serializer serializer;
            Object payload;
            block0: {
                payload = input;
                builder = ContainerFormats.Payload.newBuilder();
                serializer = serialization.findSerializerFor(payload);
                Object object = payload;
                if (!(object instanceof Throwable)) break block0;
                Throwable t = (Throwable)object;
                if (!(serializer instanceof DisabledJavaSerializer)) break block0;
                ThrowableNotSerializableException notSerializableException = new ThrowableNotSerializableException(t.getMessage(), t.getClass().getName(), t.getCause());
                log.debug("Couldn't serialize [{}] because Java serialization is disabled. Fallback to ThrowableNotSerializableException. {}", (Object)notSerializableException.originalClassName(), (Object)notSerializableException.originalMessage());
                Serializer serializer2 = serialization.findSerializerFor((Object)notSerializableException);
                builder.setEnclosedMessage(ByteStringUtils$.MODULE$.toProtoByteStringUnsafe(serializer2.toBinary((Object)notSerializableException))).setSerializerId(serializer2.identifier());
                String manifest = Serializers$.MODULE$.manifestFor(serializer2, (Object)notSerializableException);
                if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(manifest))) break block1;
                builder.setMessageManifest(ByteString.copyFromUtf8((String)manifest));
                break block1;
            }
            builder.setEnclosedMessage(ByteStringUtils$.MODULE$.toProtoByteStringUnsafe(serializer.toBinary(payload))).setSerializerId(serializer.identifier());
            String manifest = Serializers$.MODULE$.manifestFor(serializer, payload);
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(manifest))) break block1;
            builder.setMessageManifest(ByteString.copyFromUtf8((String)manifest));
        }
        return builder;
    }

    public Object deserializePayload(ContainerFormats.Payload payload, Serialization serialization) {
        String manifest = payload.hasMessageManifest() ? payload.getMessageManifest().toStringUtf8() : "";
        Serializer serializer = (Serializer)serialization.serializerByIdentity().apply((Object)BoxesRunTime.boxToInteger((int)payload.getSerializerId()));
        if (serializer instanceof ByteBufferSerializer) {
            ByteBufferSerializer serializer2 = (ByteBufferSerializer)serializer;
            ByteBuffer buffer = payload.getEnclosedMessage().asReadOnlyByteBuffer();
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            return serializer2.fromBinary(buffer, manifest);
        }
        if (serializer instanceof SerializerWithStringManifest) {
            SerializerWithStringManifest serializer3 = (SerializerWithStringManifest)serializer;
            return serializer3.fromBinary(payload.getEnclosedMessage().toByteArray(), manifest);
        }
        return serialization.deserialize(payload.getEnclosedMessage().toByteArray(), payload.getSerializerId(), manifest).get();
    }
}

